/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.jpa.mdm.dao.MdmLinkDaoSvc;
import ca.uhn.fhir.jpa.mdm.svc.candidate.MatchedGoldenResourceCandidate;
import ca.uhn.fhir.jpa.mdm.svc.candidate.MdmGoldenResourceFindingSvc;
import ca.uhn.fhir.mdm.api.IMdmLink;
import ca.uhn.fhir.mdm.api.IMdmLinkSvc;
import ca.uhn.fhir.mdm.api.IMdmResourceDaoSvc;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.api.IMdmSurvivorshipService;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmMatchOutcome;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.mdm.util.EIDHelper;
import ca.uhn.fhir.mdm.util.GoldenResourceHelper;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdmEidUpdateService {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private IMdmResourceDaoSvc myMdmResourceDaoSvc;
    @Autowired
    private IMdmLinkSvc myMdmLinkSvc;
    @Autowired
    private MdmGoldenResourceFindingSvc myMdmGoldenResourceFindingSvc;
    @Autowired
    private GoldenResourceHelper myGoldenResourceHelper;
    @Autowired
    private EIDHelper myEIDHelper;
    @Autowired
    private MdmLinkDaoSvc myMdmLinkDaoSvc;
    @Autowired
    private IMdmSettings myMdmSettings;
    @Autowired
    private IMdmSurvivorshipService myMdmSurvivorshipService;

    void handleMdmUpdate(IAnyResource theTargetResource, MatchedGoldenResourceCandidate theMatchedGoldenResourceCandidate, MdmTransactionContext theMdmTransactionContext) {
        MdmUpdateContext updateContext = new MdmUpdateContext(theMatchedGoldenResourceCandidate, theTargetResource);
        this.myMdmSurvivorshipService.applySurvivorshipRulesToGoldenResource((IBase)theTargetResource, (IBase)updateContext.getMatchedGoldenResource(), theMdmTransactionContext);
        IAnyResource theOldGoldenResource = updateContext.getExistingGoldenResource();
        if (updateContext.isRemainsMatchedToSameGoldenResource()) {
            if (!updateContext.isIncomingResourceHasAnEid() || updateContext.isHasEidsInCommon()) {
                this.myMdmLinkSvc.updateLink(updateContext.getMatchedGoldenResource(), theTargetResource, theMatchedGoldenResourceCandidate.getMatchResult(), MdmLinkSourceEnum.AUTO, theMdmTransactionContext);
            } else if (!updateContext.isHasEidsInCommon()) {
                this.handleNoEidsInCommon(theTargetResource, theMatchedGoldenResourceCandidate, theMdmTransactionContext, updateContext);
            }
        } else if (theOldGoldenResource == null) {
            this.myMdmSurvivorshipService.applySurvivorshipRulesToGoldenResource((IBase)theTargetResource, (IBase)updateContext.getMatchedGoldenResource(), theMdmTransactionContext);
            this.myMdmResourceDaoSvc.upsertGoldenResource(updateContext.getMatchedGoldenResource(), theMdmTransactionContext.getResourceType());
            this.myMdmLinkSvc.updateLink(updateContext.getMatchedGoldenResource(), theTargetResource, theMatchedGoldenResourceCandidate.getMatchResult(), MdmLinkSourceEnum.AUTO, theMdmTransactionContext);
        } else {
            this.linkToNewGoldenResourceAndFlagAsDuplicate(theTargetResource, theMatchedGoldenResourceCandidate.getMatchResult(), theOldGoldenResource, updateContext.getMatchedGoldenResource(), theMdmTransactionContext);
            this.myMdmSurvivorshipService.applySurvivorshipRulesToGoldenResource((IBase)theTargetResource, (IBase)updateContext.getMatchedGoldenResource(), theMdmTransactionContext);
            this.myMdmResourceDaoSvc.upsertGoldenResource(updateContext.getMatchedGoldenResource(), theMdmTransactionContext.getResourceType());
        }
    }

    private void handleNoEidsInCommon(IAnyResource theResource, MatchedGoldenResourceCandidate theMatchedGoldenResourceCandidate, MdmTransactionContext theMdmTransactionContext, MdmUpdateContext theUpdateContext) {
        if (this.myMdmSettings.isPreventMultipleEids()) {
            if (this.myMdmLinkDaoSvc.findMdmMatchLinksByGoldenResource((IBaseResource)theUpdateContext.getMatchedGoldenResource()).size() <= 1) {
                this.handleExternalEidOverwrite(theUpdateContext.getMatchedGoldenResource(), theResource, theMdmTransactionContext);
            } else {
                this.createNewGoldenResourceAndFlagAsDuplicate(theResource, theMdmTransactionContext, theUpdateContext.getExistingGoldenResource());
            }
        } else {
            this.myGoldenResourceHelper.handleExternalEidAddition(theUpdateContext.getMatchedGoldenResource(), theResource, theMdmTransactionContext);
        }
        this.myMdmLinkSvc.updateLink(theUpdateContext.getMatchedGoldenResource(), theResource, theMatchedGoldenResourceCandidate.getMatchResult(), MdmLinkSourceEnum.AUTO, theMdmTransactionContext);
    }

    private void handleExternalEidOverwrite(IAnyResource theGoldenResource, IAnyResource theResource, MdmTransactionContext theMdmTransactionContext) {
        List eidFromResource = this.myEIDHelper.getExternalEid((IBaseResource)theResource);
        if (!eidFromResource.isEmpty()) {
            this.myGoldenResourceHelper.overwriteExternalEids((IBaseResource)theGoldenResource, eidFromResource);
        }
    }

    private boolean candidateIsSameAsMdmLinkGoldenResource(IMdmLink theExistingMatchLink, MatchedGoldenResourceCandidate theGoldenResourceCandidate) {
        return theExistingMatchLink.getGoldenResourcePersistenceId().equals(theGoldenResourceCandidate.getCandidateGoldenResourcePid());
    }

    private void createNewGoldenResourceAndFlagAsDuplicate(IAnyResource theResource, MdmTransactionContext theMdmTransactionContext, IAnyResource theOldGoldenResource) {
        this.log(theMdmTransactionContext, "Duplicate detected based on the fact that both resources have different external EIDs.");
        IAnyResource newGoldenResource = this.myGoldenResourceHelper.createGoldenResourceFromMdmSourceResource(theResource, theMdmTransactionContext, this.myMdmSurvivorshipService);
        this.myMdmLinkSvc.updateLink(newGoldenResource, theResource, MdmMatchOutcome.NEW_GOLDEN_RESOURCE_MATCH, MdmLinkSourceEnum.AUTO, theMdmTransactionContext);
        this.myMdmLinkSvc.updateLink(newGoldenResource, theOldGoldenResource, MdmMatchOutcome.POSSIBLE_DUPLICATE, MdmLinkSourceEnum.AUTO, theMdmTransactionContext);
    }

    private void linkToNewGoldenResourceAndFlagAsDuplicate(IAnyResource theResource, MdmMatchOutcome theMatchResult, IAnyResource theOldGoldenResource, IAnyResource theNewGoldenResource, MdmTransactionContext theMdmTransactionContext) {
        this.log(theMdmTransactionContext, "Changing a match link!");
        this.myMdmLinkSvc.deleteLink(theOldGoldenResource, theResource, theMdmTransactionContext);
        this.myMdmLinkSvc.updateLink(theNewGoldenResource, theResource, theMatchResult, MdmLinkSourceEnum.AUTO, theMdmTransactionContext);
        this.log(theMdmTransactionContext, "Duplicate detected based on the fact that both resources have different external EIDs.");
        this.myMdmLinkSvc.updateLink(theNewGoldenResource, theOldGoldenResource, MdmMatchOutcome.POSSIBLE_DUPLICATE, MdmLinkSourceEnum.AUTO, theMdmTransactionContext);
    }

    private void log(MdmTransactionContext theMdmTransactionContext, String theMessage) {
        theMdmTransactionContext.addTransactionLogMessage(theMessage);
        ourLog.debug(theMessage);
    }

    public void applySurvivorshipRulesAndSaveGoldenResource(IAnyResource theTargetResource, IAnyResource theGoldenResource, MdmTransactionContext theMdmTransactionContext) {
        this.myMdmSurvivorshipService.applySurvivorshipRulesToGoldenResource((IBase)theTargetResource, (IBase)theGoldenResource, theMdmTransactionContext);
        this.myMdmResourceDaoSvc.upsertGoldenResource(theGoldenResource, theMdmTransactionContext.getResourceType());
    }

    class MdmUpdateContext {
        private final boolean myHasEidsInCommon;
        private final boolean myIncomingResourceHasAnEid;
        private IAnyResource myExistingGoldenResource;
        private boolean myRemainsMatchedToSameGoldenResource;
        private final IAnyResource myMatchedGoldenResource;

        public IAnyResource getMatchedGoldenResource() {
            return this.myMatchedGoldenResource;
        }

        MdmUpdateContext(MatchedGoldenResourceCandidate theMatchedGoldenResourceCandidate, IAnyResource theResource) {
            String resourceType = theResource.getIdElement().getResourceType();
            this.myMatchedGoldenResource = MdmEidUpdateService.this.myMdmGoldenResourceFindingSvc.getGoldenResourceFromMatchedGoldenResourceCandidate(theMatchedGoldenResourceCandidate, resourceType);
            this.myHasEidsInCommon = MdmEidUpdateService.this.myEIDHelper.hasEidOverlap(this.myMatchedGoldenResource, theResource);
            this.myIncomingResourceHasAnEid = !MdmEidUpdateService.this.myEIDHelper.getExternalEid((IBaseResource)theResource).isEmpty();
            Optional theExistingMatchOrPossibleMatchLink = MdmEidUpdateService.this.myMdmLinkDaoSvc.getMatchedOrPossibleMatchedLinkForSource(theResource);
            this.myExistingGoldenResource = null;
            if (theExistingMatchOrPossibleMatchLink.isPresent()) {
                IMdmLink mdmLink = (IMdmLink)theExistingMatchOrPossibleMatchLink.get();
                IResourcePersistentId existingGoldenResourcePid = mdmLink.getGoldenResourcePersistenceId();
                this.myExistingGoldenResource = MdmEidUpdateService.this.myMdmResourceDaoSvc.readGoldenResourceByPid(existingGoldenResourcePid, resourceType);
                this.myRemainsMatchedToSameGoldenResource = MdmEidUpdateService.this.candidateIsSameAsMdmLinkGoldenResource(mdmLink, theMatchedGoldenResourceCandidate);
            } else {
                this.myRemainsMatchedToSameGoldenResource = false;
            }
        }

        public boolean isHasEidsInCommon() {
            return this.myHasEidsInCommon;
        }

        public boolean isIncomingResourceHasAnEid() {
            return this.myIncomingResourceHasAnEid;
        }

        @Nullable
        public IAnyResource getExistingGoldenResource() {
            return this.myExistingGoldenResource;
        }

        public boolean isRemainsMatchedToSameGoldenResource() {
            return this.myRemainsMatchedToSameGoldenResource;
        }

        public boolean hasExistingGoldenResource() {
            return this.myExistingGoldenResource != null;
        }
    }
}

