/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.mdm.dao.MdmLinkDaoSvc;
import ca.uhn.fhir.jpa.mdm.svc.IMdmModelConverterSvc;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.mdm.api.IMdmLink;
import ca.uhn.fhir.mdm.api.IMdmLinkCreateSvc;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.model.MdmCreateOrUpdateParams;
import ca.uhn.fhir.mdm.model.mdmevents.MdmLinkEvent;
import ca.uhn.fhir.mdm.util.MdmPartitionHelper;
import ca.uhn.fhir.mdm.util.MdmResourceUtil;
import ca.uhn.fhir.mdm.util.MessageHelper;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class MdmLinkCreateSvcImpl
implements IMdmLinkCreateSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    FhirContext myFhirContext;
    @Autowired
    IIdHelperService myIdHelperService;
    @Autowired
    MdmLinkDaoSvc myMdmLinkDaoSvc;
    @Autowired
    IMdmSettings myMdmSettings;
    @Autowired
    MessageHelper myMessageHelper;
    @Autowired
    MdmPartitionHelper myMdmPartitionHelper;
    @Autowired
    private IMdmModelConverterSvc myModelConverter;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;

    @Transactional
    public IAnyResource createLink(MdmCreateOrUpdateParams theParams) {
        IAnyResource sourceResource = theParams.getSourceResource();
        IAnyResource goldenResource = theParams.getGoldenResource();
        MdmMatchResultEnum matchResult = theParams.getMatchResult();
        String sourceType = this.myFhirContext.getResourceType((IBaseResource)sourceResource);
        this.validateCreateLinkRequest(goldenResource, sourceResource, sourceType);
        IResourcePersistentId goldenResourceId = this.myIdHelperService.getPidOrThrowException(goldenResource);
        IResourcePersistentId targetId = this.myIdHelperService.getPidOrThrowException(sourceResource);
        this.myMdmPartitionHelper.validateMdmResourcesPartitionMatches(goldenResource, sourceResource);
        Optional optionalMdmLink = this.myMdmLinkDaoSvc.getLinkByGoldenResourcePidAndSourceResourcePid(goldenResourceId, targetId);
        if (optionalMdmLink.isPresent()) {
            throw new InvalidRequestException(Msg.code((int)753) + this.myMessageHelper.getMessageForPresentLink(goldenResource, sourceResource));
        }
        List mdmLinks = this.myMdmLinkDaoSvc.getMdmLinksBySourcePidAndMatchResult(targetId, MdmMatchResultEnum.MATCH);
        if (mdmLinks.size() > 0 && matchResult == MdmMatchResultEnum.MATCH) {
            throw new InvalidRequestException(Msg.code((int)754) + this.myMessageHelper.getMessageForMultipleGoldenRecords(sourceResource));
        }
        Object mdmLink = this.myMdmLinkDaoSvc.getOrCreateMdmLinkByGoldenResourceAndSourceResource(goldenResource, sourceResource);
        mdmLink.setLinkSource(MdmLinkSourceEnum.MANUAL);
        mdmLink.setMdmSourceType(sourceType);
        if (matchResult == null) {
            mdmLink.setMatchResult(MdmMatchResultEnum.MATCH);
        } else {
            mdmLink.setMatchResult(matchResult);
        }
        RequestPartitionId goldenResourcePartitionId = (RequestPartitionId)goldenResource.getUserData(Constants.RESOURCE_PARTITION_ID);
        if (goldenResourcePartitionId != null && goldenResourcePartitionId.hasPartitionIds() && goldenResourcePartitionId.getFirstPartitionIdOrNull() != null && (mdmLink.getPartitionId() == null || mdmLink.getPartitionId().getPartitionId() == null)) {
            mdmLink.setPartitionId(new PartitionablePartitionId(goldenResourcePartitionId.getFirstPartitionIdOrNull(), goldenResourcePartitionId.getPartitionDate()));
        }
        ourLog.info("Manually creating a " + String.valueOf(goldenResource.getIdElement().toVersionless()) + " to " + String.valueOf(sourceResource.getIdElement().toVersionless()) + " mdm link.");
        this.myMdmLinkDaoSvc.save(mdmLink);
        if (this.myInterceptorBroadcaster.hasHooks((IPointcut)Pointcut.MDM_POST_CREATE_LINK)) {
            MdmLinkEvent event = new MdmLinkEvent();
            event.addMdmLink(this.myModelConverter.toJson((IMdmLink)mdmLink));
            HookParams hookParams = new HookParams();
            hookParams.add(RequestDetails.class, (Object)theParams.getRequestDetails()).add(MdmLinkEvent.class, (Object)event);
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.MDM_POST_CREATE_LINK, hookParams);
        }
        return goldenResource;
    }

    private void validateCreateLinkRequest(IAnyResource theGoldenRecord, IAnyResource theSourceResource, String theSourceType) {
        String goldenRecordType = this.myFhirContext.getResourceType((IBaseResource)theGoldenRecord);
        if (!this.myMdmSettings.isSupportedMdmType(goldenRecordType)) {
            throw new InvalidRequestException(Msg.code((int)755) + this.myMessageHelper.getMessageForUnsupportedFirstArgumentTypeInUpdate(goldenRecordType));
        }
        if (!this.myMdmSettings.isSupportedMdmType(theSourceType)) {
            throw new InvalidRequestException(Msg.code((int)756) + this.myMessageHelper.getMessageForUnsupportedSecondArgumentTypeInUpdate(theSourceType));
        }
        if (!Objects.equals(goldenRecordType, theSourceType)) {
            throw new InvalidRequestException(Msg.code((int)757) + this.myMessageHelper.getMessageForArgumentTypeMismatchInUpdate(goldenRecordType, theSourceType));
        }
        if (!MdmResourceUtil.isMdmManaged((IBaseResource)theGoldenRecord)) {
            throw new InvalidRequestException(Msg.code((int)758) + this.myMessageHelper.getMessageForUnmanagedResource());
        }
        if (!MdmResourceUtil.isMdmAllowed((IBaseResource)theSourceResource)) {
            throw new InvalidRequestException(Msg.code((int)759) + this.myMessageHelper.getMessageForUnsupportedSourceResource());
        }
    }
}

