/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.mdm.dao.MdmLinkDaoSvc;
import ca.uhn.fhir.mdm.api.IMdmLink;
import ca.uhn.fhir.mdm.api.IMdmLinkSvc;
import ca.uhn.fhir.mdm.api.IMdmResourceDaoSvc;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmMatchOutcome;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MdmLinkSvcImpl
implements IMdmLinkSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private IMdmResourceDaoSvc myMdmResourceDaoSvc;
    @Autowired
    private MdmLinkDaoSvc myMdmLinkDaoSvc;
    @Autowired
    private IIdHelperService myIdHelperService;

    @Transactional
    public void updateLink(@Nonnull IAnyResource theGoldenResource, @Nonnull IAnyResource theSourceResource, MdmMatchOutcome theMatchOutcome, MdmLinkSourceEnum theLinkSource, MdmTransactionContext theMdmTransactionContext) {
        if (theMatchOutcome.isPossibleDuplicate() && this.goldenResourceLinkedAsNoMatch(theGoldenResource, theSourceResource)) {
            this.log(theMdmTransactionContext, String.valueOf(theGoldenResource.getIdElement().toUnqualifiedVersionless()) + " is linked as NO_MATCH with " + String.valueOf(theSourceResource.getIdElement().toUnqualifiedVersionless()) + " not linking as POSSIBLE_DUPLICATE.");
            return;
        }
        MdmMatchResultEnum matchResultEnum = theMatchOutcome.getMatchResultEnum();
        this.validateRequestIsLegal(theGoldenResource, theSourceResource, matchResultEnum, theLinkSource);
        this.myMdmResourceDaoSvc.upsertGoldenResource(theGoldenResource, theMdmTransactionContext.getResourceType());
        IMdmLink link = this.createOrUpdateLinkEntity(theGoldenResource, theSourceResource, theMatchOutcome, theLinkSource, theMdmTransactionContext);
        theMdmTransactionContext.addMdmLink(link);
    }

    private boolean goldenResourceLinkedAsNoMatch(IAnyResource theGoldenResource, IAnyResource theSourceResource) {
        IResourcePersistentId sourceId;
        IResourcePersistentId goldenResourceId = this.myIdHelperService.getPidOrThrowException(theGoldenResource);
        return this.myMdmLinkDaoSvc.getMdmLinksByGoldenResourcePidSourcePidAndMatchResult(goldenResourceId, sourceId = this.myIdHelperService.getPidOrThrowException(theSourceResource), MdmMatchResultEnum.NO_MATCH).isPresent() || this.myMdmLinkDaoSvc.getMdmLinksByGoldenResourcePidSourcePidAndMatchResult(sourceId, goldenResourceId, MdmMatchResultEnum.NO_MATCH).isPresent();
    }

    public void deleteLink(IAnyResource theGoldenResource, IAnyResource theSourceResource, MdmTransactionContext theMdmTransactionContext) {
        if (theGoldenResource == null) {
            return;
        }
        Optional<? extends IMdmLink> optionalMdmLink = this.getMdmLinkForGoldenResourceSourceResourcePair(theGoldenResource, theSourceResource);
        if (optionalMdmLink.isPresent()) {
            IMdmLink mdmLink = optionalMdmLink.get();
            this.log(theMdmTransactionContext, "Deleting MdmLink [" + String.valueOf(theGoldenResource.getIdElement().toVersionless()) + " -> " + String.valueOf(theSourceResource.getIdElement().toVersionless()) + "] with result: " + String.valueOf(mdmLink.getMatchResult()));
            this.myMdmLinkDaoSvc.deleteLink(mdmLink);
            theMdmTransactionContext.addMdmLink(mdmLink);
        }
    }

    @Transactional
    public void deleteLinksWithAnyReferenceTo(List<IResourcePersistentId> theGoldenResourceIds) {
        this.myMdmLinkDaoSvc.deleteLinksWithAnyReferenceToPids(theGoldenResourceIds);
    }

    private void validateRequestIsLegal(IAnyResource theGoldenResource, IAnyResource theResource, MdmMatchResultEnum theMatchResult, MdmLinkSourceEnum theLinkSource) {
        Optional<? extends IMdmLink> oExistingLink = this.getMdmLinkForGoldenResourceSourceResourcePair(theGoldenResource, theResource);
        if (oExistingLink.isPresent() && this.systemIsAttemptingToModifyManualLink(theLinkSource, oExistingLink.get())) {
            throw new InternalErrorException(Msg.code((int)760) + "MDM system is not allowed to modify links on manually created links");
        }
        if (this.systemIsAttemptingToAddNoMatch(theLinkSource, theMatchResult)) {
            throw new InternalErrorException(Msg.code((int)761) + "MDM system is not allowed to automatically NO_MATCH a resource");
        }
    }

    private boolean systemIsAttemptingToAddNoMatch(MdmLinkSourceEnum theLinkSource, MdmMatchResultEnum theMatchResult) {
        return theLinkSource == MdmLinkSourceEnum.AUTO && theMatchResult == MdmMatchResultEnum.NO_MATCH;
    }

    private boolean systemIsAttemptingToModifyManualLink(MdmLinkSourceEnum theIncomingSource, IMdmLink theExistingSource) {
        return theIncomingSource == MdmLinkSourceEnum.AUTO && theExistingSource.isManual();
    }

    private Optional<? extends IMdmLink> getMdmLinkForGoldenResourceSourceResourcePair(@Nonnull IAnyResource theGoldenResource, @Nonnull IAnyResource theCandidate) {
        if (theGoldenResource.getIdElement().getIdPart() == null || theCandidate.getIdElement().getIdPart() == null) {
            return Optional.empty();
        }
        return this.myMdmLinkDaoSvc.getLinkByGoldenResourcePidAndSourceResourcePid(this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), (IBaseResource)theGoldenResource), this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), (IBaseResource)theCandidate));
    }

    private IMdmLink createOrUpdateLinkEntity(IAnyResource theGoldenResource, IAnyResource theSourceResource, MdmMatchOutcome theMatchOutcome, MdmLinkSourceEnum theLinkSource, MdmTransactionContext theMdmTransactionContext) {
        return this.myMdmLinkDaoSvc.createOrUpdateLinkEntity(theGoldenResource, theSourceResource, theMatchOutcome, theLinkSource, theMdmTransactionContext);
    }

    private void log(MdmTransactionContext theMdmTransactionContext, String theMessage) {
        theMdmTransactionContext.addTransactionLogMessage(theMessage);
        ourLog.debug(theMessage);
    }
}

