/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.mdm.dao.MdmLinkDaoSvc;
import ca.uhn.fhir.jpa.mdm.svc.IMdmModelConverterSvc;
import ca.uhn.fhir.jpa.mdm.svc.MdmMatchLinkSvc;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.mdm.api.IMdmLink;
import ca.uhn.fhir.mdm.api.IMdmLinkUpdaterSvc;
import ca.uhn.fhir.mdm.api.IMdmResourceDaoSvc;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.api.IMdmSurvivorshipService;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.model.MdmCreateOrUpdateParams;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.mdm.model.MdmUnduplicateGoldenResourceParams;
import ca.uhn.fhir.mdm.model.mdmevents.MdmLinkEvent;
import ca.uhn.fhir.mdm.util.MdmPartitionHelper;
import ca.uhn.fhir.mdm.util.MdmResourceUtil;
import ca.uhn.fhir.mdm.util.MessageHelper;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class MdmLinkUpdaterSvcImpl
implements IMdmLinkUpdaterSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    FhirContext myFhirContext;
    @Autowired
    IIdHelperService myIdHelperService;
    @Autowired
    MdmLinkDaoSvc myMdmLinkDaoSvc;
    @Autowired
    IMdmResourceDaoSvc myMdmResourceDaoSvc;
    @Autowired
    MdmMatchLinkSvc myMdmMatchLinkSvc;
    @Autowired
    IMdmSettings myMdmSettings;
    @Autowired
    MessageHelper myMessageHelper;
    @Autowired
    IMdmSurvivorshipService myMdmSurvivorshipService;
    @Autowired
    MdmPartitionHelper myMdmPartitionHelper;
    @Autowired
    IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private IMdmModelConverterSvc myModelConverter;

    @Transactional
    public IAnyResource updateLink(MdmCreateOrUpdateParams theParams) {
        IAnyResource sourceResource = theParams.getSourceResource();
        IAnyResource goldenResource = theParams.getGoldenResource();
        MdmTransactionContext mdmContext = theParams.getMdmContext();
        MdmMatchResultEnum matchResult = theParams.getMatchResult();
        String sourceType = this.myFhirContext.getResourceType((IBaseResource)sourceResource);
        this.validateUpdateLinkRequest(goldenResource, sourceResource, matchResult, sourceType);
        IResourcePersistentId goldenResourceId = this.myIdHelperService.getPidOrThrowException(goldenResource);
        IResourcePersistentId sourceResourceId = this.myIdHelperService.getPidOrThrowException(sourceResource);
        this.myMdmPartitionHelper.validateMdmResourcesPartitionMatches(goldenResource, sourceResource);
        Optional optionalMdmLink = this.myMdmLinkDaoSvc.getLinkByGoldenResourcePidAndSourceResourcePid(goldenResourceId, sourceResourceId);
        if (optionalMdmLink.isEmpty()) {
            throw new InvalidRequestException(Msg.code((int)738) + this.myMessageHelper.getMessageForNoLink(goldenResource, sourceResource));
        }
        IMdmLink mdmLink = (IMdmLink)optionalMdmLink.get();
        this.validateNoMatchPresentWhenAcceptingPossibleMatch(sourceResource, goldenResourceId, matchResult);
        if (mdmLink.getMatchResult() == matchResult) {
            ourLog.warn("MDM Link for " + String.valueOf(goldenResource.getIdElement().toVersionless()) + ", " + String.valueOf(sourceResource.getIdElement().toVersionless()) + " already has value " + String.valueOf(matchResult) + ".  Nothing to do.");
            return goldenResource;
        }
        ourLog.info("Manually updating MDM Link for " + String.valueOf(goldenResource.getIdElement().toVersionless()) + ", " + String.valueOf(sourceResource.getIdElement().toVersionless()) + " from " + String.valueOf(mdmLink.getMatchResult()) + " to " + String.valueOf(matchResult) + ".");
        mdmLink.setMatchResult(matchResult);
        mdmLink.setLinkSource(MdmLinkSourceEnum.MANUAL);
        MdmLinkUpdaterSvcImpl.addPartitioninfoForLinkIfNecessary(goldenResource, mdmLink);
        this.myMdmLinkDaoSvc.save(mdmLink);
        if (matchResult == MdmMatchResultEnum.MATCH) {
            this.myMdmSurvivorshipService.applySurvivorshipRulesToGoldenResource((IBase)sourceResource, (IBase)goldenResource, mdmContext);
        }
        goldenResource.setId(goldenResource.getIdElement().toVersionless());
        this.myMdmResourceDaoSvc.upsertGoldenResource(goldenResource, mdmContext.getResourceType());
        if (matchResult == MdmMatchResultEnum.NO_MATCH) {
            List links = this.myMdmLinkDaoSvc.getMdmLinksBySourcePidAndMatchResult(sourceResourceId, MdmMatchResultEnum.MATCH);
            if (links.isEmpty()) {
                this.myMdmMatchLinkSvc.updateMdmLinksForMdmSource(sourceResource, mdmContext);
            }
            goldenResource = (IAnyResource)this.myMdmSurvivorshipService.rebuildGoldenResourceWithSurvivorshipRules(theParams.getRequestDetails(), (IBase)goldenResource, mdmContext);
        }
        if (this.myInterceptorBroadcaster.hasHooks((IPointcut)Pointcut.MDM_POST_UPDATE_LINK)) {
            MdmLinkEvent event = new MdmLinkEvent();
            event.addMdmLink(this.myModelConverter.toJson(mdmLink));
            mdmContext.getMdmLinks().stream().forEach(link -> event.addMdmLink(this.myModelConverter.toJson((IMdmLink)link)));
            HookParams hookParams = new HookParams();
            hookParams.add(RequestDetails.class, (Object)theParams.getRequestDetails()).add(MdmLinkEvent.class, (Object)event);
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.MDM_POST_UPDATE_LINK, hookParams);
        }
        return goldenResource;
    }

    private static void addPartitioninfoForLinkIfNecessary(IAnyResource goldenResource, IMdmLink mdmLink) {
        RequestPartitionId goldenResourcePartitionId = (RequestPartitionId)goldenResource.getUserData(Constants.RESOURCE_PARTITION_ID);
        if (goldenResourcePartitionId != null && goldenResourcePartitionId.hasPartitionIds() && goldenResourcePartitionId.getFirstPartitionIdOrNull() != null && (mdmLink.getPartitionId() == null || mdmLink.getPartitionId().getPartitionId() == null)) {
            mdmLink.setPartitionId(new PartitionablePartitionId(goldenResourcePartitionId.getFirstPartitionIdOrNull(), goldenResourcePartitionId.getPartitionDate()));
        }
    }

    private void validateNoMatchPresentWhenAcceptingPossibleMatch(IAnyResource theSourceResource, IResourcePersistentId theGoldenResourceId, MdmMatchResultEnum theMatchResult) {
        if (theMatchResult != MdmMatchResultEnum.MATCH) {
            return;
        }
        IResourcePersistentId sourceResourceId = this.myIdHelperService.getPidOrThrowException(theSourceResource);
        List mdmLinks = this.myMdmLinkDaoSvc.getMdmLinksBySourcePidAndMatchResult(sourceResourceId, MdmMatchResultEnum.MATCH);
        for (IMdmLink mdmLink : mdmLinks) {
            if (mdmLink.getGoldenResourcePersistenceId() == theGoldenResourceId) continue;
            IAnyResource existingGolden = this.myMdmResourceDaoSvc.readGoldenResourceByPid(mdmLink.getGoldenResourcePersistenceId(), mdmLink.getMdmSourceType());
            throw new InvalidRequestException(Msg.code((int)2218) + this.myMessageHelper.getMessageForAlreadyAcceptedLink(existingGolden, theSourceResource));
        }
    }

    private void validateUpdateLinkRequest(IAnyResource theGoldenRecord, IAnyResource theSourceResource, MdmMatchResultEnum theMatchResult, String theSourceType) {
        String goldenRecordType = this.myFhirContext.getResourceType((IBaseResource)theGoldenRecord);
        if (theMatchResult != MdmMatchResultEnum.NO_MATCH && theMatchResult != MdmMatchResultEnum.MATCH) {
            throw new InvalidRequestException(Msg.code((int)739) + this.myMessageHelper.getMessageForUnsupportedMatchResult());
        }
        if (!this.myMdmSettings.isSupportedMdmType(goldenRecordType)) {
            throw new InvalidRequestException(Msg.code((int)740) + this.myMessageHelper.getMessageForUnsupportedFirstArgumentTypeInUpdate(goldenRecordType));
        }
        if (!this.myMdmSettings.isSupportedMdmType(theSourceType)) {
            throw new InvalidRequestException(Msg.code((int)741) + this.myMessageHelper.getMessageForUnsupportedSecondArgumentTypeInUpdate(theSourceType));
        }
        if (!Objects.equals(goldenRecordType, theSourceType)) {
            throw new InvalidRequestException(Msg.code((int)742) + this.myMessageHelper.getMessageForArgumentTypeMismatchInUpdate(goldenRecordType, theSourceType));
        }
        if (!MdmResourceUtil.isMdmManaged((IBaseResource)theGoldenRecord)) {
            throw new InvalidRequestException(Msg.code((int)743) + this.myMessageHelper.getMessageForUnmanagedResource());
        }
        if (!MdmResourceUtil.isMdmAllowed((IBaseResource)theSourceResource)) {
            throw new InvalidRequestException(Msg.code((int)744) + this.myMessageHelper.getMessageForUnsupportedSourceResource());
        }
    }

    @Transactional
    public void unduplicateGoldenResource(MdmUnduplicateGoldenResourceParams theParams) {
        IAnyResource goldenResource = theParams.getGoldenResource();
        IAnyResource targetGoldenResource = theParams.getTargetGoldenResource();
        this.validateNotDuplicateGoldenResourceRequest(goldenResource, targetGoldenResource);
        IResourcePersistentId goldenResourceId = this.myIdHelperService.getPidOrThrowException(goldenResource);
        IResourcePersistentId targetId = this.myIdHelperService.getPidOrThrowException(targetGoldenResource);
        Optional oMdmLink = this.myMdmLinkDaoSvc.getLinkByGoldenResourcePidAndSourceResourcePid(goldenResourceId, targetId);
        if (oMdmLink.isEmpty()) {
            throw new InvalidRequestException(Msg.code((int)745) + "No link exists between " + String.valueOf(goldenResource.getIdElement().toVersionless()) + " and " + String.valueOf(targetGoldenResource.getIdElement().toVersionless()));
        }
        IMdmLink mdmLink = (IMdmLink)oMdmLink.get();
        if (!mdmLink.isPossibleDuplicate()) {
            throw new InvalidRequestException(Msg.code((int)746) + String.valueOf(goldenResource.getIdElement().toVersionless()) + " and " + String.valueOf(targetGoldenResource.getIdElement().toVersionless()) + " are not linked as POSSIBLE_DUPLICATE.");
        }
        mdmLink.setMatchResult(MdmMatchResultEnum.NO_MATCH);
        mdmLink.setLinkSource(MdmLinkSourceEnum.MANUAL);
        IMdmLink retval = this.myMdmLinkDaoSvc.save(mdmLink);
        if (this.myInterceptorBroadcaster.hasHooks((IPointcut)Pointcut.MDM_POST_NOT_DUPLICATE)) {
            MdmLinkEvent event = new MdmLinkEvent();
            event.addMdmLink(this.myModelConverter.toJson(retval));
            HookParams params = new HookParams();
            params.add(RequestDetails.class, (Object)theParams.getRequestDetails());
            params.add(MdmLinkEvent.class, (Object)event);
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.MDM_POST_NOT_DUPLICATE, params);
        }
    }

    private void validateNotDuplicateGoldenResourceRequest(IAnyResource theGoldenResource, IAnyResource theTarget) {
        String targetType;
        String goldenResourceType = this.myFhirContext.getResourceType((IBaseResource)theGoldenResource);
        if (!goldenResourceType.equalsIgnoreCase(targetType = this.myFhirContext.getResourceType((IBaseResource)theTarget))) {
            throw new InvalidRequestException(Msg.code((int)747) + "First argument to $mdm-update-link must be the same resource type as the second argument.  Was " + goldenResourceType + "/" + targetType);
        }
        if (!MdmResourceUtil.isMdmManaged((IBaseResource)theGoldenResource) || !MdmResourceUtil.isMdmManaged((IBaseResource)theTarget)) {
            throw new InvalidRequestException(Msg.code((int)748) + "Only MDM Managed Golden Resources may be updated via this operation.  The resource provided is not tagged as managed by HAPI-MDM");
        }
    }
}

