/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.mdm.svc.candidate.CandidateSearcher;
import ca.uhn.fhir.jpa.mdm.svc.candidate.MdmCandidateSearchSvc;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.mdm.api.IMdmMatchFinderSvc;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.api.MatchedTarget;
import ca.uhn.fhir.mdm.api.MdmMatchOutcome;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.model.CanonicalEID;
import ca.uhn.fhir.mdm.rules.svc.MdmResourceMatcherSvc;
import ca.uhn.fhir.mdm.util.EIDHelper;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MdmMatchFinderSvcImpl
implements IMdmMatchFinderSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private MdmCandidateSearchSvc myMdmCandidateSearchSvc;
    @Autowired
    private MdmResourceMatcherSvc myMdmResourceMatcherSvc;
    @Autowired
    private EIDHelper myEIDHelper;
    @Autowired
    IMdmSettings myMdmSettings;

    @Nonnull
    @Transactional
    public List<MatchedTarget> getMatchedTargets(String theResourceType, IAnyResource theResource, RequestPartitionId theRequestPartitionId) {
        List<MatchedTarget> retval = this.matchBasedOnEid(theResourceType, theResource, theRequestPartitionId);
        if (!retval.isEmpty()) {
            return retval;
        }
        Collection<IAnyResource> targetCandidates = this.myMdmCandidateSearchSvc.findCandidates(theResourceType, theResource, theRequestPartitionId);
        List<MatchedTarget> matches = targetCandidates.stream().map(candidate -> new MatchedTarget(candidate, this.myMdmResourceMatcherSvc.getMatchResult((IBaseResource)theResource, (IBaseResource)candidate))).collect(Collectors.toList());
        ourLog.trace("Found {} matched targets for {}.", (Object)matches.size(), (Object)CandidateSearcher.idOrType(theResource, theResourceType));
        return matches;
    }

    private List<MatchedTarget> matchBasedOnEid(String theResourceType, IAnyResource theResource, RequestPartitionId theRequestPartitionId) {
        List eidsFromResource = this.myEIDHelper.getExternalEid((IBaseResource)theResource);
        if (eidsFromResource.isEmpty()) {
            return Collections.emptyList();
        }
        return this.searchForResourceByEIDs(theResource.getIdElement().toUnqualifiedVersionless(), eidsFromResource, theResourceType, theRequestPartitionId);
    }

    private List<MatchedTarget> searchForResourceByEIDs(IIdType theResourceIdToExclude, List<CanonicalEID> theEids, String theResourceType, RequestPartitionId theRequestPartitionId) {
        SearchParameterMap map = SearchParameterMap.newSynchronous();
        TokenOrListParam tokenOrListParam = new TokenOrListParam();
        String eidSystemForResourceType = this.myMdmSettings.getMdmRules().getEnterpriseEIDSystemForResourceType(theResourceType);
        theEids.stream().map(CanonicalEID::getValue).forEach(eid -> tokenOrListParam.addOr(new TokenParam(eidSystemForResourceType, eid)));
        map.add("identifier", (IQueryParameterOr)tokenOrListParam);
        IFhirResourceDao resourceDao = this.myDaoRegistry.getResourceDao(theResourceType);
        SystemRequestDetails systemRequestDetails = new SystemRequestDetails();
        systemRequestDetails.setRequestPartitionId(theRequestPartitionId);
        IBundleProvider search = resourceDao.search(map, (RequestDetails)systemRequestDetails);
        ArrayList<MatchedTarget> retval = new ArrayList<MatchedTarget>();
        search.getAllResources().stream().map(IAnyResource.class::cast).filter(resource -> !theResourceIdToExclude.equals(resource.getIdElement().toUnqualifiedVersionless())).map(resource -> new MatchedTarget(resource, MdmMatchOutcome.EID_MATCH)).forEach(retval::add);
        return retval;
    }
}

