/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.mdm.models.FindGoldenResourceCandidatesParams;
import ca.uhn.fhir.jpa.mdm.svc.MdmEidUpdateService;
import ca.uhn.fhir.jpa.mdm.svc.candidate.CandidateList;
import ca.uhn.fhir.jpa.mdm.svc.candidate.CandidateStrategyEnum;
import ca.uhn.fhir.jpa.mdm.svc.candidate.MatchedGoldenResourceCandidate;
import ca.uhn.fhir.jpa.mdm.svc.candidate.MdmGoldenResourceFindingSvc;
import ca.uhn.fhir.mdm.api.IMdmLinkSvc;
import ca.uhn.fhir.mdm.api.IMdmSurvivorshipService;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmMatchOutcome;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.blocklist.svc.IBlockRuleEvaluationSvc;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.mdm.util.GoldenResourceHelper;
import ca.uhn.fhir.mdm.util.MdmResourceUtil;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MdmMatchLinkSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private IMdmLinkSvc myMdmLinkSvc;
    @Autowired
    private MdmGoldenResourceFindingSvc myMdmGoldenResourceFindingSvc;
    @Autowired
    private GoldenResourceHelper myGoldenResourceHelper;
    @Autowired
    private MdmEidUpdateService myEidUpdateService;
    @Autowired
    private IBlockRuleEvaluationSvc myBlockRuleEvaluationSvc;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private IMdmSurvivorshipService myMdmSurvivorshipService;

    @Transactional
    public MdmTransactionContext updateMdmLinksForMdmSource(IAnyResource theResource, MdmTransactionContext theMdmTransactionContext) {
        if (MdmResourceUtil.isMdmAllowed((IBaseResource)theResource)) {
            return this.doMdmUpdate(theResource, theMdmTransactionContext);
        }
        return null;
    }

    private MdmTransactionContext doMdmUpdate(IAnyResource theResource, MdmTransactionContext theMdmTransactionContext) {
        CandidateList candidateList = new CandidateList(CandidateStrategyEnum.ANY);
        boolean isResourceBlocked = this.myBlockRuleEvaluationSvc.isMdmMatchingBlocked(theResource);
        theMdmTransactionContext.setIsBlocked(isResourceBlocked);
        if (!isResourceBlocked) {
            FindGoldenResourceCandidatesParams params = new FindGoldenResourceCandidatesParams(theResource, theMdmTransactionContext);
            candidateList = this.myMdmGoldenResourceFindingSvc.findGoldenResourceCandidates(params);
        }
        if (isResourceBlocked || candidateList.isEmpty()) {
            this.handleMdmWithNoCandidates(theResource, theMdmTransactionContext);
        } else if (candidateList.exactlyOneMatch()) {
            this.handleMdmWithSingleCandidate(theResource, candidateList.getOnlyMatch(), theMdmTransactionContext);
        } else {
            this.handleMdmWithMultipleCandidates(theResource, candidateList, theMdmTransactionContext);
        }
        return theMdmTransactionContext;
    }

    private void handleMdmWithMultipleCandidates(IAnyResource theResource, CandidateList theCandidateList, MdmTransactionContext theMdmTransactionContext) {
        MatchedGoldenResourceCandidate firstMatch = theCandidateList.getFirstMatch();
        IResourcePersistentId sampleGoldenResourcePid = firstMatch.getCandidateGoldenResourcePid();
        boolean allSameGoldenResource = theCandidateList.stream().allMatch(candidate -> candidate.getCandidateGoldenResourcePid().equals(sampleGoldenResourcePid));
        if (allSameGoldenResource) {
            this.log(theMdmTransactionContext, "MDM received multiple match candidates, but they are all linked to the same Golden Resource.");
            this.handleMdmWithSingleCandidate(theResource, firstMatch, theMdmTransactionContext);
        } else {
            this.log(theMdmTransactionContext, "MDM received multiple match candidates, that were linked to different Golden Resources. Setting POSSIBLE_DUPLICATES and POSSIBLE_MATCHES.");
            List<IAnyResource> goldenResources = this.createPossibleMatches(theResource, theCandidateList, theMdmTransactionContext);
            IAnyResource firstGoldenResource = goldenResources.get(0);
            goldenResources.subList(1, goldenResources.size()).forEach(possibleDuplicateGoldenResource -> {
                MdmMatchOutcome outcome = MdmMatchOutcome.POSSIBLE_DUPLICATE;
                outcome.setEidMatch(theCandidateList.isEidMatch());
                this.myMdmLinkSvc.updateLink(firstGoldenResource, possibleDuplicateGoldenResource, outcome, MdmLinkSourceEnum.AUTO, theMdmTransactionContext);
            });
        }
    }

    private List<IAnyResource> createPossibleMatches(IAnyResource theResource, CandidateList theCandidateList, MdmTransactionContext theMdmTransactionContext) {
        ArrayList<IAnyResource> goldenResources = new ArrayList<IAnyResource>();
        for (MatchedGoldenResourceCandidate matchedGoldenResourceCandidate : theCandidateList.getCandidates()) {
            IAnyResource goldenResource = this.myMdmGoldenResourceFindingSvc.getGoldenResourceFromMatchedGoldenResourceCandidate(matchedGoldenResourceCandidate, theMdmTransactionContext.getResourceType());
            MdmMatchOutcome outcome = new MdmMatchOutcome(matchedGoldenResourceCandidate.getMatchResult().getVector(), matchedGoldenResourceCandidate.getMatchResult().getScore()).setMdmRuleCount(matchedGoldenResourceCandidate.getMatchResult().getMdmRuleCount());
            outcome.setMatchResultEnum(MdmMatchResultEnum.POSSIBLE_MATCH);
            outcome.setEidMatch(theCandidateList.isEidMatch());
            this.myMdmLinkSvc.updateLink(goldenResource, theResource, outcome, MdmLinkSourceEnum.AUTO, theMdmTransactionContext);
            goldenResources.add(goldenResource);
        }
        return goldenResources;
    }

    private void handleMdmWithNoCandidates(IAnyResource theResource, MdmTransactionContext theMdmTransactionContext) {
        this.log(theMdmTransactionContext, String.format("There were no matched candidates for MDM, creating a new %s Golden Resource.", theResource.getIdElement().getResourceType()));
        IAnyResource newGoldenResource = this.myGoldenResourceHelper.createGoldenResourceFromMdmSourceResource(theResource, theMdmTransactionContext, this.myMdmSurvivorshipService);
        this.myMdmLinkSvc.updateLink(newGoldenResource, theResource, MdmMatchOutcome.NEW_GOLDEN_RESOURCE_MATCH, MdmLinkSourceEnum.AUTO, theMdmTransactionContext);
    }

    private void handleMdmCreate(IAnyResource theTargetResource, MatchedGoldenResourceCandidate theGoldenResourceCandidate, MdmTransactionContext theMdmTransactionContext) {
        IAnyResource goldenResource = this.myMdmGoldenResourceFindingSvc.getGoldenResourceFromMatchedGoldenResourceCandidate(theGoldenResourceCandidate, theMdmTransactionContext.getResourceType());
        if (this.myGoldenResourceHelper.isPotentialDuplicate(goldenResource, theTargetResource)) {
            this.log(theMdmTransactionContext, "Duplicate detected based on the fact that both resources have different external EIDs.");
            IAnyResource newGoldenResource = this.myGoldenResourceHelper.createGoldenResourceFromMdmSourceResource(theTargetResource, theMdmTransactionContext, this.myMdmSurvivorshipService);
            this.myMdmLinkSvc.updateLink(newGoldenResource, theTargetResource, MdmMatchOutcome.NEW_GOLDEN_RESOURCE_MATCH, MdmLinkSourceEnum.AUTO, theMdmTransactionContext);
            this.myMdmLinkSvc.updateLink(newGoldenResource, goldenResource, MdmMatchOutcome.POSSIBLE_DUPLICATE, MdmLinkSourceEnum.AUTO, theMdmTransactionContext);
        } else {
            this.log(theMdmTransactionContext, "MDM has narrowed down to one candidate for matching.");
            if (theGoldenResourceCandidate.isMatch()) {
                this.myGoldenResourceHelper.handleExternalEidAddition(goldenResource, theTargetResource, theMdmTransactionContext);
                this.myEidUpdateService.applySurvivorshipRulesAndSaveGoldenResource(theTargetResource, goldenResource, theMdmTransactionContext);
            }
            this.myMdmLinkSvc.updateLink(goldenResource, theTargetResource, theGoldenResourceCandidate.getMatchResult(), MdmLinkSourceEnum.AUTO, theMdmTransactionContext);
        }
    }

    private void handleMdmWithSingleCandidate(IAnyResource theResource, MatchedGoldenResourceCandidate theGoldenResourceCandidate, MdmTransactionContext theMdmTransactionContext) {
        if (theMdmTransactionContext.getRestOperation().equals((Object)MdmTransactionContext.OperationType.UPDATE_RESOURCE)) {
            this.log(theMdmTransactionContext, "MDM has narrowed down to one candidate for matching.");
            this.myEidUpdateService.handleMdmUpdate(theResource, theGoldenResourceCandidate, theMdmTransactionContext);
        } else {
            this.handleMdmCreate(theResource, theGoldenResourceCandidate, theMdmTransactionContext);
        }
    }

    private void log(MdmTransactionContext theMdmTransactionContext, String theMessage) {
        theMdmTransactionContext.addTransactionLogMessage(theMessage);
        ourLog.debug(theMessage);
    }
}

