/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.mdm.svc.IMdmModelConverterSvc;
import ca.uhn.fhir.mdm.api.IMdmLink;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.api.MdmLinkWithRevision;
import ca.uhn.fhir.mdm.model.mdmevents.MdmLinkJson;
import ca.uhn.fhir.mdm.model.mdmevents.MdmLinkWithRevisionJson;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.springframework.beans.factory.annotation.Autowired;

public class MdmModelConverterSvcImpl
implements IMdmModelConverterSvc {
    @Autowired
    IIdHelperService myIdHelperService;
    @Autowired
    private IMdmSettings myMdmSettings;

    @Override
    public MdmLinkJson toJson(IMdmLink theLink) {
        MdmLinkJson retVal = new MdmLinkJson();
        String sourceId = this.myIdHelperService.resourceIdFromPidOrThrowException(theLink.getSourcePersistenceId(), theLink.getMdmSourceType()).toVersionless().getValue();
        retVal.setSourceId(sourceId);
        if (theLink.getSourcePersistenceId() != null) {
            retVal.setSourcePid(theLink.getSourcePersistenceId());
        }
        String goldenResourceId = this.myIdHelperService.resourceIdFromPidOrThrowException(theLink.getGoldenResourcePersistenceId(), theLink.getMdmSourceType()).toVersionless().getValue();
        retVal.setGoldenResourceId(goldenResourceId);
        if (theLink.getGoldenResourcePersistenceId() != null) {
            retVal.setGoldenPid(theLink.getGoldenResourcePersistenceId());
        }
        retVal.setCreated(theLink.getCreated());
        retVal.setEidMatch(theLink.getEidMatch());
        retVal.setLinkSource(theLink.getLinkSource());
        retVal.setMatchResult(theLink.getMatchResult());
        retVal.setLinkCreatedNewResource(theLink.getHadToCreateNewGoldenResource());
        Double score = theLink.getScore() == null ? null : Double.valueOf(BigDecimal.valueOf(theLink.getScore()).setScale(4, RoundingMode.HALF_UP).doubleValue());
        retVal.setScore(score);
        retVal.setUpdated(theLink.getUpdated());
        retVal.setVersion(theLink.getVersion());
        retVal.setRuleCount(theLink.getRuleCount());
        retVal.translateAndSetRule(this.myMdmSettings.getMdmRules(), theLink.getVector());
        return retVal;
    }

    @Override
    public MdmLinkWithRevisionJson toJson(MdmLinkWithRevision<? extends IMdmLink<?>> theMdmLinkRevision) {
        MdmLinkJson mdmLinkJson = this.toJson(theMdmLinkRevision.getMdmLink());
        return new MdmLinkWithRevisionJson(mdmLinkJson, Long.valueOf(theMdmLinkRevision.getEnversRevision().getRevisionNumber()), theMdmLinkRevision.getEnversRevision().getRevisionTimestamp());
    }
}

