/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.model.entity.TagTypeEnum;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.mdm.api.IMdmResourceDaoSvc;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.rules.json.MdmRulesJson;
import ca.uhn.fhir.mdm.util.MdmSearchParamBuildingUtils;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdmResourceDaoSvcImpl
implements IMdmResourceDaoSvc {
    private static final int MAX_MATCHING_GOLDEN_RESOURCES = 1000;
    @Autowired
    DaoRegistry myDaoRegistry;
    @Autowired
    IMdmSettings myMdmSettings;

    public DaoMethodOutcome upsertGoldenResource(IAnyResource theGoldenResource, String theResourceType) {
        IFhirResourceDao resourceDao = this.myDaoRegistry.getResourceDao(theResourceType);
        SystemRequestDetails requestDetails = new SystemRequestDetails().setRequestPartitionId((RequestPartitionId)theGoldenResource.getUserData(Constants.RESOURCE_PARTITION_ID));
        if (theGoldenResource.getIdElement().hasIdPart()) {
            return resourceDao.update((IBaseResource)theGoldenResource, (RequestDetails)requestDetails);
        }
        return resourceDao.create((IBaseResource)theGoldenResource, (RequestDetails)requestDetails);
    }

    public void removeGoldenResourceTag(IAnyResource theGoldenResource, String theResourcetype) {
        IFhirResourceDao resourceDao = this.myDaoRegistry.getResourceDao(theResourcetype);
        SystemRequestDetails requestDetails = new SystemRequestDetails().setRequestPartitionId((RequestPartitionId)theGoldenResource.getUserData(Constants.RESOURCE_PARTITION_ID));
        resourceDao.removeTag(theGoldenResource.getIdElement(), TagTypeEnum.TAG, "http://hapifhir.io/fhir/NamingSystem/mdm-record-status", "GOLDEN_RECORD", (RequestDetails)requestDetails);
    }

    public IAnyResource readGoldenResourceByPid(IResourcePersistentId theGoldenResourcePid, String theResourceType) {
        IFhirResourceDao resourceDao = this.myDaoRegistry.getResourceDao(theResourceType);
        return (IAnyResource)resourceDao.readByPid(theGoldenResourcePid);
    }

    public Optional<IAnyResource> searchGoldenResourceByEID(String theEid, String theResourceType) {
        return this.searchGoldenResourceByEID(theEid, theResourceType, null);
    }

    public Optional<IAnyResource> searchGoldenResourceByEID(String theEid, String theResourceType, RequestPartitionId thePartitionId) {
        SearchParameterMap map = MdmSearchParamBuildingUtils.buildEidSearchParameterMap((String)theEid, (String)theResourceType, (MdmRulesJson)this.myMdmSettings.getMdmRules());
        IFhirResourceDao resourceDao = this.myDaoRegistry.getResourceDao(theResourceType);
        SystemRequestDetails systemRequestDetails = new SystemRequestDetails();
        systemRequestDetails.setRequestPartitionId(thePartitionId);
        IBundleProvider search = resourceDao.search(map, (RequestDetails)systemRequestDetails);
        List resources = search.getResources(0, 1000);
        if (resources.isEmpty()) {
            return Optional.empty();
        }
        if (resources.size() > 1) {
            throw new InternalErrorException(Msg.code((int)737) + "Found more than one active HAPI-MDM Golden Resource with EID " + theEid + ": " + ((IBaseResource)resources.get(0)).getIdElement().getValue() + ", " + ((IBaseResource)resources.get(1)).getIdElement().getValue());
        }
        return Optional.of((IAnyResource)resources.get(0));
    }
}

