/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc.candidate;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.mdm.svc.candidate.CandidateStrategyEnum;
import ca.uhn.fhir.jpa.mdm.svc.candidate.MatchedGoldenResourceCandidate;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CandidateList {
    private final CandidateStrategyEnum myStrategy;
    private final Map<CandidateStrategyEnum, List<MatchedGoldenResourceCandidate>> myStrategyToCandidateList = new HashMap<CandidateStrategyEnum, List<MatchedGoldenResourceCandidate>>();

    public CandidateList(CandidateStrategyEnum theStrategy) {
        this.myStrategy = theStrategy;
        this.myStrategyToCandidateList.put(CandidateStrategyEnum.EID, new ArrayList());
        this.myStrategyToCandidateList.put(CandidateStrategyEnum.LINK, new ArrayList());
        this.myStrategyToCandidateList.put(CandidateStrategyEnum.SCORE, new ArrayList());
    }

    public CandidateStrategyEnum getStrategy() {
        return this.myStrategy;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void addAll(CandidateStrategyEnum theStrategy, List<MatchedGoldenResourceCandidate> theList) {
        switch (theStrategy) {
            case EID: 
            case LINK: 
            case SCORE: {
                this.myStrategyToCandidateList.get((Object)theStrategy).addAll(theList);
                break;
            }
            default: {
                throw new InternalErrorException(Msg.code((int)2424) + " Existing resources cannot be added for strategy " + theStrategy.name());
            }
        }
    }

    public MatchedGoldenResourceCandidate getOnlyMatch() {
        assert (this.size() == 1);
        return this.getCandidates().get(0);
    }

    public boolean exactlyOneMatch() {
        return this.size() == 1;
    }

    public Stream<MatchedGoldenResourceCandidate> stream() {
        return Stream.concat(this.myStrategyToCandidateList.get((Object)CandidateStrategyEnum.EID).stream(), Stream.concat(this.myStrategyToCandidateList.get((Object)CandidateStrategyEnum.LINK).stream(), this.myStrategyToCandidateList.get((Object)CandidateStrategyEnum.SCORE).stream()));
    }

    public Stream<MatchedGoldenResourceCandidate> stream(CandidateStrategyEnum theStrategy) {
        return this.myStrategyToCandidateList.get((Object)theStrategy).stream();
    }

    public List<MatchedGoldenResourceCandidate> getCandidates() {
        switch (this.myStrategy) {
            case EID: 
            case LINK: 
            case SCORE: {
                return new ArrayList<MatchedGoldenResourceCandidate>((Collection)this.myStrategyToCandidateList.get((Object)this.myStrategy));
            }
        }
        return Stream.of(this.myStrategyToCandidateList.get((Object)CandidateStrategyEnum.EID), this.myStrategyToCandidateList.get((Object)CandidateStrategyEnum.LINK), this.myStrategyToCandidateList.get((Object)CandidateStrategyEnum.SCORE)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public MatchedGoldenResourceCandidate getFirstMatch() {
        assert (this.size() > 0);
        switch (this.myStrategy) {
            case EID: 
            case LINK: 
            case SCORE: {
                return this.myStrategyToCandidateList.get((Object)this.myStrategy).get(0);
            }
        }
        return this.getCandidates().get(0);
    }

    public boolean isEidMatch() {
        return this.myStrategy.isEidMatch();
    }

    public int size() {
        switch (this.myStrategy) {
            case EID: 
            case LINK: 
            case SCORE: {
                return this.myStrategyToCandidateList.get((Object)this.myStrategy).size();
            }
        }
        return this.myStrategyToCandidateList.get((Object)CandidateStrategyEnum.EID).size() + this.myStrategyToCandidateList.get((Object)CandidateStrategyEnum.LINK).size() + this.myStrategyToCandidateList.get((Object)CandidateStrategyEnum.SCORE).size();
    }
}

