/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc.candidate;

import ca.uhn.fhir.mdm.rules.json.MdmResourceSearchParamJson;
import ca.uhn.fhir.mdm.svc.MdmSearchParamSvc;
import ca.uhn.fhir.util.UrlUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdmCandidateSearchCriteriaBuilderSvc {
    @Autowired
    private MdmSearchParamSvc myMdmSearchParamSvc;

    @Nonnull
    public Optional<String> buildResourceQueryString(String theResourceType, IAnyResource theResource, List<String> theFilterCriteria, @Nullable MdmResourceSearchParamJson resourceSearchParam) {
        ArrayList<String> criteria = new ArrayList<String>();
        if (resourceSearchParam != null) {
            for (String searchParam : resourceSearchParam) {
                List valuesFromResourceForSearchParam = this.myMdmSearchParamSvc.getValueFromResourceForSearchParam((IBaseResource)theResource, searchParam);
                if (valuesFromResourceForSearchParam.isEmpty()) {
                    return Optional.empty();
                }
                criteria.add(this.buildResourceMatchQuery(searchParam, valuesFromResourceForSearchParam));
            }
        }
        criteria.addAll(theFilterCriteria);
        return Optional.of(theResourceType + "?" + String.join((CharSequence)"&", criteria));
    }

    private String buildResourceMatchQuery(String theSearchParamName, List<String> theResourceValues) {
        String nameValueOrList = theResourceValues.stream().map(UrlUtil::escapeUrlParam).collect(Collectors.joining(","));
        return theSearchParamName + "=" + nameValueOrList;
    }
}

