/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc.candidate;

import ca.uhn.fhir.jpa.mdm.models.FindGoldenResourceCandidatesParams;
import ca.uhn.fhir.jpa.mdm.svc.candidate.CandidateList;
import ca.uhn.fhir.jpa.mdm.svc.candidate.CandidateStrategyEnum;
import ca.uhn.fhir.jpa.mdm.svc.candidate.FindCandidateByEidSvc;
import ca.uhn.fhir.jpa.mdm.svc.candidate.FindCandidateByExampleSvc;
import ca.uhn.fhir.jpa.mdm.svc.candidate.FindCandidateByLinkSvc;
import ca.uhn.fhir.jpa.mdm.svc.candidate.MatchedGoldenResourceCandidate;
import ca.uhn.fhir.mdm.api.IMdmResourceDaoSvc;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdmGoldenResourceFindingSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private IMdmResourceDaoSvc myMdmResourceDaoSvc;
    @Autowired
    private FindCandidateByEidSvc myFindCandidateByEidSvc;
    @Autowired
    private FindCandidateByLinkSvc myFindCandidateByLinkSvc;
    @Autowired
    private FindCandidateByExampleSvc myFindCandidateByExampleSvc;

    public CandidateList findGoldenResourceCandidates(FindGoldenResourceCandidatesParams theParams) {
        IAnyResource resource = theParams.getResource();
        CandidateList eidGoldenResources = this.myFindCandidateByEidSvc.findCandidates(resource);
        if (!eidGoldenResources.isEmpty()) {
            return eidGoldenResources;
        }
        boolean isUpdate = theParams.getContext().getRestOperation() == MdmTransactionContext.OperationType.UPDATE_RESOURCE;
        CandidateList linkGoldenResources = this.myFindCandidateByLinkSvc.findCandidates(resource);
        if (!linkGoldenResources.isEmpty() && !isUpdate) {
            return linkGoldenResources;
        }
        CandidateList anyGoldenResources = this.myFindCandidateByExampleSvc.findCandidates(resource);
        if (linkGoldenResources.isEmpty()) {
            return anyGoldenResources;
        }
        CandidateList matches = new CandidateList(CandidateStrategyEnum.ANY);
        matches.addAll(CandidateStrategyEnum.LINK, linkGoldenResources.getCandidates());
        matches.addAll(CandidateStrategyEnum.SCORE, anyGoldenResources.getCandidates());
        return matches;
    }

    public IAnyResource getGoldenResourceFromMatchedGoldenResourceCandidate(MatchedGoldenResourceCandidate theMatchedGoldenResourceCandidate, String theResourceType) {
        IResourcePersistentId goldenResourcePid = theMatchedGoldenResourceCandidate.getCandidateGoldenResourcePid();
        return this.myMdmResourceDaoSvc.readGoldenResourceByPid(goldenResourcePid, theResourceType);
    }
}

