/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.interceptor.model;

import ca.uhn.fhir.interceptor.model.PartitionIdRequestDetails;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class ReadPartitionIdRequestDetails
extends PartitionIdRequestDetails {
    private final String myResourceType;
    private final RestOperationTypeEnum myRestOperationType;
    private final IIdType myReadResourceId;
    @Nullable
    private final SearchParameterMap mySearchParams;
    @Nullable
    private final IBaseResource myConditionalTargetOrNull;
    @Nullable
    private final String mySearchUuid;
    @Nullable
    private final String myExtendedOperationName;

    private ReadPartitionIdRequestDetails(String theResourceType, RestOperationTypeEnum theRestOperationType, IIdType theReadResourceId, @Nullable SearchParameterMap theSearchParams, @Nullable IBaseResource theConditionalTargetOrNull, @Nullable String theSearchUuid, String theExtendedOperationName) {
        this.myResourceType = theResourceType;
        this.myRestOperationType = theRestOperationType;
        this.myReadResourceId = theReadResourceId;
        this.mySearchParams = theSearchParams;
        this.myConditionalTargetOrNull = theConditionalTargetOrNull;
        this.mySearchUuid = theSearchUuid;
        this.myExtendedOperationName = theExtendedOperationName;
    }

    @Nullable
    public String getExtendedOperationName() {
        return this.myExtendedOperationName;
    }

    @Nullable
    public String getSearchUuid() {
        return this.mySearchUuid;
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public RestOperationTypeEnum getRestOperationType() {
        return this.myRestOperationType;
    }

    public IIdType getReadResourceId() {
        return this.myReadResourceId;
    }

    @Nullable
    public SearchParameterMap getSearchParams() {
        return this.mySearchParams;
    }

    @Nullable
    public IBaseResource getConditionalTargetOrNull() {
        return this.myConditionalTargetOrNull;
    }

    public static ReadPartitionIdRequestDetails forRead(IIdType theId) {
        assert (StringUtils.isNotBlank((CharSequence)theId.getResourceType()));
        assert (StringUtils.isNotBlank((CharSequence)theId.getIdPart()));
        return ReadPartitionIdRequestDetails.forRead(theId.getResourceType(), theId, false);
    }

    public static ReadPartitionIdRequestDetails forOperation(@Nullable String theResourceType, @Nullable IIdType theId, @Nonnull String theExtendedOperationName) {
        RestOperationTypeEnum op = theId != null ? RestOperationTypeEnum.EXTENDED_OPERATION_INSTANCE : (theResourceType != null ? RestOperationTypeEnum.EXTENDED_OPERATION_TYPE : RestOperationTypeEnum.EXTENDED_OPERATION_SERVER);
        return new ReadPartitionIdRequestDetails(theResourceType, op, null, null, null, null, theExtendedOperationName);
    }

    public static ReadPartitionIdRequestDetails forRead(String theResourceType, @Nonnull IIdType theId, boolean theIsVread) {
        RestOperationTypeEnum op = theIsVread ? RestOperationTypeEnum.VREAD : RestOperationTypeEnum.READ;
        return new ReadPartitionIdRequestDetails(theResourceType, op, theId.withResourceType(theResourceType), null, null, null, null);
    }

    public static ReadPartitionIdRequestDetails forSearchType(String theResourceType, SearchParameterMap theParams, IBaseResource theConditionalOperationTargetOrNull) {
        return new ReadPartitionIdRequestDetails(theResourceType, RestOperationTypeEnum.SEARCH_TYPE, null, theParams, theConditionalOperationTargetOrNull, null, null);
    }

    public static ReadPartitionIdRequestDetails forHistory(String theResourceType, IIdType theIdType) {
        RestOperationTypeEnum restOperationTypeEnum = theIdType != null ? RestOperationTypeEnum.HISTORY_INSTANCE : (theResourceType != null ? RestOperationTypeEnum.HISTORY_TYPE : RestOperationTypeEnum.HISTORY_SYSTEM);
        return new ReadPartitionIdRequestDetails(theResourceType, restOperationTypeEnum, theIdType, null, null, null, null);
    }

    public static ReadPartitionIdRequestDetails forSearchUuid(String theUuid) {
        return new ReadPartitionIdRequestDetails(null, RestOperationTypeEnum.GET_PAGE, null, null, null, theUuid, null);
    }
}

