/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.cache;

import ca.uhn.fhir.jpa.cache.IResourceChangeListener;
import ca.uhn.fhir.jpa.cache.IResourceChangeListenerCache;
import ca.uhn.fhir.jpa.cache.IResourceChangeListenerCacheRefresher;
import ca.uhn.fhir.jpa.cache.IResourceVersionSvc;
import ca.uhn.fhir.jpa.cache.ResourceChangeEvent;
import ca.uhn.fhir.jpa.cache.ResourceChangeListenerCache;
import ca.uhn.fhir.jpa.cache.ResourceChangeListenerRegistryImpl;
import ca.uhn.fhir.jpa.cache.ResourceChangeResult;
import ca.uhn.fhir.jpa.cache.ResourceVersionCache;
import ca.uhn.fhir.jpa.cache.ResourceVersionMap;
import ca.uhn.fhir.jpa.model.sched.HapiJob;
import ca.uhn.fhir.jpa.model.sched.IHasScheduledJobs;
import ca.uhn.fhir.jpa.model.sched.ISchedulerService;
import ca.uhn.fhir.jpa.model.sched.ScheduledJobDefinition;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import com.google.common.annotations.VisibleForTesting;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.Iterator;
import org.hl7.fhir.instance.model.api.IIdType;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class ResourceChangeListenerCacheRefresherImpl
implements IResourceChangeListenerCacheRefresher,
IHasScheduledJobs {
    private static final Logger ourLog = LoggerFactory.getLogger(ResourceChangeListenerCacheRefresherImpl.class);
    static final long LOCAL_REFRESH_INTERVAL_MS = 10000L;
    @Autowired
    private IResourceVersionSvc myResourceVersionSvc;
    @Autowired
    private ResourceChangeListenerRegistryImpl myResourceChangeListenerRegistry;
    private boolean myStopping = false;

    public void scheduleJobs(ISchedulerService theSchedulerService) {
        ScheduledJobDefinition jobDetail = new ScheduledJobDefinition();
        jobDetail.setId(this.getClass().getName());
        jobDetail.setJobClass(Job.class);
        theSchedulerService.scheduleLocalJob(10000L, jobDetail);
    }

    @Override
    public ResourceChangeResult refreshExpiredCachesAndNotifyListeners() {
        ResourceChangeResult retval = new ResourceChangeResult();
        Iterator<ResourceChangeListenerCache> iterator = this.myResourceChangeListenerRegistry.iterator();
        while (iterator.hasNext()) {
            ResourceChangeListenerCache entry = iterator.next();
            retval = retval.plus(entry.refreshCacheIfNecessary());
        }
        return retval;
    }

    @VisibleForTesting
    public ResourceChangeResult forceRefreshAllCachesForUnitTest() {
        ResourceChangeResult retval = new ResourceChangeResult();
        Iterator<ResourceChangeListenerCache> iterator = this.myResourceChangeListenerRegistry.iterator();
        while (iterator.hasNext()) {
            IResourceChangeListenerCache entry = iterator.next();
            retval = retval.plus(entry.forceRefresh());
        }
        return retval;
    }

    @VisibleForTesting
    public void setResourceChangeListenerRegistry(ResourceChangeListenerRegistryImpl theResourceChangeListenerRegistry) {
        this.myResourceChangeListenerRegistry = theResourceChangeListenerRegistry;
    }

    @VisibleForTesting
    public void setResourceVersionSvc(IResourceVersionSvc theResourceVersionSvc) {
        this.myResourceVersionSvc = theResourceVersionSvc;
    }

    @Override
    @EventListener(value={ContextRefreshedEvent.class})
    public void start() {
        this.myStopping = false;
    }

    @Override
    @EventListener(value={ContextClosedEvent.class})
    public void shutdown() {
        this.myStopping = true;
    }

    public boolean isStopping() {
        return this.myStopping;
    }

    @Override
    @Transactional(value=Transactional.TxType.NOT_SUPPORTED)
    public ResourceChangeResult refreshCacheAndNotifyListener(IResourceChangeListenerCache theCache) {
        ResourceChangeResult retVal = new ResourceChangeResult();
        if (this.isStopping()) {
            ourLog.info("Context is stopping, aborting cache refresh");
            return retVal;
        }
        if (!this.myResourceChangeListenerRegistry.contains(theCache)) {
            ourLog.warn("Requesting cache refresh for unregistered listener {}.  Aborting.", (Object)theCache);
            return retVal;
        }
        SearchParameterMap searchParamMap = theCache.getSearchParameterMap();
        ResourceVersionMap newResourceVersionMap = this.myResourceVersionSvc.getVersionMap(theCache.getResourceName(), searchParamMap);
        retVal = retVal.plus(this.notifyListener(theCache, newResourceVersionMap));
        return retVal;
    }

    ResourceChangeResult notifyListener(IResourceChangeListenerCache theCache, ResourceVersionMap theNewResourceVersionMap) {
        ResourceChangeResult retval;
        ResourceChangeListenerCache cache = (ResourceChangeListenerCache)theCache;
        IResourceChangeListener resourceChangeListener = cache.getResourceChangeListener();
        if (theCache.isInitialized()) {
            retval = this.compareLastVersionMapToNewVersionMapAndNotifyListenerOfChanges(resourceChangeListener, cache.getResourceVersionCache(), theNewResourceVersionMap);
        } else {
            cache.getResourceVersionCache().initialize(theNewResourceVersionMap);
            resourceChangeListener.handleInit(theNewResourceVersionMap.getSourceIds());
            retval = ResourceChangeResult.fromCreated(theNewResourceVersionMap.size());
            cache.setInitialized(true);
        }
        return retval;
    }

    private ResourceChangeResult compareLastVersionMapToNewVersionMapAndNotifyListenerOfChanges(IResourceChangeListener theListener, ResourceVersionCache theOldResourceVersionCache, ResourceVersionMap theNewResourceVersionMap) {
        ArrayList<IIdType> deletedIds = new ArrayList<IIdType>();
        theOldResourceVersionCache.keySet().forEach(id -> {
            if (!theNewResourceVersionMap.containsKey((IIdType)id)) {
                deletedIds.add((IIdType)id);
            }
        });
        deletedIds.forEach(theOldResourceVersionCache::removeResourceId);
        ArrayList<IIdType> createdIds = new ArrayList<IIdType>();
        ArrayList<IIdType> updatedIds = new ArrayList<IIdType>();
        for (IIdType id2 : theNewResourceVersionMap.keySet()) {
            Long previousValue = theOldResourceVersionCache.put(id2, theNewResourceVersionMap.get(id2));
            IIdType newId = id2.withVersion(theNewResourceVersionMap.get(id2).toString());
            if (previousValue == null) {
                createdIds.add(newId);
                continue;
            }
            if (theNewResourceVersionMap.get(id2).equals(previousValue)) continue;
            updatedIds.add(newId);
        }
        ResourceChangeEvent resourceChangeEvent = ResourceChangeEvent.fromCreatedUpdatedDeletedResourceIds(createdIds, updatedIds, deletedIds);
        if (!resourceChangeEvent.isEmpty()) {
            theListener.handleChange(resourceChangeEvent);
        }
        return ResourceChangeResult.fromResourceChangeEvent(resourceChangeEvent);
    }

    public static class Job
    implements HapiJob {
        @Autowired
        private IResourceChangeListenerCacheRefresher myTarget;

        public void execute(JobExecutionContext theContext) {
            this.myTarget.refreshExpiredCachesAndNotifyListeners();
        }
    }
}

