/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.partition;

import ca.uhn.fhir.interceptor.model.ReadPartitionIdRequestDetails;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public interface IRequestPartitionHelperSvc {
    @Nonnull
    public RequestPartitionId determineReadPartitionForRequest(@Nullable RequestDetails var1, ReadPartitionIdRequestDetails var2);

    @Nonnull
    default public RequestPartitionId determineReadPartitionForRequestForRead(RequestDetails theRequest, String theResourceType, @Nonnull IIdType theId) {
        ReadPartitionIdRequestDetails details = ReadPartitionIdRequestDetails.forRead(theResourceType, theId, theId.hasVersionIdPart());
        return this.determineReadPartitionForRequest(theRequest, details);
    }

    @Nonnull
    default public RequestPartitionId determineReadPartitionForRequestForSearchType(RequestDetails theRequest, String theResourceType, SearchParameterMap theParams, IBaseResource theConditionalOperationTargetOrNull) {
        ReadPartitionIdRequestDetails details = ReadPartitionIdRequestDetails.forSearchType(theResourceType, theParams, theConditionalOperationTargetOrNull);
        return this.determineReadPartitionForRequest(theRequest, details);
    }

    public RequestPartitionId determineGenericPartitionForRequest(RequestDetails var1);

    @Nonnull
    default public RequestPartitionId determineReadPartitionForRequestForHistory(RequestDetails theRequest, String theResourceType, IIdType theIdType) {
        ReadPartitionIdRequestDetails details = ReadPartitionIdRequestDetails.forHistory(theResourceType, theIdType);
        return this.determineReadPartitionForRequest(theRequest, details);
    }

    @Nonnull
    default public void validateHasPartitionPermissions(RequestDetails theRequest, String theResourceType, RequestPartitionId theRequestPartitionId) {
    }

    @Nonnull
    public RequestPartitionId determineCreatePartitionForRequest(@Nullable RequestDetails var1, @Nonnull IBaseResource var2, @Nonnull String var3);

    @Nonnull
    public Set<Integer> toReadPartitions(@Nonnull RequestPartitionId var1);

    public boolean isResourcePartitionable(String var1);
}

