/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam;

import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ResourceSearch {
    private final RuntimeResourceDefinition myRuntimeResourceDefinition;
    private final SearchParameterMap mySearchParameterMap;
    private final RequestPartitionId myRequestPartitionId;

    public ResourceSearch(RuntimeResourceDefinition theRuntimeResourceDefinition, SearchParameterMap theSearchParameterMap, RequestPartitionId theRequestPartitionId) {
        this.myRuntimeResourceDefinition = theRuntimeResourceDefinition;
        this.mySearchParameterMap = theSearchParameterMap;
        this.myRequestPartitionId = theRequestPartitionId;
    }

    public RuntimeResourceDefinition getRuntimeResourceDefinition() {
        return this.myRuntimeResourceDefinition;
    }

    public SearchParameterMap getSearchParameterMap() {
        return this.mySearchParameterMap;
    }

    public String getResourceName() {
        return this.myRuntimeResourceDefinition.getName();
    }

    public boolean isDeleteExpunge() {
        return this.mySearchParameterMap.isDeleteExpunge();
    }

    public Class<? extends IBaseResource> getResourceType() {
        return this.myRuntimeResourceDefinition.getImplementingClass();
    }

    public RequestPartitionId getRequestPartitionId() {
        return this.myRequestPartitionId;
    }
}

