/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.extractor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.searchparam.extractor.BaseSearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.sl.cache.Cache;
import ca.uhn.fhir.sl.cache.CacheFactory;
import ca.uhn.fhir.util.BundleUtil;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.r4b.context.IWorkerContext;
import org.hl7.fhir.r4b.hapi.ctx.HapiWorkerContext;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.ExpressionNode;
import org.hl7.fhir.r4b.model.IdType;
import org.hl7.fhir.r4b.model.Resource;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.TypeDetails;
import org.hl7.fhir.r4b.model.ValueSet;
import org.hl7.fhir.r4b.utils.FHIRPathEngine;
import org.hl7.fhir.r4b.utils.FHIRPathUtilityClasses;

public class SearchParamExtractorR4B
extends BaseSearchParamExtractor
implements ISearchParamExtractor {
    private Cache<String, ExpressionNode> myParsedFhirPathCache;
    private FHIRPathEngine myFhirPathEngine;

    public SearchParamExtractorR4B() {
    }

    @VisibleForTesting
    public SearchParamExtractorR4B(StorageSettings theStorageSettings, PartitionSettings thePartitionSettings, FhirContext theCtx, ISearchParamRegistry theSearchParamRegistry) {
        super(theStorageSettings, thePartitionSettings, theCtx, theSearchParamRegistry);
        this.initFhirPath();
        this.start();
    }

    @Override
    public BaseSearchParamExtractor.IValueExtractor getPathValueExtractor(IBase theResource, String theSinglePath) {
        return () -> {
            ExpressionNode parsed = (ExpressionNode)this.myParsedFhirPathCache.get((Object)theSinglePath, path -> this.myFhirPathEngine.parse(path));
            return this.myFhirPathEngine.evaluate((Object)theResource, (Base)theResource, (Base)theResource, (Base)theResource, parsed);
        };
    }

    @Override
    @PostConstruct
    public void start() {
        super.start();
        if (this.myFhirPathEngine == null) {
            this.initFhirPath();
        }
    }

    public void initFhirPath() {
        HapiWorkerContext worker = new HapiWorkerContext(this.getContext(), this.getContext().getValidationSupport());
        this.myFhirPathEngine = new FHIRPathEngine((IWorkerContext)worker);
        this.myFhirPathEngine.setHostServices((FHIRPathEngine.IEvaluationContext)new SearchParamExtractorR4BHostServices());
        this.myParsedFhirPathCache = CacheFactory.build((long)TimeUnit.MINUTES.toMillis(10L));
    }

    private class SearchParamExtractorR4BHostServices
    implements FHIRPathEngine.IEvaluationContext {
        private final Map<String, Base> myResourceTypeToStub = Collections.synchronizedMap(new HashMap());

        private SearchParamExtractorR4BHostServices() {
        }

        public List<Base> resolveConstant(Object appContext, String name, boolean beforeContext) throws PathEngineException {
            return Collections.emptyList();
        }

        public TypeDetails resolveConstantType(Object appContext, String name) throws PathEngineException {
            return null;
        }

        public boolean log(String argument, List<Base> focus) {
            return false;
        }

        public FHIRPathUtilityClasses.FunctionDetails resolveFunction(String functionName) {
            return null;
        }

        public TypeDetails checkFunction(Object appContext, String functionName, List<TypeDetails> parameters) throws PathEngineException {
            return null;
        }

        public List<Base> executeFunction(Object appContext, List<Base> focus, String functionName, List<List<Base>> parameters) {
            return null;
        }

        public Base resolveReference(Object theAppContext, String theUrl, Base refContext) throws FHIRException {
            Object retVal = (Base)BundleUtil.getReferenceInBundle((FhirContext)SearchParamExtractorR4B.this.getContext(), (String)theUrl, (Object)theAppContext);
            if (retVal != null) {
                return retVal;
            }
            final IdType url = new IdType(theUrl);
            if (StringUtils.isNotBlank((CharSequence)url.getResourceType())) {
                retVal = this.myResourceTypeToStub.get(url.getResourceType());
                if (retVal != null) {
                    return retVal;
                }
                final ResourceType resourceType = ResourceType.fromCode((String)url.getResourceType());
                if (resourceType != null) {
                    retVal = new Resource(){
                        private static final long serialVersionUID = -5303169871827706447L;

                        public Resource copy() {
                            return this;
                        }

                        public ResourceType getResourceType() {
                            return resourceType;
                        }

                        public String fhirType() {
                            return url.getResourceType();
                        }
                    };
                    this.myResourceTypeToStub.put(url.getResourceType(), (Base)retVal);
                }
            }
            return retVal;
        }

        public boolean conformsToProfile(Object appContext, Base item, String url) throws FHIRException {
            return false;
        }

        public ValueSet resolveValueSet(Object appContext, String url) {
            return null;
        }
    }
}

