/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.matcher;

import java.util.List;

public class InMemoryMatchResult {
    public static final String PARSE_FAIL = "Failed to translate parse query string";
    public static final String STANDARD_PARAMETER = "Standard parameters not supported";
    public static final String CHAIN = "Chained parameters are not supported";
    public static final String PARAM = "Parameter not supported";
    public static final String QUALIFIER = "Qualified parameter not supported";
    public static final String LOCATION_NEAR = "Location.position near not supported";
    private final boolean myMatch;
    private final boolean mySupported;
    private final String myUnsupportedParameter;
    private final String myUnsupportedReason;
    private boolean myInMemory = false;

    private InMemoryMatchResult(boolean theMatch) {
        this.myMatch = theMatch;
        this.mySupported = true;
        this.myUnsupportedParameter = null;
        this.myUnsupportedReason = null;
    }

    private InMemoryMatchResult(String theUnsupportedParameter, String theUnsupportedReason) {
        this.myMatch = false;
        this.mySupported = false;
        this.myUnsupportedParameter = theUnsupportedParameter;
        this.myUnsupportedReason = theUnsupportedReason;
    }

    public static InMemoryMatchResult successfulMatch() {
        return new InMemoryMatchResult(true);
    }

    public static InMemoryMatchResult fromBoolean(boolean theMatched) {
        return new InMemoryMatchResult(theMatched);
    }

    public static InMemoryMatchResult unsupportedFromReason(String theUnsupportedReason) {
        return new InMemoryMatchResult(null, theUnsupportedReason);
    }

    public static InMemoryMatchResult unsupportedFromParameterAndReason(String theUnsupportedParameter, String theUnsupportedReason) {
        return new InMemoryMatchResult(theUnsupportedParameter, theUnsupportedReason);
    }

    public static InMemoryMatchResult noMatch() {
        return new InMemoryMatchResult(false);
    }

    public boolean supported() {
        return this.mySupported;
    }

    public boolean matched() {
        return this.myMatch;
    }

    public String getUnsupportedReason() {
        if (this.myUnsupportedParameter != null) {
            return "Parameter: <" + this.myUnsupportedParameter + "> Reason: " + this.myUnsupportedReason;
        }
        return this.myUnsupportedReason;
    }

    public boolean isInMemory() {
        return this.myInMemory;
    }

    public void setInMemory(boolean theInMemory) {
        this.myInMemory = theInMemory;
    }

    public static InMemoryMatchResult and(InMemoryMatchResult theLeft, InMemoryMatchResult theRight) {
        if (theLeft == null) {
            return theRight;
        }
        if (theRight == null) {
            return theLeft;
        }
        if (theLeft.supported() && theRight.supported()) {
            return InMemoryMatchResult.fromBoolean(theLeft.matched() && theRight.matched());
        }
        if (!theLeft.supported() && !theRight.supported()) {
            return InMemoryMatchResult.unsupportedFromReason(List.of(theLeft.getUnsupportedReason(), theRight.getUnsupportedReason()).toString());
        }
        if (!theLeft.supported()) {
            return theLeft;
        }
        return theRight;
    }

    public static InMemoryMatchResult or(InMemoryMatchResult theLeft, InMemoryMatchResult theRight) {
        if (theLeft == null) {
            return theRight;
        }
        if (theRight == null) {
            return theLeft;
        }
        if (theLeft.matched() || theRight.matched()) {
            return InMemoryMatchResult.successfulMatch();
        }
        if (!theLeft.supported() && !theRight.supported()) {
            return InMemoryMatchResult.unsupportedFromReason(List.of(theLeft.getUnsupportedReason(), theRight.getUnsupportedReason()).toString());
        }
        if (!theLeft.supported()) {
            return theLeft;
        }
        return theRight;
    }
}

