/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.registry;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.jpa.searchparam.registry.ReadOnlySearchParamCache;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeSearchParamCache
extends ReadOnlySearchParamCache {
    private static final Logger ourLog = LoggerFactory.getLogger(RuntimeSearchParamCache.class);

    protected RuntimeSearchParamCache() {
    }

    public void add(String theResourceName, String theName, RuntimeSearchParam theSearchParam) {
        ResourceSearchParams resourceSearchParams = this.getSearchParamMap(theResourceName);
        resourceSearchParams.put(theName, theSearchParam);
        String uri = theSearchParam.getUri();
        if (StringUtils.isNotBlank((CharSequence)uri)) {
            RuntimeSearchParam existingForUrl = (RuntimeSearchParam)this.myUrlToParam.get(uri);
            if (existingForUrl == theSearchParam) {
                ourLog.trace("Search param was previously registered for url: {}", (Object)uri);
            } else if (existingForUrl != null) {
                ourLog.debug("Multiple search parameters have URL: {}", (Object)uri);
            } else {
                this.myUrlToParam.put(uri, theSearchParam);
            }
        }
        if (theSearchParam.getId() != null && theSearchParam.getId().hasIdPart()) {
            String value = theSearchParam.getId().toUnqualifiedVersionless().getValue();
            this.myUrlToParam.put(value, theSearchParam);
        }
    }

    public void remove(String theResourceName, String theName) {
        if (!this.myResourceNameToSpNameToSp.containsKey(theResourceName)) {
            return;
        }
        ((ResourceSearchParams)this.myResourceNameToSpNameToSp.get(theResourceName)).remove(theName);
    }

    private void putAll(ReadOnlySearchParamCache theReadOnlySearchParamCache) {
        Set<Map.Entry<String, ResourceSearchParams>> builtInSps = theReadOnlySearchParamCache.myResourceNameToSpNameToSp.entrySet();
        for (Map.Entry<String, ResourceSearchParams> nextBuiltInEntry : builtInSps) {
            for (RuntimeSearchParam nextParam : nextBuiltInEntry.getValue().values()) {
                String nextResourceName = nextBuiltInEntry.getKey();
                String nextParamName = nextParam.getName();
                this.add(nextResourceName, nextParamName, nextParam);
            }
            ourLog.trace("Have {} built-in SPs for: {}", (Object)nextBuiltInEntry.getValue().size(), (Object)nextBuiltInEntry.getKey());
        }
    }

    public RuntimeSearchParam get(String theResourceName, String theParamName) {
        RuntimeSearchParam retVal = null;
        ResourceSearchParams params = (ResourceSearchParams)this.myResourceNameToSpNameToSp.get(theResourceName);
        if (params != null) {
            retVal = params.get(theParamName);
        }
        return retVal;
    }

    public Set<String> getResourceNameKeys() {
        return this.myResourceNameToSpNameToSp.keySet();
    }

    @Override
    protected ResourceSearchParams getSearchParamMap(String theResourceName) {
        return this.myResourceNameToSpNameToSp.computeIfAbsent(theResourceName, k -> new ResourceSearchParams(theResourceName));
    }

    public static RuntimeSearchParamCache fromReadOnlySearchParamCache(ReadOnlySearchParamCache theBuiltInSearchParams) {
        RuntimeSearchParamCache retVal = new RuntimeSearchParamCache();
        retVal.putAll(theBuiltInSearchParams);
        return retVal;
    }
}

