/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.registry;

import ca.uhn.fhir.context.ComboSearchParamType;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.context.phonetic.IPhoneticEncoder;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.IPrimitiveDatatype;
import ca.uhn.fhir.model.dstu2.resource.SearchParameter;
import ca.uhn.fhir.model.dstu2.valueset.ConformanceResourceStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.SearchParamTypeEnum;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.DatatypeUtil;
import ca.uhn.fhir.util.ExtensionUtil;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.PhoneticEncoderUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.SearchParameter;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchParameterCanonicalizer {
    private static final Logger ourLog = LoggerFactory.getLogger(SearchParameterCanonicalizer.class);
    private final FhirContext myFhirContext;
    private final FhirTerser myTerser;

    @Autowired
    public SearchParameterCanonicalizer(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
        this.myTerser = this.myFhirContext.newTerser();
    }

    private static Collection<String> toStrings(Collection<? extends IPrimitiveType<String>> theBase) {
        HashSet<String> retVal = new HashSet<String>();
        for (IPrimitiveType<String> iPrimitiveType : theBase) {
            if (!StringUtils.isNotBlank((CharSequence)iPrimitiveType.getValueAsString())) continue;
            retVal.add(iPrimitiveType.getValueAsString());
        }
        return retVal;
    }

    public RuntimeSearchParam canonicalizeSearchParameter(IBaseResource theSearchParameter) {
        RuntimeSearchParam retVal;
        switch (this.myFhirContext.getVersion().getVersion()) {
            case DSTU2: {
                retVal = this.canonicalizeSearchParameterDstu2((SearchParameter)theSearchParameter);
                break;
            }
            case DSTU3: {
                retVal = this.canonicalizeSearchParameterDstu3((org.hl7.fhir.dstu3.model.SearchParameter)theSearchParameter);
                break;
            }
            case R4: 
            case R4B: 
            case R5: {
                retVal = this.canonicalizeSearchParameterR4Plus(theSearchParameter);
                break;
            }
            default: {
                throw new InternalErrorException(Msg.code((int)510) + "SearchParameter canonicalization not supported for FHIR version" + this.myFhirContext.getVersion().getVersion());
            }
        }
        if (retVal != null) {
            this.extractExtensions(theSearchParameter, retVal);
        }
        return retVal;
    }

    private RuntimeSearchParam canonicalizeSearchParameterDstu2(SearchParameter theNextSp) {
        IPrimitiveDatatype uniqueExtsValuePrimitive;
        String name = theNextSp.getCode();
        String description = theNextSp.getDescription();
        String path = theNextSp.getXpath();
        Collection<String> baseResource = SearchParameterCanonicalizer.toStrings(Collections.singletonList(theNextSp.getBaseElement()));
        List<String> baseCustomResources = this.extractDstu2CustomResourcesFromExtensions(theNextSp, "http://hl7.org/fhir/tools/CustomBaseResource");
        if (!baseCustomResources.isEmpty()) {
            baseResource = Collections.singleton(baseCustomResources.get(0));
        }
        RestSearchParameterTypeEnum paramType = null;
        RuntimeSearchParam.RuntimeSearchParamStatusEnum status = null;
        if (theNextSp.getTypeElement().getValueAsEnum() != null) {
            switch ((SearchParamTypeEnum)theNextSp.getTypeElement().getValueAsEnum()) {
                case COMPOSITE: {
                    paramType = RestSearchParameterTypeEnum.COMPOSITE;
                    break;
                }
                case DATE_DATETIME: {
                    paramType = RestSearchParameterTypeEnum.DATE;
                    break;
                }
                case NUMBER: {
                    paramType = RestSearchParameterTypeEnum.NUMBER;
                    break;
                }
                case QUANTITY: {
                    paramType = RestSearchParameterTypeEnum.QUANTITY;
                    break;
                }
                case REFERENCE: {
                    paramType = RestSearchParameterTypeEnum.REFERENCE;
                    break;
                }
                case STRING: {
                    paramType = RestSearchParameterTypeEnum.STRING;
                    break;
                }
                case TOKEN: {
                    paramType = RestSearchParameterTypeEnum.TOKEN;
                    break;
                }
                case URI: {
                    paramType = RestSearchParameterTypeEnum.URI;
                }
            }
        }
        if (theNextSp.getStatus() != null) {
            switch ((ConformanceResourceStatusEnum)theNextSp.getStatusElement().getValueAsEnum()) {
                case ACTIVE: {
                    status = RuntimeSearchParam.RuntimeSearchParamStatusEnum.ACTIVE;
                    break;
                }
                case DRAFT: {
                    status = RuntimeSearchParam.RuntimeSearchParamStatusEnum.DRAFT;
                    break;
                }
                case RETIRED: {
                    status = RuntimeSearchParam.RuntimeSearchParamStatusEnum.RETIRED;
                }
            }
        }
        Set targetResources = DatatypeUtil.toStringSet((List)theNextSp.getTarget());
        List<String> targetCustomResources = this.extractDstu2CustomResourcesFromExtensions(theNextSp, "http://hl7.org/fhir/tools/CustomTargetResource");
        this.maybeAddCustomResourcesToResources(targetResources, targetCustomResources);
        if ((StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)path)) && paramType != RestSearchParameterTypeEnum.COMPOSITE) {
            return null;
        }
        IIdType id = theNextSp.getIdElement();
        String uri = "";
        ComboSearchParamType unique = null;
        List uniqueExts = theNextSp.getUndeclaredExtensionsByUrl("http://hapifhir.io/fhir/StructureDefinition/sp-unique");
        if (uniqueExts.size() > 0 && (uniqueExtsValuePrimitive = ((ExtensionDt)uniqueExts.get(0)).getValueAsPrimitive()) != null) {
            if ("true".equalsIgnoreCase(uniqueExtsValuePrimitive.getValueAsString())) {
                unique = ComboSearchParamType.UNIQUE;
            } else if ("false".equalsIgnoreCase(uniqueExtsValuePrimitive.getValueAsString())) {
                unique = ComboSearchParamType.NON_UNIQUE;
            }
        }
        List components = Collections.emptyList();
        return new RuntimeSearchParam(id, uri, name, description, path, paramType, Collections.emptySet(), targetResources, status, unique, components, baseResource);
    }

    private RuntimeSearchParam canonicalizeSearchParameterDstu3(org.hl7.fhir.dstu3.model.SearchParameter theNextSp) {
        IPrimitiveType uniqueExtsValuePrimitive;
        String name = theNextSp.getCode();
        String description = theNextSp.getDescription();
        String path = theNextSp.getExpression();
        ArrayList<String> baseResources = new ArrayList<String>(SearchParameterCanonicalizer.toStrings(theNextSp.getBase()));
        List<String> baseCustomResources = this.extractDstu3CustomResourcesFromExtensions(theNextSp, "http://hl7.org/fhir/tools/CustomBaseResource");
        this.maybeAddCustomResourcesToResources(baseResources, baseCustomResources);
        RestSearchParameterTypeEnum paramType = null;
        RuntimeSearchParam.RuntimeSearchParamStatusEnum status = null;
        if (theNextSp.getType() != null) {
            switch (theNextSp.getType()) {
                case COMPOSITE: {
                    paramType = RestSearchParameterTypeEnum.COMPOSITE;
                    break;
                }
                case DATE: {
                    paramType = RestSearchParameterTypeEnum.DATE;
                    break;
                }
                case NUMBER: {
                    paramType = RestSearchParameterTypeEnum.NUMBER;
                    break;
                }
                case QUANTITY: {
                    paramType = RestSearchParameterTypeEnum.QUANTITY;
                    break;
                }
                case REFERENCE: {
                    paramType = RestSearchParameterTypeEnum.REFERENCE;
                    break;
                }
                case STRING: {
                    paramType = RestSearchParameterTypeEnum.STRING;
                    break;
                }
                case TOKEN: {
                    paramType = RestSearchParameterTypeEnum.TOKEN;
                    break;
                }
                case URI: {
                    paramType = RestSearchParameterTypeEnum.URI;
                    break;
                }
            }
        }
        if (theNextSp.getStatus() != null) {
            switch (theNextSp.getStatus()) {
                case ACTIVE: {
                    status = RuntimeSearchParam.RuntimeSearchParamStatusEnum.ACTIVE;
                    break;
                }
                case DRAFT: {
                    status = RuntimeSearchParam.RuntimeSearchParamStatusEnum.DRAFT;
                    break;
                }
                case RETIRED: {
                    status = RuntimeSearchParam.RuntimeSearchParamStatusEnum.RETIRED;
                    break;
                }
                case UNKNOWN: {
                    status = RuntimeSearchParam.RuntimeSearchParamStatusEnum.UNKNOWN;
                    break;
                }
            }
        }
        Set targetResources = DatatypeUtil.toStringSet((List)theNextSp.getTarget());
        List<String> targetCustomResources = this.extractDstu3CustomResourcesFromExtensions(theNextSp, "http://hl7.org/fhir/tools/CustomTargetResource");
        this.maybeAddCustomResourcesToResources(targetResources, targetCustomResources);
        if ((StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)path) || paramType == null) && paramType != RestSearchParameterTypeEnum.COMPOSITE) {
            return null;
        }
        IdType id = theNextSp.getIdElement();
        String uri = "";
        ComboSearchParamType unique = null;
        List uniqueExts = theNextSp.getExtensionsByUrl("http://hapifhir.io/fhir/StructureDefinition/sp-unique");
        if (uniqueExts.size() > 0 && (uniqueExtsValuePrimitive = ((Extension)uniqueExts.get(0)).getValueAsPrimitive()) != null) {
            if ("true".equalsIgnoreCase(uniqueExtsValuePrimitive.getValueAsString())) {
                unique = ComboSearchParamType.UNIQUE;
            } else if ("false".equalsIgnoreCase(uniqueExtsValuePrimitive.getValueAsString())) {
                unique = ComboSearchParamType.NON_UNIQUE;
            }
        }
        ArrayList<RuntimeSearchParam.Component> components = new ArrayList<RuntimeSearchParam.Component>();
        for (SearchParameter.SearchParameterComponentComponent next : theNextSp.getComponent()) {
            components.add(new RuntimeSearchParam.Component(next.getExpression(), next.getDefinition().getReferenceElement().toUnqualifiedVersionless().getValue()));
        }
        return new RuntimeSearchParam((IIdType)id, uri, name, description, path, paramType, Collections.emptySet(), targetResources, status, unique, components, baseResources);
    }

    private RuntimeSearchParam canonicalizeSearchParameterR4Plus(IBaseResource theNextSp) {
        String name = this.myTerser.getSinglePrimitiveValueOrNull((IBase)theNextSp, "code");
        String description = this.myTerser.getSinglePrimitiveValueOrNull((IBase)theNextSp, "description");
        String path = this.myTerser.getSinglePrimitiveValueOrNull((IBase)theNextSp, "expression");
        Set<String> baseResources = this.extractR4PlusResources("base", theNextSp);
        List<String> baseCustomResources = this.extractR4PlusCustomResourcesFromExtensions(theNextSp, "http://hl7.org/fhir/tools/CustomBaseResource");
        this.maybeAddCustomResourcesToResources(baseResources, baseCustomResources);
        RestSearchParameterTypeEnum paramType = null;
        RuntimeSearchParam.RuntimeSearchParamStatusEnum status = null;
        switch (this.myTerser.getSinglePrimitiveValue((IBase)theNextSp, "type").orElse("")) {
            case "composite": {
                paramType = RestSearchParameterTypeEnum.COMPOSITE;
                break;
            }
            case "date": {
                paramType = RestSearchParameterTypeEnum.DATE;
                break;
            }
            case "number": {
                paramType = RestSearchParameterTypeEnum.NUMBER;
                break;
            }
            case "quantity": {
                paramType = RestSearchParameterTypeEnum.QUANTITY;
                break;
            }
            case "reference": {
                paramType = RestSearchParameterTypeEnum.REFERENCE;
                break;
            }
            case "string": {
                paramType = RestSearchParameterTypeEnum.STRING;
                break;
            }
            case "token": {
                paramType = RestSearchParameterTypeEnum.TOKEN;
                break;
            }
            case "uri": {
                paramType = RestSearchParameterTypeEnum.URI;
                break;
            }
            case "special": {
                paramType = RestSearchParameterTypeEnum.SPECIAL;
            }
        }
        switch (this.myTerser.getSinglePrimitiveValue((IBase)theNextSp, "status").orElse("")) {
            case "active": {
                status = RuntimeSearchParam.RuntimeSearchParamStatusEnum.ACTIVE;
                break;
            }
            case "draft": {
                status = RuntimeSearchParam.RuntimeSearchParamStatusEnum.DRAFT;
                break;
            }
            case "retired": {
                status = RuntimeSearchParam.RuntimeSearchParamStatusEnum.RETIRED;
                break;
            }
            case "unknown": {
                status = RuntimeSearchParam.RuntimeSearchParamStatusEnum.UNKNOWN;
            }
        }
        Set<String> targetResources = this.extractR4PlusResources("target", theNextSp);
        List<String> targetCustomResources = this.extractR4PlusCustomResourcesFromExtensions(theNextSp, "http://hl7.org/fhir/tools/CustomTargetResource");
        this.maybeAddCustomResourcesToResources(targetResources, targetCustomResources);
        if ((StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)path) || paramType == null) && !"_text".equals(name) && !"_content".equals(name) && paramType != RestSearchParameterTypeEnum.COMPOSITE) {
            return null;
        }
        IIdType id = theNextSp.getIdElement();
        String uri = this.myTerser.getSinglePrimitiveValueOrNull((IBase)theNextSp, "url");
        ComboSearchParamType unique = null;
        String value = ((IBaseHasExtensions)theNextSp).getExtension().stream().filter(e -> "http://hapifhir.io/fhir/StructureDefinition/sp-unique".equals(e.getUrl())).filter(t -> t.getValue() instanceof IPrimitiveType).map(t -> (IPrimitiveType)t.getValue()).map(t -> t.getValueAsString()).findFirst().orElse("");
        if ("true".equalsIgnoreCase(value)) {
            unique = ComboSearchParamType.UNIQUE;
        } else if ("false".equalsIgnoreCase(value)) {
            unique = ComboSearchParamType.NON_UNIQUE;
        }
        ArrayList<RuntimeSearchParam.Component> components = new ArrayList<RuntimeSearchParam.Component>();
        for (IBase next : this.myTerser.getValues((IBase)theNextSp, "component")) {
            String expression = this.myTerser.getSinglePrimitiveValueOrNull(next, "expression");
            String definition = this.myTerser.getSinglePrimitiveValueOrNull(next, "definition");
            if (StringUtils.startsWith((CharSequence)definition, (CharSequence)"/SearchParameter/")) {
                definition = definition.substring(1);
            }
            components.add(new RuntimeSearchParam.Component(expression, definition));
        }
        return new RuntimeSearchParam(id, uri, name, description, path, paramType, Collections.emptySet(), targetResources, status, unique, components, baseResources);
    }

    private Set<String> extractR4PlusResources(String thePath, IBaseResource theNextSp) {
        return this.myTerser.getValues((IBase)theNextSp, thePath, IPrimitiveType.class).stream().map(IPrimitiveType::getValueAsString).collect(Collectors.toSet());
    }

    protected void extractExtensions(IBaseResource theSearchParamResource, RuntimeSearchParam theRuntimeSearchParam) {
        if (theSearchParamResource instanceof IBaseHasExtensions) {
            List extensions = ((IBaseHasExtensions)theSearchParamResource).getExtension();
            for (IBaseExtension next : extensions) {
                String nextUrl = next.getUrl();
                if (!StringUtils.isNotBlank((CharSequence)nextUrl)) continue;
                theRuntimeSearchParam.addExtension(nextUrl, next);
                if ("http://hapifhir.io/fhir/StructureDefinition/searchparameter-phonetic-encoder".equals(nextUrl)) {
                    this.setEncoder(theRuntimeSearchParam, next.getValue());
                    continue;
                }
                if (!"https://smilecdr.com/fhir/ns/StructureDefinition/searchparameter-uplift-refchain".equals(nextUrl)) continue;
                this.addUpliftRefchain(theRuntimeSearchParam, next);
            }
        }
    }

    private void addUpliftRefchain(RuntimeSearchParam theRuntimeSearchParam, IBaseExtension<? extends IBaseExtension, ?> theExtension) {
        String code = ExtensionUtil.extractChildPrimitiveExtensionValue(theExtension, (String)"code");
        String elementName = ExtensionUtil.extractChildPrimitiveExtensionValue(theExtension, (String)"element-name");
        if (StringUtils.isNotBlank((CharSequence)code)) {
            theRuntimeSearchParam.addUpliftRefchain(code, elementName);
        }
    }

    private void setEncoder(RuntimeSearchParam theRuntimeSearchParam, IBaseDatatype theValue) {
        if (theValue instanceof IPrimitiveType) {
            String stringValue = ((IPrimitiveType)theValue).getValueAsString();
            IPhoneticEncoder encoder = PhoneticEncoderUtil.getEncoder((String)stringValue);
            if (encoder != null) {
                theRuntimeSearchParam.setPhoneticEncoder(encoder);
            } else {
                ourLog.error("Invalid PhoneticEncoderEnum value '" + stringValue + "'");
            }
        }
    }

    private List<String> extractDstu2CustomResourcesFromExtensions(SearchParameter theSearchParameter, String theExtensionUrl) {
        List customSpExtensionDt = theSearchParameter.getUndeclaredExtensionsByUrl(theExtensionUrl);
        return customSpExtensionDt.stream().map(theExtensionDt -> theExtensionDt.getValueAsPrimitive().getValueAsString()).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    private List<String> extractDstu3CustomResourcesFromExtensions(org.hl7.fhir.dstu3.model.SearchParameter theSearchParameter, String theExtensionUrl) {
        List customSpExtensions = theSearchParameter.getExtensionsByUrl(theExtensionUrl);
        return customSpExtensions.stream().map(theExtension -> theExtension.getValueAsPrimitive().getValueAsString()).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    private List<String> extractR4PlusCustomResourcesFromExtensions(IBaseResource theSearchParameter, String theExtensionUrl) {
        ArrayList<String> retVal = new ArrayList<String>();
        if (theSearchParameter instanceof IBaseHasExtensions) {
            ((IBaseHasExtensions)theSearchParameter).getExtension().stream().filter(t -> theExtensionUrl.equals(t.getUrl())).filter(t -> t.getValue() instanceof IPrimitiveType).map(t -> (IPrimitiveType)t.getValue()).map(IPrimitiveType::getValueAsString).filter(StringUtils::isNotBlank).forEach(retVal::add);
        }
        return retVal;
    }

    private <T extends Collection<String>> void maybeAddCustomResourcesToResources(T theResources, List<String> theCustomResources) {
        if (!theCustomResources.isEmpty()) {
            theResources.removeAll(Collections.singleton("Resource"));
            theResources.addAll(theCustomResources);
        }
    }
}

