/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.cache;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.cache.IResourceChangeListener;
import ca.uhn.fhir.jpa.cache.IResourceChangeListenerCache;
import ca.uhn.fhir.jpa.cache.IResourceChangeListenerRegistry;
import ca.uhn.fhir.jpa.cache.ResourceChangeListenerCache;
import ca.uhn.fhir.jpa.cache.ResourceChangeListenerCacheFactory;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryResourceMatcher;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ResourceChangeListenerRegistryImpl
implements IResourceChangeListenerRegistry {
    private static final Logger ourLog = LoggerFactory.getLogger(ResourceChangeListenerRegistryImpl.class);
    private final Queue<ResourceChangeListenerCache> myListenerEntries = new ConcurrentLinkedQueue<ResourceChangeListenerCache>();
    private final FhirContext myFhirContext;
    private final ResourceChangeListenerCacheFactory myResourceChangeListenerCacheFactory;
    private InMemoryResourceMatcher myInMemoryResourceMatcher;

    public ResourceChangeListenerRegistryImpl(FhirContext theFhirContext, ResourceChangeListenerCacheFactory theResourceChangeListenerCacheFactory, InMemoryResourceMatcher theInMemoryResourceMatcher) {
        this.myFhirContext = theFhirContext;
        this.myResourceChangeListenerCacheFactory = theResourceChangeListenerCacheFactory;
        this.myInMemoryResourceMatcher = theInMemoryResourceMatcher;
    }

    @Override
    public IResourceChangeListenerCache registerResourceResourceChangeListener(String theResourceName, SearchParameterMap theSearchParameterMap, IResourceChangeListener theResourceChangeListener, long theRemoteRefreshIntervalMs) {
        RuntimeResourceDefinition resourceDef = this.myFhirContext.getResourceDefinition(theResourceName);
        InMemoryMatchResult inMemoryMatchResult = this.myInMemoryResourceMatcher.canBeEvaluatedInMemory(theSearchParameterMap, resourceDef);
        if (!inMemoryMatchResult.supported()) {
            throw new IllegalArgumentException(Msg.code((int)482) + "SearchParameterMap " + theSearchParameterMap + " cannot be evaluated in-memory: " + inMemoryMatchResult.getUnsupportedReason() + ".  Only search parameter maps that can be evaluated in-memory may be registered.");
        }
        return this.add(theResourceName, theResourceChangeListener, theSearchParameterMap, theRemoteRefreshIntervalMs);
    }

    @Override
    public void unregisterResourceResourceChangeListener(IResourceChangeListener theResourceChangeListener) {
        this.myListenerEntries.removeIf(l -> l.getResourceChangeListener().equals(theResourceChangeListener));
    }

    @Override
    public void unregisterResourceResourceChangeListener(IResourceChangeListenerCache theResourceChangeListenerCache) {
        this.myListenerEntries.remove(theResourceChangeListenerCache);
    }

    private IResourceChangeListenerCache add(String theResourceName, IResourceChangeListener theResourceChangeListener, SearchParameterMap theMap, long theRemoteRefreshIntervalMs) {
        ResourceChangeListenerCache retval = this.myResourceChangeListenerCacheFactory.newResourceChangeListenerCache(theResourceName, theMap, theResourceChangeListener, theRemoteRefreshIntervalMs);
        this.myListenerEntries.add(retval);
        return retval;
    }

    @Nonnull
    public Iterator<ResourceChangeListenerCache> iterator() {
        return this.myListenerEntries.iterator();
    }

    public int size() {
        return this.myListenerEntries.size();
    }

    @VisibleForTesting
    public void clearCachesForUnitTest() {
        this.myListenerEntries.forEach(ResourceChangeListenerCache::clearForUnitTest);
    }

    @Override
    public boolean contains(IResourceChangeListenerCache theCache) {
        return this.myListenerEntries.contains(theCache);
    }

    @VisibleForTesting
    public int getResourceVersionCacheSizeForUnitTest() {
        int retval = 0;
        for (ResourceChangeListenerCache entry : this.myListenerEntries) {
            retval += entry.getResourceVersionCache().size();
        }
        return retval;
    }

    @Override
    public void requestRefreshIfWatching(IBaseResource theResource) {
        String resourceName = this.myFhirContext.getResourceType(theResource);
        for (ResourceChangeListenerCache entry : this.myListenerEntries) {
            if (!resourceName.equals(entry.getResourceName())) continue;
            entry.requestRefreshIfWatching(theResource);
        }
    }

    @Override
    public Set<String> getWatchedResourceNames() {
        return this.myListenerEntries.stream().map(ResourceChangeListenerCache::getResourceName).collect(Collectors.toSet());
    }

    @Override
    @VisibleForTesting
    public void clearListenersForUnitTest() {
        this.myListenerEntries.clear();
    }
}

