/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.partition;

import ca.uhn.fhir.interceptor.model.ReadPartitionIdRequestDetails;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public interface IRequestPartitionHelperSvc {
    @Nonnull
    public RequestPartitionId determineReadPartitionForRequest(@Nullable RequestDetails var1, @Nonnull ReadPartitionIdRequestDetails var2);

    @Nonnull
    default public RequestPartitionId determineReadPartitionForRequestForServerOperation(@Nullable RequestDetails theRequest, @Nonnull String theOperationName) {
        ReadPartitionIdRequestDetails details = ReadPartitionIdRequestDetails.forServerOperation(theOperationName);
        return this.determineReadPartitionForRequest(theRequest, details);
    }

    @Nonnull
    default public RequestPartitionId determineReadPartitionForRequestForRead(@Nullable RequestDetails theRequest, @Nonnull IIdType theId) {
        ReadPartitionIdRequestDetails details = ReadPartitionIdRequestDetails.forRead(theId.getResourceType(), theId, theId.hasVersionIdPart());
        return this.determineReadPartitionForRequest(theRequest, details);
    }

    @Nonnull
    default public RequestPartitionId determineReadPartitionForRequestForRead(@Nullable RequestDetails theRequest, @Nonnull String theResourceType, @Nonnull IIdType theId) {
        ReadPartitionIdRequestDetails details = ReadPartitionIdRequestDetails.forRead(theResourceType, theId, theId.hasVersionIdPart());
        return this.determineReadPartitionForRequest(theRequest, details);
    }

    @Nonnull
    default public RequestPartitionId determineReadPartitionForRequestForSearchType(@Nullable RequestDetails theRequest, @Nonnull String theResourceType) {
        ReadPartitionIdRequestDetails details = ReadPartitionIdRequestDetails.forSearchType(theResourceType, SearchParameterMap.newSynchronous(), null);
        return this.determineReadPartitionForRequest(theRequest, details);
    }

    @Nonnull
    default public RequestPartitionId determineReadPartitionForRequestForSearchType(@Nullable RequestDetails theRequest, @Nonnull String theResourceType, @Nonnull SearchParameterMap theParams) {
        ReadPartitionIdRequestDetails details = ReadPartitionIdRequestDetails.forSearchType(theResourceType, theParams, null);
        return this.determineReadPartitionForRequest(theRequest, details);
    }

    @Nonnull
    default public RequestPartitionId determineReadPartitionForRequestForSearchType(RequestDetails theRequest, String theResourceType, SearchParameterMap theParams, IBaseResource theConditionalOperationTargetOrNull) {
        SearchParameterMap searchParameterMap = theParams != null ? theParams : SearchParameterMap.newSynchronous();
        ReadPartitionIdRequestDetails details = ReadPartitionIdRequestDetails.forSearchType(theResourceType, searchParameterMap, theConditionalOperationTargetOrNull);
        return this.determineReadPartitionForRequest(theRequest, details);
    }

    public RequestPartitionId determineGenericPartitionForRequest(RequestDetails var1);

    @Nonnull
    default public RequestPartitionId determineReadPartitionForRequestForHistory(@Nullable RequestDetails theRequest, String theResourceType, IIdType theIdType) {
        ReadPartitionIdRequestDetails details = ReadPartitionIdRequestDetails.forHistory(theResourceType, theIdType);
        return this.determineReadPartitionForRequest(theRequest, details);
    }

    default public void validateHasPartitionPermissions(@Nonnull RequestDetails theRequest, String theResourceType, RequestPartitionId theRequestPartitionId) {
    }

    @Nonnull
    public RequestPartitionId determineCreatePartitionForRequest(@Nullable RequestDetails var1, @Nonnull IBaseResource var2, @Nonnull String var3);

    @Nonnull
    public Set<Integer> toReadPartitions(@Nonnull RequestPartitionId var1);

    public boolean isResourcePartitionable(String var1);

    public RequestPartitionId validateAndNormalizePartitionIds(RequestPartitionId var1);

    public RequestPartitionId validateAndNormalizePartitionNames(RequestPartitionId var1);
}

