/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.TokenParamModifier;
import ca.uhn.fhir.util.UrlUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchParameterMap
implements Serializable {
    public static final Integer INTEGER_0 = 0;
    private static final Logger ourLog = LoggerFactory.getLogger(SearchParameterMap.class);
    private static final long serialVersionUID = 1L;
    private final HashMap<String, List<List<IQueryParameterType>>> mySearchParameterMap = new LinkedHashMap<String, List<List<IQueryParameterType>>>();
    private Integer myCount;
    private Integer myOffset;
    private EverythingModeEnum myEverythingMode = null;
    private Set<Include> myIncludes;
    private DateRangeParam myLastUpdated;
    private boolean myLoadSynchronous;
    private Integer myLoadSynchronousUpTo;
    private Set<Include> myRevIncludes;
    private SortSpec mySort;
    private SummaryEnum mySummaryMode;
    private SearchTotalModeEnum mySearchTotalMode;
    private QuantityParam myNearDistanceParam;
    private boolean myLastN;
    private Integer myLastNMax;
    private boolean myDeleteExpunge;
    private SearchContainedModeEnum mySearchContainedMode = SearchContainedModeEnum.FALSE;

    public SearchParameterMap() {
    }

    public SearchParameterMap(String theName, IQueryParameterType theParam) {
        this.add(theName, theParam);
    }

    @JsonIgnore
    public SearchParameterMap clone() {
        SearchParameterMap map = new SearchParameterMap();
        map.setSummaryMode(this.getSummaryMode());
        map.setSort(this.getSort());
        map.setSearchTotalMode(this.getSearchTotalMode());
        map.setRevIncludes(this.getRevIncludes());
        map.setIncludes(this.getIncludes());
        map.setEverythingMode(this.getEverythingMode());
        map.setCount(this.getCount());
        map.setDeleteExpunge(this.isDeleteExpunge());
        map.setLastN(this.isLastN());
        map.setLastNMax(this.getLastNMax());
        map.setLastUpdated(this.getLastUpdated());
        map.setLoadSynchronous(this.isLoadSynchronous());
        map.setNearDistanceParam(this.getNearDistanceParam());
        map.setLoadSynchronousUpTo(this.getLoadSynchronousUpTo());
        map.setOffset(this.getOffset());
        map.setSearchContainedMode(this.getSearchContainedMode());
        for (Map.Entry<String, List<List<IQueryParameterType>>> entry : this.mySearchParameterMap.entrySet()) {
            List<List<IQueryParameterType>> andParams = entry.getValue();
            ArrayList<List<IQueryParameterType>> newAndParams = new ArrayList<List<IQueryParameterType>>();
            for (List<IQueryParameterType> orParams : andParams) {
                ArrayList<IQueryParameterType> newOrParams = new ArrayList<IQueryParameterType>(orParams);
                newAndParams.add(newOrParams);
            }
            map.put(entry.getKey(), newAndParams);
        }
        return map;
    }

    public SummaryEnum getSummaryMode() {
        return this.mySummaryMode;
    }

    public void setSummaryMode(SummaryEnum theSummaryMode) {
        this.mySummaryMode = theSummaryMode;
    }

    public SearchTotalModeEnum getSearchTotalMode() {
        return this.mySearchTotalMode;
    }

    public void setSearchTotalMode(SearchTotalModeEnum theSearchTotalMode) {
        this.mySearchTotalMode = theSearchTotalMode;
    }

    public SearchParameterMap add(String theName, DateParam theDateParam) {
        this.add(theName, (IQueryParameterOr<?>)theDateParam);
        return this;
    }

    public SearchParameterMap add(String theName, IQueryParameterAnd<?> theAnd) {
        if (theAnd == null) {
            return this;
        }
        if (!this.containsKey(theName)) {
            this.put(theName, new ArrayList<List<IQueryParameterType>>());
        }
        for (IQueryParameterOr next : theAnd.getValuesAsQueryTokens()) {
            if (next == null) continue;
            this.get(theName).add(next.getValuesAsQueryTokens());
        }
        return this;
    }

    public SearchParameterMap add(String theName, IQueryParameterOr<?> theOr) {
        if (theOr == null) {
            return this;
        }
        if (!this.containsKey(theName)) {
            this.put(theName, new ArrayList<List<IQueryParameterType>>());
        }
        this.get(theName).add(theOr.getValuesAsQueryTokens());
        return this;
    }

    public Collection<List<List<IQueryParameterType>>> values() {
        return this.mySearchParameterMap.values();
    }

    public SearchParameterMap add(String theName, IQueryParameterType theParam) {
        assert (!"_lastUpdated".equals(theName));
        if (theParam == null) {
            return this;
        }
        if (!this.containsKey(theName)) {
            this.put(theName, new ArrayList<List<IQueryParameterType>>());
        }
        ArrayList<IQueryParameterType> list = new ArrayList<IQueryParameterType>();
        list.add(theParam);
        this.get(theName).add(list);
        return this;
    }

    public SearchParameterMap addInclude(Include theInclude) {
        this.getIncludes().add(theInclude);
        return this;
    }

    private void addLastUpdateParam(StringBuilder theBuilder, ParamPrefixEnum thePrefix, DateParam theDateParam) {
        if (theDateParam != null && StringUtils.isNotBlank((CharSequence)theDateParam.getValueAsString())) {
            this.addUrlParamSeparator(theBuilder);
            theBuilder.append("_lastUpdated");
            theBuilder.append('=');
            theBuilder.append(thePrefix.getValue());
            theBuilder.append(theDateParam.getValueAsString());
        }
    }

    public SearchParameterMap addRevInclude(Include theInclude) {
        this.getRevIncludes().add(theInclude);
        return this;
    }

    private void addUrlIncludeParams(StringBuilder b, String paramName, Set<Include> theList) {
        ArrayList<Include> list = new ArrayList<Include>(theList);
        list.sort(new IncludeComparator());
        for (Include nextInclude : list) {
            this.addUrlParamSeparator(b);
            b.append(paramName);
            if (nextInclude.isRecurse()) {
                b.append(":recurse");
            }
            b.append('=');
            if ("*".equals(nextInclude.getValue())) {
                b.append("*");
                continue;
            }
            b.append(UrlUtil.escapeUrlParam((String)nextInclude.getParamType()));
            b.append(':');
            b.append(UrlUtil.escapeUrlParam((String)nextInclude.getParamName()));
            if (!StringUtils.isNotBlank((CharSequence)nextInclude.getParamTargetType())) continue;
            b.append(':');
            b.append(nextInclude.getParamTargetType());
        }
    }

    private void addUrlParamSeparator(StringBuilder theB) {
        if (theB.length() == 0) {
            theB.append('?');
        } else {
            theB.append('&');
        }
    }

    public Integer getCount() {
        return this.myCount;
    }

    public SearchParameterMap setCount(Integer theCount) {
        this.myCount = theCount;
        return this;
    }

    public Integer getOffset() {
        return this.myOffset;
    }

    public void setOffset(Integer theOffset) {
        this.myOffset = theOffset;
    }

    public EverythingModeEnum getEverythingMode() {
        return this.myEverythingMode;
    }

    public void setEverythingMode(EverythingModeEnum theConsolidateMatches) {
        this.myEverythingMode = theConsolidateMatches;
    }

    public Set<Include> getIncludes() {
        if (this.myIncludes == null) {
            this.myIncludes = new HashSet<Include>();
        }
        return this.myIncludes;
    }

    public void setIncludes(Set<Include> theIncludes) {
        this.myIncludes = theIncludes;
    }

    public DateRangeParam getLastUpdated() {
        if (this.myLastUpdated != null && this.myLastUpdated.isEmpty()) {
            this.myLastUpdated = null;
        }
        return this.myLastUpdated;
    }

    public void setLastUpdated(DateRangeParam theLastUpdated) {
        this.myLastUpdated = theLastUpdated;
    }

    public Integer getLoadSynchronousUpTo() {
        return this.myLoadSynchronousUpTo;
    }

    public SearchParameterMap setLoadSynchronousUpTo(Integer theLoadSynchronousUpTo) {
        this.myLoadSynchronousUpTo = theLoadSynchronousUpTo;
        if (this.myLoadSynchronousUpTo != null) {
            this.setLoadSynchronous(true);
        }
        return this;
    }

    public Set<Include> getRevIncludes() {
        if (this.myRevIncludes == null) {
            this.myRevIncludes = new HashSet<Include>();
        }
        return this.myRevIncludes;
    }

    public void setRevIncludes(Set<Include> theRevIncludes) {
        this.myRevIncludes = theRevIncludes;
    }

    public SortSpec getSort() {
        return this.mySort;
    }

    public SearchParameterMap setSort(SortSpec theSort) {
        this.mySort = theSort;
        return this;
    }

    public boolean isLoadSynchronous() {
        return this.myLoadSynchronous;
    }

    public SearchParameterMap setLoadSynchronous(boolean theLoadSynchronous) {
        this.myLoadSynchronous = theLoadSynchronous;
        return this;
    }

    public boolean isLastN() {
        return this.myLastN;
    }

    public SearchParameterMap setLastN(boolean theLastN) {
        this.myLastN = theLastN;
        return this;
    }

    public Integer getLastNMax() {
        return this.myLastNMax;
    }

    public SearchParameterMap setLastNMax(Integer theLastNMax) {
        this.myLastNMax = theLastNMax;
        return this;
    }

    public String toNormalizedQueryString(FhirContext theCtx) {
        StringBuilder b = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(this.keySet());
        Collections.sort(keys);
        for (String nextKey : keys) {
            List<List<IQueryParameterType>> nextValuesAndsIn = this.get(nextKey);
            ArrayList<List<Object>> nextValuesAndsOut = new ArrayList<List<Object>>();
            for (List<IQueryParameterType> nextValuesAndIn : nextValuesAndsIn) {
                ArrayList<IQueryParameterType> nextValuesOrsOut = new ArrayList<IQueryParameterType>();
                nextValuesOrsOut.addAll(nextValuesAndIn);
                nextValuesOrsOut.sort(new QueryParameterTypeComparator(theCtx));
                if (nextValuesOrsOut.size() <= 0) continue;
                nextValuesAndsOut.add(nextValuesOrsOut);
            }
            nextValuesAndsOut.sort(new QueryParameterOrComparator(theCtx));
            for (List<Object> nextValuesAnd : nextValuesAndsOut) {
                this.addUrlParamSeparator(b);
                IQueryParameterType firstValue = (IQueryParameterType)nextValuesAnd.get(0);
                b.append(UrlUtil.escapeUrlParam((String)nextKey));
                if (firstValue.getMissing() != null) {
                    b.append(":missing");
                    b.append('=');
                    if (firstValue.getMissing().booleanValue()) {
                        b.append("true");
                        continue;
                    }
                    b.append("false");
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)firstValue.getQueryParameterQualifier())) {
                    b.append(firstValue.getQueryParameterQualifier());
                }
                b.append('=');
                for (int i = 0; i < nextValuesAnd.size(); ++i) {
                    IQueryParameterType nextValueOr = (IQueryParameterType)nextValuesAnd.get(i);
                    if (i > 0) {
                        b.append(',');
                    }
                    String valueAsQueryToken = nextValueOr.getValueAsQueryToken(theCtx);
                    valueAsQueryToken = StringUtils.defaultString((String)valueAsQueryToken);
                    b.append(UrlUtil.escapeUrlParam((String)valueAsQueryToken));
                }
            }
        }
        boolean first = true;
        for (SortSpec sort = this.getSort(); sort != null; sort = sort.getChain()) {
            if (StringUtils.isNotBlank((CharSequence)sort.getParamName())) {
                if (first) {
                    this.addUrlParamSeparator(b);
                    b.append("_sort");
                    b.append('=');
                    first = false;
                } else {
                    b.append(',');
                }
                if (sort.getOrder() == SortOrderEnum.DESC) {
                    b.append('-');
                }
                b.append(sort.getParamName());
            }
            Validate.isTrue((sort != sort.getChain() ? 1 : 0) != 0);
        }
        if (this.hasIncludes()) {
            this.addUrlIncludeParams(b, "_include", this.getIncludes());
        }
        this.addUrlIncludeParams(b, "_revinclude", this.getRevIncludes());
        if (this.getLastUpdated() != null) {
            DateParam ub;
            DateParam lb = this.getLastUpdated().getLowerBound();
            if (this.isNotEqualsComparator(lb, ub = this.getLastUpdated().getUpperBound())) {
                this.addLastUpdateParam(b, ParamPrefixEnum.NOT_EQUAL, this.getLastUpdated().getLowerBound());
            } else {
                this.addLastUpdateParam(b, ParamPrefixEnum.GREATERTHAN_OR_EQUALS, lb);
                this.addLastUpdateParam(b, ParamPrefixEnum.LESSTHAN_OR_EQUALS, ub);
            }
        }
        if (this.getCount() != null) {
            this.addUrlParamSeparator(b);
            b.append("_count");
            b.append('=');
            b.append(this.getCount());
        }
        if (this.getOffset() != null) {
            this.addUrlParamSeparator(b);
            b.append("_offset");
            b.append('=');
            b.append(this.getOffset());
        }
        if (this.getSummaryMode() != null) {
            this.addUrlParamSeparator(b);
            b.append("_summary");
            b.append('=');
            b.append(this.getSummaryMode().getCode());
        }
        if (this.getSearchTotalMode() != null) {
            this.addUrlParamSeparator(b);
            b.append("_total");
            b.append('=');
            b.append(this.getSearchTotalMode().getCode());
        }
        if (this.getSearchContainedMode() != SearchContainedModeEnum.FALSE) {
            this.addUrlParamSeparator(b);
            b.append("_contained");
            b.append("=");
            b.append(this.getSearchContainedMode().getCode());
        }
        if (b.length() == 0) {
            b.append('?');
        }
        return b.toString();
    }

    private boolean isNotEqualsComparator(DateParam theLowerBound, DateParam theUpperBound) {
        return theLowerBound != null && theUpperBound != null && theLowerBound.getPrefix().equals((Object)ParamPrefixEnum.NOT_EQUAL) && theUpperBound.getPrefix().equals((Object)ParamPrefixEnum.NOT_EQUAL);
    }

    public boolean hasIncludes() {
        return this.myIncludes != null && !this.myIncludes.isEmpty();
    }

    public boolean hasRevIncludes() {
        return this.myRevIncludes != null && !this.myRevIncludes.isEmpty();
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        if (!this.isEmpty()) {
            b.append("params", this.mySearchParameterMap);
        }
        if (!this.getIncludes().isEmpty()) {
            b.append("includes", this.getIncludes());
        }
        return b.toString();
    }

    public void clean() {
        for (Map.Entry<String, List<List<IQueryParameterType>>> nextParamEntry : this.entrySet()) {
            String nextParamName = nextParamEntry.getKey();
            List<List<IQueryParameterType>> andOrParams = nextParamEntry.getValue();
            this.cleanParameter(nextParamName, andOrParams);
        }
    }

    private void cleanParameter(String theParamName, List<List<IQueryParameterType>> theAndOrParams) {
        theAndOrParams.forEach(orList -> {
            List emptyParameters = orList.stream().filter(nextOr -> nextOr.getMissing() == null).filter(nextOr -> nextOr instanceof QuantityParam).filter(nextOr -> StringUtils.isBlank((CharSequence)((QuantityParam)nextOr).getValueAsString())).collect(Collectors.toList());
            ourLog.debug("Ignoring empty parameter: {}", (Object)theParamName);
            orList.removeAll(emptyParameters);
        });
        theAndOrParams.removeIf(List::isEmpty);
    }

    public QuantityParam getNearDistanceParam() {
        return this.myNearDistanceParam;
    }

    public void setNearDistanceParam(QuantityParam theQuantityParam) {
        this.myNearDistanceParam = theQuantityParam;
    }

    public boolean isWantOnlyCount() {
        return SummaryEnum.COUNT.equals((Object)this.getSummaryMode()) || INTEGER_0.equals(this.getCount());
    }

    public boolean isDeleteExpunge() {
        return this.myDeleteExpunge;
    }

    public SearchParameterMap setDeleteExpunge(boolean theDeleteExpunge) {
        this.myDeleteExpunge = theDeleteExpunge;
        return this;
    }

    public List<List<IQueryParameterType>> get(String theName) {
        return this.mySearchParameterMap.get(theName);
    }

    public void put(String theName, List<List<IQueryParameterType>> theParams) {
        this.mySearchParameterMap.put(theName, theParams);
    }

    public boolean containsKey(String theName) {
        return this.mySearchParameterMap.containsKey(theName);
    }

    public Set<String> keySet() {
        return this.mySearchParameterMap.keySet();
    }

    public boolean isEmpty() {
        return this.mySearchParameterMap.isEmpty();
    }

    public Set<Map.Entry<String, List<List<IQueryParameterType>>>> entrySet() {
        return this.mySearchParameterMap.entrySet();
    }

    public List<List<IQueryParameterType>> remove(String theName) {
        return this.mySearchParameterMap.remove(theName);
    }

    public List<List<IQueryParameterType>> removeByNameUnmodified(String theName) {
        return this.removeByNameAndModifier(theName, "");
    }

    public List<List<IQueryParameterType>> removeByNameAndModifier(String theName, String theModifier) {
        theModifier = StringUtils.defaultString((String)theModifier, (String)"");
        ArrayList<List<IQueryParameterType>> remainderParameters = new ArrayList<List<IQueryParameterType>>();
        ArrayList<List<IQueryParameterType>> matchingParameters = new ArrayList<List<IQueryParameterType>>();
        List<List<IQueryParameterType>> andList = this.mySearchParameterMap.remove(theName);
        if (andList != null) {
            for (List<IQueryParameterType> orList : andList) {
                if (!orList.isEmpty() && StringUtils.defaultString((String)orList.get(0).getQueryParameterQualifier(), (String)"").equals(theModifier)) {
                    matchingParameters.add(orList);
                    continue;
                }
                remainderParameters.add(orList);
            }
        }
        if (!remainderParameters.isEmpty()) {
            this.mySearchParameterMap.put(theName, remainderParameters);
        }
        return matchingParameters;
    }

    public List<List<IQueryParameterType>> removeByNameAndModifier(String theName, @Nonnull TokenParamModifier theModifier) {
        return this.removeByNameAndModifier(theName, theModifier.getValue());
    }

    public Map<String, List<List<IQueryParameterType>>> removeByQualifier(String theQualifier) {
        HashMap<String, List<List<IQueryParameterType>>> retVal = new HashMap<String, List<List<IQueryParameterType>>>();
        Set<String> parameterNames = this.mySearchParameterMap.keySet();
        for (String parameterName : parameterNames) {
            List<List<IQueryParameterType>> paramsWithQualifier = this.removeByNameAndModifier(parameterName, theQualifier);
            retVal.put(parameterName, paramsWithQualifier);
        }
        return retVal;
    }

    public Map<String, List<List<IQueryParameterType>>> removeByQualifier(@Nonnull TokenParamModifier theModifier) {
        return this.removeByQualifier(theModifier.getValue());
    }

    public int size() {
        return this.mySearchParameterMap.size();
    }

    public SearchContainedModeEnum getSearchContainedMode() {
        return this.mySearchContainedMode;
    }

    public void setSearchContainedMode(SearchContainedModeEnum theSearchContainedMode) {
        this.mySearchContainedMode = theSearchContainedMode == null ? SearchContainedModeEnum.FALSE : theSearchContainedMode;
    }

    public boolean isOffsetQuery() {
        return this.getOffset() != null && this.getCount() != null;
    }

    static int compare(FhirContext theCtx, IQueryParameterType theO1, IQueryParameterType theO2) {
        CompareToBuilder b = new CompareToBuilder();
        b.append((Object)theO1.getMissing(), (Object)theO2.getMissing());
        b.append((Object)theO1.getQueryParameterQualifier(), (Object)theO2.getQueryParameterQualifier());
        if (b.toComparison() == 0) {
            b.append((Object)theO1.getValueAsQueryToken(theCtx), (Object)theO2.getValueAsQueryToken(theCtx));
        }
        return b.toComparison();
    }

    public static SearchParameterMap newSynchronous() {
        SearchParameterMap retVal = new SearchParameterMap();
        retVal.setLoadSynchronous(true);
        return retVal;
    }

    public static SearchParameterMap newSynchronous(String theName, IQueryParameterType theParam) {
        SearchParameterMap retVal = new SearchParameterMap();
        retVal.setLoadSynchronous(true);
        retVal.add(theName, theParam);
        return retVal;
    }

    public List<SortSpec> getAllChainsInOrder() {
        ArrayList<SortSpec> allChainsInOrder = new ArrayList<SortSpec>();
        for (SortSpec sortSpec = this.getSort(); sortSpec != null; sortSpec = sortSpec.getChain()) {
            allChainsInOrder.add(sortSpec);
        }
        return Collections.unmodifiableList(allChainsInOrder);
    }

    public static final class EverythingModeEnum
    extends Enum<EverythingModeEnum> {
        public static final /* enum */ EverythingModeEnum ENCOUNTER_INSTANCE = new EverythingModeEnum(false, true, true);
        public static final /* enum */ EverythingModeEnum ENCOUNTER_TYPE = new EverythingModeEnum(false, true, false);
        public static final /* enum */ EverythingModeEnum PATIENT_INSTANCE = new EverythingModeEnum(true, false, true);
        public static final /* enum */ EverythingModeEnum PATIENT_TYPE = new EverythingModeEnum(true, false, false);
        private final boolean myEncounter;
        private final boolean myInstance;
        private final boolean myPatient;
        private static final /* synthetic */ EverythingModeEnum[] $VALUES;

        public static EverythingModeEnum[] values() {
            return (EverythingModeEnum[])$VALUES.clone();
        }

        public static EverythingModeEnum valueOf(String name) {
            return Enum.valueOf(EverythingModeEnum.class, name);
        }

        private EverythingModeEnum(boolean thePatient, boolean theEncounter, boolean theInstance) {
            assert (thePatient ^ theEncounter);
            this.myPatient = thePatient;
            this.myEncounter = theEncounter;
            this.myInstance = theInstance;
        }

        public boolean isEncounter() {
            return this.myEncounter;
        }

        public boolean isInstance() {
            return this.myInstance;
        }

        public boolean isPatient() {
            return this.myPatient;
        }

        private static /* synthetic */ EverythingModeEnum[] $values() {
            return new EverythingModeEnum[]{ENCOUNTER_INSTANCE, ENCOUNTER_TYPE, PATIENT_INSTANCE, PATIENT_TYPE};
        }

        static {
            $VALUES = EverythingModeEnum.$values();
        }
    }

    public static class IncludeComparator
    implements Comparator<Include> {
        @Override
        public int compare(Include theO1, Include theO2) {
            int retVal = StringUtils.compare((String)theO1.getParamType(), (String)theO2.getParamType());
            if (retVal == 0) {
                retVal = StringUtils.compare((String)theO1.getParamName(), (String)theO2.getParamName());
            }
            if (retVal == 0) {
                retVal = StringUtils.compare((String)theO1.getParamTargetType(), (String)theO2.getParamTargetType());
            }
            return retVal;
        }
    }

    public static class QueryParameterTypeComparator
    implements Comparator<IQueryParameterType> {
        private final FhirContext myCtx;

        QueryParameterTypeComparator(FhirContext theCtx) {
            this.myCtx = theCtx;
        }

        @Override
        public int compare(IQueryParameterType theO1, IQueryParameterType theO2) {
            return SearchParameterMap.compare(this.myCtx, theO1, theO2);
        }
    }

    public static class QueryParameterOrComparator
    implements Comparator<List<IQueryParameterType>> {
        private final FhirContext myCtx;

        QueryParameterOrComparator(FhirContext theCtx) {
            this.myCtx = theCtx;
        }

        @Override
        public int compare(List<IQueryParameterType> theO1, List<IQueryParameterType> theO2) {
            return SearchParameterMap.compare(this.myCtx, theO1.get(0), theO2.get(0));
        }
    }
}

