/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.extractor;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ComboSearchParamType;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParamQuantity;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboStringUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboTokenNonUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamCoords;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamDate;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamNumber;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantity;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantityNormalized;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamString;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamToken;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamUri;
import ca.uhn.fhir.jpa.model.entity.ResourceLink;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.model.util.UcumServiceUtil;
import ca.uhn.fhir.jpa.searchparam.extractor.GeopointNormalizer;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.PathAndRef;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParamComposite;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParams;
import ca.uhn.fhir.jpa.searchparam.extractor.StringTrimmingTrimmerMatcher;
import ca.uhn.fhir.jpa.searchparam.util.JpaParamUtil;
import ca.uhn.fhir.jpa.searchparam.util.RuntimeSearchParamHelper;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.dstu2.resource.ValueSet;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.StringUtil;
import ca.uhn.fhir.util.UrlUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.text.StringTokenizer;
import org.apache.commons.text.matcher.StringMatcher;
import org.fhir.ucum.Pair;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseEnumeration;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r5.model.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public abstract class BaseSearchParamExtractor
implements ISearchParamExtractor {
    public static final Set<String> COORDS_INDEX_PATHS;
    private static final Logger ourLog;
    @Autowired
    protected ApplicationContext myApplicationContext;
    @Autowired
    private FhirContext myContext;
    @Autowired
    private ISearchParamRegistry mySearchParamRegistry;
    @Autowired
    private StorageSettings myStorageSettings;
    @Autowired
    private PartitionSettings myPartitionSettings;
    private Set<String> myIgnoredForSearchDatatypes;
    private BaseRuntimeChildDefinition myQuantityValueValueChild;
    private BaseRuntimeChildDefinition myQuantitySystemValueChild;
    private BaseRuntimeChildDefinition myQuantityCodeValueChild;
    private BaseRuntimeChildDefinition myMoneyValueChild;
    private BaseRuntimeChildDefinition myMoneyCurrencyChild;
    private BaseRuntimeElementCompositeDefinition<?> myLocationPositionDefinition;
    private BaseRuntimeChildDefinition myCodeSystemUrlValueChild;
    private BaseRuntimeChildDefinition myRangeLowValueChild;
    private BaseRuntimeChildDefinition myRangeHighValueChild;
    private BaseRuntimeChildDefinition myAddressLineValueChild;
    private BaseRuntimeChildDefinition myAddressCityValueChild;
    private BaseRuntimeChildDefinition myAddressDistrictValueChild;
    private BaseRuntimeChildDefinition myAddressStateValueChild;
    private BaseRuntimeChildDefinition myAddressCountryValueChild;
    private BaseRuntimeChildDefinition myAddressPostalCodeValueChild;
    private BaseRuntimeChildDefinition myCapabilityStatementRestSecurityServiceValueChild;
    private BaseRuntimeChildDefinition myPeriodStartValueChild;
    private BaseRuntimeChildDefinition myPeriodEndValueChild;
    private BaseRuntimeChildDefinition myTimingEventValueChild;
    private BaseRuntimeChildDefinition myTimingRepeatValueChild;
    private BaseRuntimeChildDefinition myTimingRepeatBoundsValueChild;
    private BaseRuntimeChildDefinition myDurationSystemValueChild;
    private BaseRuntimeChildDefinition myDurationCodeValueChild;
    private BaseRuntimeChildDefinition myDurationValueValueChild;
    private BaseRuntimeChildDefinition myHumanNameFamilyValueChild;
    private BaseRuntimeChildDefinition myHumanNameGivenValueChild;
    private BaseRuntimeChildDefinition myHumanNameTextValueChild;
    private BaseRuntimeChildDefinition myHumanNamePrefixValueChild;
    private BaseRuntimeChildDefinition myHumanNameSuffixValueChild;
    private BaseRuntimeChildDefinition myContactPointValueValueChild;
    private BaseRuntimeChildDefinition myIdentifierSystemValueChild;
    private BaseRuntimeChildDefinition myIdentifierValueValueChild;
    private BaseRuntimeChildDefinition myIdentifierTypeValueChild;
    private BaseRuntimeChildDefinition myIdentifierTypeTextValueChild;
    private BaseRuntimeChildDefinition myCodeableConceptCodingValueChild;
    private BaseRuntimeChildDefinition myCodeableConceptTextValueChild;
    private BaseRuntimeChildDefinition myCodingSystemValueChild;
    private BaseRuntimeChildDefinition myCodingCodeValueChild;
    private BaseRuntimeChildDefinition myCodingDisplayValueChild;
    private BaseRuntimeChildDefinition myContactPointSystemValueChild;
    private BaseRuntimeChildDefinition myPatientCommunicationLanguageValueChild;
    private BaseRuntimeChildDefinition myCodeableReferenceConcept;
    private BaseRuntimeChildDefinition myCodeableReferenceReference;
    private boolean myExtractResourceLevelParams = false;

    BaseSearchParamExtractor() {
    }

    BaseSearchParamExtractor(StorageSettings theStorageSettings, PartitionSettings thePartitionSettings, FhirContext theCtx, ISearchParamRegistry theSearchParamRegistry) {
        Objects.requireNonNull(theStorageSettings);
        Objects.requireNonNull(theCtx);
        Objects.requireNonNull(theSearchParamRegistry);
        this.myStorageSettings = theStorageSettings;
        this.myContext = theCtx;
        this.mySearchParamRegistry = theSearchParamRegistry;
        this.myPartitionSettings = thePartitionSettings;
    }

    @Override
    public ISearchParamExtractor.SearchParamSet<PathAndRef> extractResourceLinks(IBaseResource theResource, boolean theWantLocalReferences) {
        IExtractor<PathAndRef> extractor = this.createReferenceExtractor();
        return this.extractSearchParams(theResource, extractor, RestSearchParameterTypeEnum.REFERENCE, theWantLocalReferences, ISearchParamExtractor.ALL_PARAMS);
    }

    private IExtractor<PathAndRef> createReferenceExtractor() {
        return new ResourceLinkExtractor();
    }

    @Override
    public PathAndRef extractReferenceLinkFromResource(IBase theValue, String thePath) {
        ResourceLinkExtractor extractor = new ResourceLinkExtractor();
        return extractor.get(theValue, thePath);
    }

    @Override
    public List<String> extractParamValuesAsStrings(RuntimeSearchParam theSearchParam, IBaseResource theResource) {
        IExtractor extractor = this.createExtractor(theSearchParam, theResource);
        if (theSearchParam.getParamType().equals((Object)RestSearchParameterTypeEnum.REFERENCE)) {
            return this.extractReferenceParamsAsQueryTokens(theSearchParam, theResource, extractor);
        }
        return this.extractParamsAsQueryTokens(theSearchParam, theResource, extractor);
    }

    @Nonnull
    private IExtractor createExtractor(RuntimeSearchParam theSearchParam, IBaseResource theResource) {
        IExtractor<PathAndRef> extractor;
        switch (theSearchParam.getParamType()) {
            case DATE: {
                extractor = this.createDateExtractor(theResource);
                break;
            }
            case STRING: {
                extractor = this.createStringExtractor(theResource);
                break;
            }
            case TOKEN: {
                extractor = this.createTokenExtractor(theResource);
                break;
            }
            case NUMBER: {
                extractor = this.createNumberExtractor(theResource);
                break;
            }
            case REFERENCE: {
                extractor = this.createReferenceExtractor();
                break;
            }
            case QUANTITY: {
                extractor = this.createQuantityExtractor(theResource);
                break;
            }
            case URI: {
                extractor = this.createUriExtractor(theResource);
                break;
            }
            case SPECIAL: {
                extractor = this.createSpecialExtractor(theResource.getIdElement().getResourceType());
                break;
            }
            default: {
                throw new UnsupportedOperationException(Msg.code((int)503) + "Type " + theSearchParam.getParamType() + " not supported for extraction");
            }
        }
        return extractor;
    }

    private List<String> extractReferenceParamsAsQueryTokens(RuntimeSearchParam theSearchParam, IBaseResource theResource, IExtractor<PathAndRef> theExtractor) {
        ISearchParamExtractor.SearchParamSet<PathAndRef> params = new ISearchParamExtractor.SearchParamSet<PathAndRef>();
        this.extractSearchParam(theSearchParam, (IBase)theResource, theExtractor, params, false);
        return this.refsToStringList(params);
    }

    private List<String> refsToStringList(ISearchParamExtractor.SearchParamSet<PathAndRef> theParams) {
        return theParams.stream().map(PathAndRef::getRef).map(ref -> ref.getReferenceElement().toUnqualifiedVersionless().getValue()).collect(Collectors.toList());
    }

    private <T extends BaseResourceIndexedSearchParam> List<String> extractParamsAsQueryTokens(RuntimeSearchParam theSearchParam, IBaseResource theResource, IExtractor<T> theExtractor) {
        ISearchParamExtractor.SearchParamSet params = new ISearchParamExtractor.SearchParamSet();
        this.extractSearchParam(theSearchParam, (IBase)theResource, theExtractor, params, false);
        return this.toStringList(params);
    }

    private <T extends BaseResourceIndexedSearchParam> List<String> toStringList(ISearchParamExtractor.SearchParamSet<T> theParams) {
        return theParams.stream().map(param -> param.toQueryParameterType().getValueAsQueryToken(this.myContext)).collect(Collectors.toList());
    }

    @Override
    public ISearchParamExtractor.SearchParamSet<ResourceIndexedSearchParamComposite> extractSearchParamComposites(IBaseResource theResource, ISearchParamExtractor.ISearchParamFilter theSearchParamFilter) {
        IExtractor<ResourceIndexedSearchParamComposite> extractor = this.createCompositeExtractor(theResource);
        return this.extractSearchParams(theResource, extractor, RestSearchParameterTypeEnum.COMPOSITE, false, theSearchParamFilter);
    }

    private IExtractor<ResourceIndexedSearchParamComposite> createCompositeExtractor(IBaseResource theResource) {
        return new CompositeExtractor(theResource);
    }

    @Override
    public ISearchParamExtractor.SearchParamSet<ResourceIndexedComboStringUnique> extractSearchParamComboUnique(String theResourceType, ResourceIndexedSearchParams theParams) {
        ISearchParamExtractor.SearchParamSet<ResourceIndexedComboStringUnique> retVal = new ISearchParamExtractor.SearchParamSet<ResourceIndexedComboStringUnique>();
        List runtimeComboUniqueParams = this.mySearchParamRegistry.getActiveComboSearchParams(theResourceType, ComboSearchParamType.UNIQUE);
        for (RuntimeSearchParam runtimeParam : runtimeComboUniqueParams) {
            ISearchParamExtractor.SearchParamSet<ResourceIndexedComboStringUnique> comboUniqueParams = this.createComboUniqueParam(theResourceType, theParams, runtimeParam);
            retVal.addAll(comboUniqueParams);
        }
        return retVal;
    }

    private ISearchParamExtractor.SearchParamSet<ResourceIndexedComboStringUnique> createComboUniqueParam(String theResourceType, ResourceIndexedSearchParams theParams, RuntimeSearchParam theRuntimeParam) {
        ISearchParamExtractor.SearchParamSet<ResourceIndexedComboStringUnique> retVal = new ISearchParamExtractor.SearchParamSet<ResourceIndexedComboStringUnique>();
        Set<String> queryStringsToPopulate = this.extractParameterCombinationsForComboParam(theParams, theResourceType, theRuntimeParam);
        for (String nextQueryString : queryStringsToPopulate) {
            ourLog.trace("Adding composite unique SP: {} on {} for {}", new Object[]{nextQueryString, theResourceType, theRuntimeParam.getId()});
            ResourceIndexedComboStringUnique uniqueParam = new ResourceIndexedComboStringUnique();
            uniqueParam.setIndexString(nextQueryString);
            uniqueParam.setSearchParameterId(theRuntimeParam.getId());
            retVal.add(uniqueParam);
        }
        return retVal;
    }

    @Override
    public ISearchParamExtractor.SearchParamSet<ResourceIndexedComboTokenNonUnique> extractSearchParamComboNonUnique(String theResourceType, ResourceIndexedSearchParams theParams) {
        ISearchParamExtractor.SearchParamSet<ResourceIndexedComboTokenNonUnique> retVal = new ISearchParamExtractor.SearchParamSet<ResourceIndexedComboTokenNonUnique>();
        List runtimeComboNonUniqueParams = this.mySearchParamRegistry.getActiveComboSearchParams(theResourceType, ComboSearchParamType.NON_UNIQUE);
        for (RuntimeSearchParam runtimeParam : runtimeComboNonUniqueParams) {
            ISearchParamExtractor.SearchParamSet<ResourceIndexedComboTokenNonUnique> comboNonUniqueParams = this.createComboNonUniqueParam(theResourceType, theParams, runtimeParam);
            retVal.addAll(comboNonUniqueParams);
        }
        return retVal;
    }

    private ISearchParamExtractor.SearchParamSet<ResourceIndexedComboTokenNonUnique> createComboNonUniqueParam(String theResourceType, ResourceIndexedSearchParams theParams, RuntimeSearchParam theRuntimeParam) {
        ISearchParamExtractor.SearchParamSet<ResourceIndexedComboTokenNonUnique> retVal = new ISearchParamExtractor.SearchParamSet<ResourceIndexedComboTokenNonUnique>();
        Set<String> queryStringsToPopulate = this.extractParameterCombinationsForComboParam(theParams, theResourceType, theRuntimeParam);
        for (String nextQueryString : queryStringsToPopulate) {
            ourLog.trace("Adding composite unique SP: {}", (Object)nextQueryString);
            ResourceIndexedComboTokenNonUnique nonUniqueParam = new ResourceIndexedComboTokenNonUnique();
            nonUniqueParam.setPartitionSettings(this.myPartitionSettings);
            nonUniqueParam.setIndexString(nextQueryString);
            nonUniqueParam.setSearchParameterId(theRuntimeParam.getId());
            retVal.add(nonUniqueParam);
        }
        return retVal;
    }

    @Nonnull
    private Set<String> extractParameterCombinationsForComboParam(ResourceIndexedSearchParams theParams, String theResourceType, RuntimeSearchParam theParam) {
        ArrayList<List<String>> partsChoices = new ArrayList<List<String>>();
        List<RuntimeSearchParam> compositeComponents = JpaParamUtil.resolveComponentParameters(this.mySearchParamRegistry, theParam);
        for (RuntimeSearchParam nextCompositeOf : compositeComponents) {
            Collection<? extends BaseResourceIndexedSearchParam> paramsListForCompositePart = this.findParameterIndexes(theParams, nextCompositeOf);
            Collection<ResourceLink> linksForCompositePart = null;
            switch (nextCompositeOf.getParamType()) {
                case REFERENCE: {
                    linksForCompositePart = theParams.myLinks;
                    break;
                }
            }
            HashSet linksForCompositePartWantPaths = null;
            switch (nextCompositeOf.getParamType()) {
                case REFERENCE: {
                    linksForCompositePartWantPaths = new HashSet(nextCompositeOf.getPathsSplit());
                    break;
                }
            }
            ArrayList<CallSite> nextChoicesList = new ArrayList<CallSite>();
            partsChoices.add(nextChoicesList);
            String key = UrlUtil.escapeUrlParam((String)nextCompositeOf.getName());
            if (paramsListForCompositePart != null) {
                for (BaseResourceIndexedSearchParam baseResourceIndexedSearchParam : paramsListForCompositePart) {
                    DateParam date;
                    IQueryParameterType nextParamAsClientParam = baseResourceIndexedSearchParam.toQueryParameterType();
                    if (nextParamAsClientParam instanceof DateParam && (date = (DateParam)nextParamAsClientParam).getPrecision() != TemporalPrecisionEnum.DAY) continue;
                    String value = nextParamAsClientParam.getValueAsQueryToken(this.myContext);
                    RuntimeSearchParam param = this.mySearchParamRegistry.getActiveSearchParam(theResourceType, key);
                    if (theParam.getComboSearchParamType() == ComboSearchParamType.NON_UNIQUE && param != null && param.getParamType() == RestSearchParameterTypeEnum.STRING) {
                        value = StringUtil.normalizeStringForSearchIndexing((String)value);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                    value = UrlUtil.escapeUrlParam((String)value);
                    nextChoicesList.add((CallSite)((Object)(key + "=" + value)));
                }
            }
            if (linksForCompositePart == null) continue;
            for (ResourceLink resourceLink : linksForCompositePart) {
                if (!linksForCompositePartWantPaths.contains(resourceLink.getSourcePath())) continue;
                assert (StringUtils.isNotBlank((CharSequence)resourceLink.getTargetResourceType()));
                assert (StringUtils.isNotBlank((CharSequence)resourceLink.getTargetResourceId()));
                Object value = resourceLink.getTargetResourceType() + "/" + resourceLink.getTargetResourceId();
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                value = UrlUtil.escapeUrlParam((String)value);
                nextChoicesList.add((CallSite)((Object)(key + "=" + (String)value)));
            }
        }
        return ResourceIndexedSearchParams.extractCompositeStringUniquesValueChains(theResourceType, partsChoices);
    }

    @Nullable
    private Collection<? extends BaseResourceIndexedSearchParam> findParameterIndexes(ResourceIndexedSearchParams theParams, RuntimeSearchParam nextCompositeOf) {
        Collection paramsListForCompositePart = null;
        switch (nextCompositeOf.getParamType()) {
            case NUMBER: {
                paramsListForCompositePart = theParams.myNumberParams;
                break;
            }
            case DATE: {
                paramsListForCompositePart = theParams.myDateParams;
                break;
            }
            case STRING: {
                paramsListForCompositePart = theParams.myStringParams;
                break;
            }
            case TOKEN: {
                paramsListForCompositePart = theParams.myTokenParams;
                break;
            }
            case QUANTITY: {
                paramsListForCompositePart = theParams.myQuantityParams;
                break;
            }
            case URI: {
                paramsListForCompositePart = theParams.myUriParams;
                break;
            }
        }
        if (paramsListForCompositePart != null) {
            paramsListForCompositePart = paramsListForCompositePart.stream().filter(t -> t.getParamName().equals(nextCompositeOf.getName())).collect(Collectors.toList());
        }
        return paramsListForCompositePart;
    }

    @Override
    public ISearchParamExtractor.SearchParamSet<BaseResourceIndexedSearchParam> extractSearchParamTokens(IBaseResource theResource, ISearchParamExtractor.ISearchParamFilter theSearchParamFilter) {
        IExtractor<BaseResourceIndexedSearchParam> extractor = this.createTokenExtractor(theResource);
        return this.extractSearchParams(theResource, extractor, RestSearchParameterTypeEnum.TOKEN, false, theSearchParamFilter);
    }

    @Override
    public ISearchParamExtractor.SearchParamSet<BaseResourceIndexedSearchParam> extractSearchParamTokens(IBaseResource theResource, RuntimeSearchParam theSearchParam) {
        IExtractor<BaseResourceIndexedSearchParam> extractor = this.createTokenExtractor(theResource);
        ISearchParamExtractor.SearchParamSet<BaseResourceIndexedSearchParam> setToPopulate = new ISearchParamExtractor.SearchParamSet<BaseResourceIndexedSearchParam>();
        this.extractSearchParam(theSearchParam, (IBase)theResource, extractor, setToPopulate, false);
        return setToPopulate;
    }

    private IExtractor<BaseResourceIndexedSearchParam> createTokenExtractor(IBaseResource theResource) {
        String useSystem;
        String resourceTypeName = this.toRootTypeName((IBase)theResource);
        if (this.getContext().getVersion().getVersion().equals((Object)FhirVersionEnum.DSTU2)) {
            if (resourceTypeName.equals("ValueSet")) {
                ValueSet dstu2ValueSet = (ValueSet)theResource;
                useSystem = dstu2ValueSet.getCodeSystem().getSystem();
            } else {
                useSystem = null;
            }
        } else {
            useSystem = resourceTypeName.equals("CodeSystem") ? BaseSearchParamExtractor.extractValueAsString(this.myCodeSystemUrlValueChild, (IBase)theResource) : null;
        }
        return new TokenExtractor(resourceTypeName, useSystem);
    }

    @Override
    public ISearchParamExtractor.SearchParamSet<BaseResourceIndexedSearchParam> extractSearchParamSpecial(IBaseResource theResource, ISearchParamExtractor.ISearchParamFilter theSearchParamFilter) {
        String resourceTypeName = this.toRootTypeName((IBase)theResource);
        IExtractor<BaseResourceIndexedSearchParam> extractor = this.createSpecialExtractor(resourceTypeName);
        return this.extractSearchParams(theResource, extractor, RestSearchParameterTypeEnum.SPECIAL, false, theSearchParamFilter);
    }

    private IExtractor<BaseResourceIndexedSearchParam> createSpecialExtractor(String theResourceTypeName) {
        return (params, searchParam, value, path, theWantLocalReferences) -> {
            if (COORDS_INDEX_PATHS.contains(path)) {
                this.addCoords_Position(theResourceTypeName, params, searchParam, value);
            }
        };
    }

    private void addUnexpectedDatatypeWarning(ISearchParamExtractor.SearchParamSet<?> theParams, RuntimeSearchParam theSearchParam, IBase theValue, String thePath) {
        String typeDesc = this.myContext.getElementDefinition(theValue.getClass()).getName();
        theParams.addWarning("Search param " + theSearchParam.getBase() + "#" + theSearchParam.getName() + " is unable to index value of type " + typeDesc + " as a " + theSearchParam.getParamType().name() + " at path: " + thePath);
    }

    @Override
    public ISearchParamExtractor.SearchParamSet<ResourceIndexedSearchParamUri> extractSearchParamUri(IBaseResource theResource, ISearchParamExtractor.ISearchParamFilter theSearchParamFilter) {
        IExtractor<ResourceIndexedSearchParamUri> extractor = this.createUriExtractor(theResource);
        return this.extractSearchParams(theResource, extractor, RestSearchParameterTypeEnum.URI, false, theSearchParamFilter);
    }

    private IExtractor<ResourceIndexedSearchParamUri> createUriExtractor(IBaseResource theResource) {
        return (params, searchParam, value, path, theWantLocalReferences) -> {
            String nextType = this.toRootTypeName(value);
            String resourceType = this.toRootTypeName((IBase)theResource);
            switch (nextType) {
                case "uri": 
                case "url": 
                case "oid": 
                case "sid": 
                case "uuid": {
                    this.addUri_Uri(resourceType, params, searchParam, value);
                    break;
                }
                default: {
                    this.addUnexpectedDatatypeWarning(params, searchParam, value, path);
                }
            }
        };
    }

    @Override
    public ISearchParamExtractor.SearchParamSet<ResourceIndexedSearchParamDate> extractSearchParamDates(IBaseResource theResource, ISearchParamExtractor.ISearchParamFilter theSearchParamFilter) {
        IExtractor<ResourceIndexedSearchParamDate> extractor = this.createDateExtractor(theResource);
        return this.extractSearchParams(theResource, extractor, RestSearchParameterTypeEnum.DATE, false, theSearchParamFilter);
    }

    private IExtractor<ResourceIndexedSearchParamDate> createDateExtractor(IBaseResource theResource) {
        return new DateExtractor(theResource);
    }

    @Override
    public Date extractDateFromResource(IBase theValue, String thePath) {
        DateExtractor extractor = new DateExtractor("DateType");
        return extractor.get(theValue, thePath, false).getValueHigh();
    }

    @Override
    public ISearchParamExtractor.SearchParamSet<ResourceIndexedSearchParamNumber> extractSearchParamNumber(IBaseResource theResource, ISearchParamExtractor.ISearchParamFilter theSearchParamFilter) {
        IExtractor<ResourceIndexedSearchParamNumber> extractor = this.createNumberExtractor(theResource);
        return this.extractSearchParams(theResource, extractor, RestSearchParameterTypeEnum.NUMBER, false, theSearchParamFilter);
    }

    private IExtractor<ResourceIndexedSearchParamNumber> createNumberExtractor(IBaseResource theResource) {
        return (params, searchParam, value, path, theWantLocalReferences) -> {
            String nextType = this.toRootTypeName(value);
            String resourceType = this.toRootTypeName((IBase)theResource);
            switch (nextType) {
                case "Duration": {
                    this.addNumber_Duration(resourceType, params, searchParam, value);
                    break;
                }
                case "Quantity": {
                    this.addNumber_Quantity(resourceType, params, searchParam, value);
                    break;
                }
                case "integer": 
                case "positiveInt": 
                case "unsignedInt": {
                    this.addNumber_Integer(resourceType, params, searchParam, value);
                    break;
                }
                case "decimal": {
                    this.addNumber_Decimal(resourceType, params, searchParam, value);
                    break;
                }
                case "Range": {
                    this.addNumber_Range(resourceType, params, searchParam, value);
                    break;
                }
                default: {
                    this.addUnexpectedDatatypeWarning(params, searchParam, value, path);
                }
            }
        };
    }

    @Override
    public ISearchParamExtractor.SearchParamSet<ResourceIndexedSearchParamQuantity> extractSearchParamQuantity(IBaseResource theResource, ISearchParamExtractor.ISearchParamFilter theSearchParamFilter) {
        IExtractor<ResourceIndexedSearchParamQuantity> extractor = this.createQuantityUnnormalizedExtractor(theResource);
        return this.extractSearchParams(theResource, extractor, RestSearchParameterTypeEnum.QUANTITY, false, theSearchParamFilter);
    }

    @Override
    public ISearchParamExtractor.SearchParamSet<ResourceIndexedSearchParamQuantityNormalized> extractSearchParamQuantityNormalized(IBaseResource theResource, ISearchParamExtractor.ISearchParamFilter theSearchParamFilter) {
        IExtractor<ResourceIndexedSearchParamQuantityNormalized> extractor = this.createQuantityNormalizedExtractor(theResource);
        return this.extractSearchParams(theResource, extractor, RestSearchParameterTypeEnum.QUANTITY, false, theSearchParamFilter);
    }

    @Nonnull
    private IExtractor<? extends BaseResourceIndexedSearchParamQuantity> createQuantityExtractor(IBaseResource theResource) {
        IExtractor<Object> result = this.myStorageSettings.getNormalizedQuantitySearchLevel().storageOrSearchSupported() ? new MultiplexExtractor<ResourceIndexedSearchParamQuantityNormalized>(this.createQuantityUnnormalizedExtractor(theResource), this.createQuantityNormalizedExtractor(theResource)) : this.createQuantityUnnormalizedExtractor(theResource);
        return result;
    }

    @Nonnull
    private IExtractor<ResourceIndexedSearchParamQuantity> createQuantityUnnormalizedExtractor(IBaseResource theResource) {
        String resourceType = this.toRootTypeName((IBase)theResource);
        return (params, searchParam, value, path, theWantLocalReferences) -> {
            String nextType;
            if (value.getClass().equals(this.myLocationPositionDefinition.getImplementingClass())) {
                return;
            }
            switch (nextType = this.toRootTypeName(value)) {
                case "Quantity": {
                    this.addQuantity_Quantity(resourceType, params, searchParam, value);
                    break;
                }
                case "Money": {
                    this.addQuantity_Money(resourceType, params, searchParam, value);
                    break;
                }
                case "Range": {
                    this.addQuantity_Range(resourceType, params, searchParam, value);
                    break;
                }
                default: {
                    this.addUnexpectedDatatypeWarning(params, searchParam, value, path);
                }
            }
        };
    }

    private IExtractor<ResourceIndexedSearchParamQuantityNormalized> createQuantityNormalizedExtractor(IBaseResource theResource) {
        return (params, searchParam, value, path, theWantLocalReferences) -> {
            if (value.getClass().equals(this.myLocationPositionDefinition.getImplementingClass())) {
                return;
            }
            String nextType = this.toRootTypeName(value);
            String resourceType = this.toRootTypeName((IBase)theResource);
            switch (nextType) {
                case "Quantity": {
                    this.addQuantity_QuantityNormalized(resourceType, params, searchParam, value);
                    break;
                }
                case "Money": {
                    this.addQuantity_MoneyNormalized(resourceType, params, searchParam, value);
                    break;
                }
                case "Range": {
                    this.addQuantity_RangeNormalized(resourceType, params, searchParam, value);
                    break;
                }
                default: {
                    this.addUnexpectedDatatypeWarning(params, searchParam, value, path);
                }
            }
        };
    }

    @Override
    public ISearchParamExtractor.SearchParamSet<ResourceIndexedSearchParamString> extractSearchParamStrings(IBaseResource theResource, ISearchParamExtractor.ISearchParamFilter theSearchParamFilter) {
        IExtractor<ResourceIndexedSearchParamString> extractor = this.createStringExtractor(theResource);
        return this.extractSearchParams(theResource, extractor, RestSearchParameterTypeEnum.STRING, false, theSearchParamFilter);
    }

    private IExtractor<ResourceIndexedSearchParamString> createStringExtractor(IBaseResource theResource) {
        String resourceType = this.toRootTypeName((IBase)theResource);
        return (params, searchParam, value, path, theWantLocalReferences) -> {
            String nextType;
            if (value instanceof IPrimitiveType) {
                IPrimitiveType nextValue = (IPrimitiveType)value;
                String valueAsString = nextValue.getValueAsString();
                this.createStringIndexIfNotBlank(resourceType, params, searchParam, valueAsString);
                return;
            }
            switch (nextType = this.toRootTypeName(value)) {
                case "HumanName": {
                    this.addString_HumanName(resourceType, params, searchParam, value);
                    break;
                }
                case "Address": {
                    this.addString_Address(resourceType, params, searchParam, value);
                    break;
                }
                case "ContactPoint": {
                    this.addString_ContactPoint(resourceType, params, searchParam, value);
                    break;
                }
                case "Quantity": {
                    this.addString_Quantity(resourceType, params, searchParam, value);
                    break;
                }
                case "Range": {
                    this.addString_Range(resourceType, params, searchParam, value);
                    break;
                }
                case "Period": {
                    break;
                }
                default: {
                    this.addUnexpectedDatatypeWarning(params, searchParam, value, path);
                }
            }
        };
    }

    @Override
    public List<IBase> extractValues(String thePaths, IBase theResource) {
        ArrayList<IBase> values = new ArrayList<IBase>();
        if (StringUtils.isNotBlank((CharSequence)thePaths)) {
            String[] nextPathsSplit;
            for (String nextPath : nextPathsSplit = this.split(thePaths)) {
                List<? extends IBase> allValues;
                if (this.myContext.getVersion().getVersion().equals((Object)FhirVersionEnum.DSTU2) && nextPath.equals("Bundle.entry.resource(0)")) continue;
                nextPath = StringUtils.trim((String)nextPath);
                IValueExtractor allValuesFunc = this.getPathValueExtractor(theResource, nextPath);
                try {
                    allValues = allValuesFunc.get();
                }
                catch (Exception e) {
                    String msg = this.getContext().getLocalizer().getMessage(BaseSearchParamExtractor.class, "failedToExtractPaths", new Object[]{nextPath, e.toString()});
                    throw new InternalErrorException(Msg.code((int)504) + msg, (Throwable)e);
                }
                values.addAll(allValues);
            }
            for (int i = 0; i < values.size(); ++i) {
                IBase nextObject = (IBase)values.get(i);
                if (!(nextObject instanceof IBaseExtension)) continue;
                IBaseExtension nextExtension = (IBaseExtension)nextObject;
                nextObject = nextExtension.getValue();
                values.set(i, nextObject);
            }
        }
        return values;
    }

    protected FhirContext getContext() {
        return this.myContext;
    }

    @VisibleForTesting
    public void setContext(FhirContext theContext) {
        this.myContext = theContext;
    }

    protected StorageSettings getStorageSettings() {
        return this.myStorageSettings;
    }

    @VisibleForTesting
    public void setStorageSettings(StorageSettings theStorageSettings) {
        this.myStorageSettings = theStorageSettings;
    }

    @VisibleForTesting
    public void setSearchParamRegistry(ISearchParamRegistry theSearchParamRegistry) {
        this.mySearchParamRegistry = theSearchParamRegistry;
    }

    @VisibleForTesting
    Collection<RuntimeSearchParam> getSearchParams(IBaseResource theResource) {
        RuntimeResourceDefinition def = this.getContext().getResourceDefinition(theResource);
        Collection retVal = this.mySearchParamRegistry.getActiveSearchParams(def.getName()).values();
        List defaultList = Collections.emptyList();
        retVal = (Collection)ObjectUtils.defaultIfNull((Object)retVal, defaultList);
        return retVal;
    }

    private void addQuantity_Quantity(String theResourceType, Set<ResourceIndexedSearchParamQuantity> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        Optional valueField = this.myQuantityValueValueChild.getAccessor().getFirstValueOrNull(theValue);
        if (valueField.isPresent() && ((IPrimitiveType)valueField.get()).getValue() != null) {
            BigDecimal nextValueValue = (BigDecimal)((IPrimitiveType)valueField.get()).getValue();
            String system = BaseSearchParamExtractor.extractValueAsString(this.myQuantitySystemValueChild, theValue);
            String code = BaseSearchParamExtractor.extractValueAsString(this.myQuantityCodeValueChild, theValue);
            ResourceIndexedSearchParamQuantity nextEntity = new ResourceIndexedSearchParamQuantity(this.myPartitionSettings, theResourceType, theSearchParam.getName(), nextValueValue, system, code);
            theParams.add(nextEntity);
        }
    }

    private void addQuantity_QuantityNormalized(String theResourceType, Set<ResourceIndexedSearchParamQuantityNormalized> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        Optional valueField = this.myQuantityValueValueChild.getAccessor().getFirstValueOrNull(theValue);
        if (valueField.isPresent() && ((IPrimitiveType)valueField.get()).getValue() != null) {
            String code;
            BigDecimal nextValueValue = (BigDecimal)((IPrimitiveType)valueField.get()).getValue();
            String system = BaseSearchParamExtractor.extractValueAsString(this.myQuantitySystemValueChild, theValue);
            Pair canonicalForm = UcumServiceUtil.getCanonicalForm((String)system, (BigDecimal)nextValueValue, (String)(code = BaseSearchParamExtractor.extractValueAsString(this.myQuantityCodeValueChild, theValue)));
            if (canonicalForm != null) {
                double canonicalValue = Double.parseDouble(canonicalForm.getValue().asDecimal());
                String canonicalUnits = canonicalForm.getCode();
                ResourceIndexedSearchParamQuantityNormalized nextEntity = new ResourceIndexedSearchParamQuantityNormalized(this.myPartitionSettings, theResourceType, theSearchParam.getName(), canonicalValue, system, canonicalUnits);
                theParams.add(nextEntity);
            }
        }
    }

    private void addQuantity_Money(String theResourceType, Set<ResourceIndexedSearchParamQuantity> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        Optional valueField = this.myMoneyValueChild.getAccessor().getFirstValueOrNull(theValue);
        if (valueField.isPresent() && ((IPrimitiveType)valueField.get()).getValue() != null) {
            BigDecimal nextValueValue = (BigDecimal)((IPrimitiveType)valueField.get()).getValue();
            String nextValueString = "urn:iso:std:iso:4217";
            String nextValueCode = BaseSearchParamExtractor.extractValueAsString(this.myMoneyCurrencyChild, theValue);
            String searchParamName = theSearchParam.getName();
            ResourceIndexedSearchParamQuantity nextEntity = new ResourceIndexedSearchParamQuantity(this.myPartitionSettings, theResourceType, searchParamName, nextValueValue, nextValueString, nextValueCode);
            theParams.add(nextEntity);
        }
    }

    private void addQuantity_MoneyNormalized(String theResourceType, Set<ResourceIndexedSearchParamQuantityNormalized> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        Optional valueField = this.myMoneyValueChild.getAccessor().getFirstValueOrNull(theValue);
        if (valueField.isPresent() && ((IPrimitiveType)valueField.get()).getValue() != null) {
            BigDecimal nextValueValue = (BigDecimal)((IPrimitiveType)valueField.get()).getValue();
            String nextValueString = "urn:iso:std:iso:4217";
            String nextValueCode = BaseSearchParamExtractor.extractValueAsString(this.myMoneyCurrencyChild, theValue);
            String searchParamName = theSearchParam.getName();
            ResourceIndexedSearchParamQuantityNormalized nextEntityNormalized = new ResourceIndexedSearchParamQuantityNormalized(this.myPartitionSettings, theResourceType, searchParamName, nextValueValue.doubleValue(), nextValueString, nextValueCode);
            theParams.add(nextEntityNormalized);
        }
    }

    private void addQuantity_Range(String theResourceType, Set<ResourceIndexedSearchParamQuantity> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        Optional low = this.myRangeLowValueChild.getAccessor().getFirstValueOrNull(theValue);
        low.ifPresent(theIBase -> this.addQuantity_Quantity(theResourceType, theParams, theSearchParam, (IBase)theIBase));
        Optional high = this.myRangeHighValueChild.getAccessor().getFirstValueOrNull(theValue);
        high.ifPresent(theIBase -> this.addQuantity_Quantity(theResourceType, theParams, theSearchParam, (IBase)theIBase));
    }

    private void addQuantity_RangeNormalized(String theResourceType, Set<ResourceIndexedSearchParamQuantityNormalized> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        Optional low = this.myRangeLowValueChild.getAccessor().getFirstValueOrNull(theValue);
        low.ifPresent(theIBase -> this.addQuantity_QuantityNormalized(theResourceType, theParams, theSearchParam, (IBase)theIBase));
        Optional high = this.myRangeHighValueChild.getAccessor().getFirstValueOrNull(theValue);
        high.ifPresent(theIBase -> this.addQuantity_QuantityNormalized(theResourceType, theParams, theSearchParam, (IBase)theIBase));
    }

    private void addToken_Identifier(String theResourceType, Set<BaseResourceIndexedSearchParam> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        String system = BaseSearchParamExtractor.extractValueAsString(this.myIdentifierSystemValueChild, theValue);
        String value = BaseSearchParamExtractor.extractValueAsString(this.myIdentifierValueValueChild, theValue);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            Optional type;
            this.createTokenIndexIfNotBlankAndAdd(theResourceType, theParams, theSearchParam, system, value);
            boolean indexIdentifierType = this.myStorageSettings.isIndexIdentifierOfType();
            if (indexIdentifierType && (type = this.myIdentifierTypeValueChild.getAccessor().getFirstValueOrNull(theValue)).isPresent()) {
                List codings = this.myCodeableConceptCodingValueChild.getAccessor().getValues((IBase)type.get());
                for (IBase nextCoding : codings) {
                    String typeSystem = this.myCodingSystemValueChild.getAccessor().getFirstValueOrNull(nextCoding).map(t -> (String)((IPrimitiveType)t).getValue()).orElse(null);
                    String typeValue = this.myCodingCodeValueChild.getAccessor().getFirstValueOrNull(nextCoding).map(t -> (String)((IPrimitiveType)t).getValue()).orElse(null);
                    if (!StringUtils.isNotBlank((CharSequence)typeSystem) || !StringUtils.isNotBlank((CharSequence)typeValue)) continue;
                    String paramName = theSearchParam.getName() + ":of-type";
                    ResourceIndexedSearchParamToken token = this.createTokenIndexIfNotBlank(theResourceType, typeSystem, typeValue + "|" + value, paramName);
                    if (token == null) continue;
                    theParams.add((BaseResourceIndexedSearchParam)token);
                }
            }
        }
    }

    protected boolean shouldIndexTextComponentOfToken(RuntimeSearchParam theSearchParam) {
        return BaseSearchParamExtractor.tokenTextIndexingEnabledForSearchParam(this.myStorageSettings, theSearchParam);
    }

    private void addToken_CodeableConcept(String theResourceType, Set<BaseResourceIndexedSearchParam> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        String text;
        List<IBase> codings = this.getCodingsFromCodeableConcept(theValue);
        for (IBase nextCoding : codings) {
            this.addToken_Coding(theResourceType, theParams, theSearchParam, nextCoding);
        }
        if (this.shouldIndexTextComponentOfToken(theSearchParam) && StringUtils.isNotBlank((CharSequence)(text = this.getDisplayTextFromCodeableConcept(theValue)))) {
            this.createStringIndexIfNotBlank(theResourceType, theParams, theSearchParam, text);
        }
    }

    @Override
    public List<IBase> getCodingsFromCodeableConcept(IBase theValue) {
        String nextType = this.toRootTypeName(theValue);
        if ("CodeableConcept".equals(nextType)) {
            return this.myCodeableConceptCodingValueChild.getAccessor().getValues(theValue);
        }
        return null;
    }

    @Override
    public String getDisplayTextFromCodeableConcept(IBase theValue) {
        String nextType = this.toRootTypeName(theValue);
        if ("CodeableConcept".equals(nextType)) {
            return BaseSearchParamExtractor.extractValueAsString(this.myCodeableConceptTextValueChild, theValue);
        }
        return null;
    }

    private void addToken_Coding(String theResourceType, Set<BaseResourceIndexedSearchParam> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        ResourceIndexedSearchParamToken resourceIndexedSearchParamToken = this.createSearchParamForCoding(theResourceType, theSearchParam, theValue);
        if (resourceIndexedSearchParamToken != null) {
            theParams.add((BaseResourceIndexedSearchParam)resourceIndexedSearchParamToken);
        }
        if (this.shouldIndexTextComponentOfToken(theSearchParam)) {
            String text = this.getDisplayTextForCoding(theValue);
            this.createStringIndexIfNotBlank(theResourceType, theParams, theSearchParam, text);
        }
    }

    @Override
    public ResourceIndexedSearchParamToken createSearchParamForCoding(String theResourceType, RuntimeSearchParam theSearchParam, IBase theValue) {
        String nextType = this.toRootTypeName(theValue);
        if ("Coding".equals(nextType)) {
            String system = BaseSearchParamExtractor.extractValueAsString(this.myCodingSystemValueChild, theValue);
            String code = BaseSearchParamExtractor.extractValueAsString(this.myCodingCodeValueChild, theValue);
            return this.createTokenIndexIfNotBlank(theResourceType, system, code, theSearchParam.getName());
        }
        return null;
    }

    @Override
    public String getDisplayTextForCoding(IBase theValue) {
        String nextType = this.toRootTypeName(theValue);
        if ("Coding".equals(nextType)) {
            return BaseSearchParamExtractor.extractValueAsString(this.myCodingDisplayValueChild, theValue);
        }
        return null;
    }

    private void addToken_ContactPoint(String theResourceType, Set<BaseResourceIndexedSearchParam> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        String system = BaseSearchParamExtractor.extractValueAsString(this.myContactPointSystemValueChild, theValue);
        String value = BaseSearchParamExtractor.extractValueAsString(this.myContactPointValueValueChild, theValue);
        this.createTokenIndexIfNotBlankAndAdd(theResourceType, theParams, theSearchParam, system, value);
    }

    private void addToken_CodeableReference(String theResourceType, Set<BaseResourceIndexedSearchParam> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        Optional conceptOpt = this.myCodeableReferenceConcept.getAccessor().getFirstValueOrNull(theValue);
        conceptOpt.ifPresent(concept -> this.addToken_CodeableConcept(theResourceType, theParams, theSearchParam, (IBase)concept));
    }

    private void addToken_PatientCommunication(String theResourceType, Set<BaseResourceIndexedSearchParam> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        List values = this.myPatientCommunicationLanguageValueChild.getAccessor().getValues(theValue);
        for (IBase next : values) {
            this.addToken_CodeableConcept(theResourceType, theParams, theSearchParam, next);
        }
    }

    private void addToken_CapabilityStatementRestSecurity(String theResourceType, Set<BaseResourceIndexedSearchParam> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        List values = this.myCapabilityStatementRestSecurityServiceValueChild.getAccessor().getValues(theValue);
        for (IBase nextValue : values) {
            this.addToken_CodeableConcept(theResourceType, theParams, theSearchParam, nextValue);
        }
    }

    private void addDate_Period(String theResourceType, Set<ResourceIndexedSearchParamDate> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        Date start = BaseSearchParamExtractor.extractValueAsDate(this.myPeriodStartValueChild, theValue);
        String startAsString = BaseSearchParamExtractor.extractValueAsString(this.myPeriodStartValueChild, theValue);
        Date end = BaseSearchParamExtractor.extractValueAsDate(this.myPeriodEndValueChild, theValue);
        String endAsString = BaseSearchParamExtractor.extractValueAsString(this.myPeriodEndValueChild, theValue);
        if (start != null || end != null) {
            if (start == null) {
                start = (Date)this.myStorageSettings.getPeriodIndexStartOfTime().getValue();
                startAsString = this.myStorageSettings.getPeriodIndexStartOfTime().getValueAsString();
            }
            if (end == null) {
                end = (Date)this.myStorageSettings.getPeriodIndexEndOfTime().getValue();
                endAsString = this.myStorageSettings.getPeriodIndexEndOfTime().getValueAsString();
            }
            ResourceIndexedSearchParamDate nextEntity = new ResourceIndexedSearchParamDate(this.myPartitionSettings, theResourceType, theSearchParam.getName(), start, startAsString, end, endAsString, startAsString);
            theParams.add(nextEntity);
        }
    }

    private void addDate_Timing(String theResourceType, Set<ResourceIndexedSearchParamDate> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        String boundsType;
        Optional bounds;
        List<IPrimitiveType<Date>> values = BaseSearchParamExtractor.extractValuesAsFhirDates(this.myTimingEventValueChild, theValue);
        TreeSet<Date> dates = new TreeSet<Date>();
        String firstValue = null;
        String finalValue = null;
        for (IPrimitiveType<Date> nextEvent : values) {
            if (nextEvent.getValue() == null) continue;
            dates.add((Date)nextEvent.getValue());
            if (firstValue == null) {
                firstValue = nextEvent.getValueAsString();
            }
            finalValue = nextEvent.getValueAsString();
        }
        Optional repeat = this.myTimingRepeatValueChild.getAccessor().getFirstValueOrNull(theValue);
        if (repeat.isPresent() && (bounds = this.myTimingRepeatBoundsValueChild.getAccessor().getFirstValueOrNull((IBase)repeat.get())).isPresent() && "Period".equals(boundsType = this.toRootTypeName((IBase)bounds.get()))) {
            Date start = BaseSearchParamExtractor.extractValueAsDate(this.myPeriodStartValueChild, (IBase)bounds.get());
            Date end = BaseSearchParamExtractor.extractValueAsDate(this.myPeriodEndValueChild, (IBase)bounds.get());
            String endString = BaseSearchParamExtractor.extractValueAsString(this.myPeriodEndValueChild, (IBase)bounds.get());
            dates.add(start);
            dates.add(end);
            if (firstValue == null) {
                firstValue = BaseSearchParamExtractor.extractValueAsString(this.myPeriodStartValueChild, (IBase)bounds.get());
            }
            finalValue = endString;
        }
        if (!dates.isEmpty()) {
            ResourceIndexedSearchParamDate nextEntity = new ResourceIndexedSearchParamDate(this.myPartitionSettings, theResourceType, theSearchParam.getName(), (Date)dates.first(), firstValue, (Date)dates.last(), finalValue, firstValue);
            theParams.add(nextEntity);
        }
    }

    private void addNumber_Duration(String theResourceType, Set<ResourceIndexedSearchParamNumber> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        String system = BaseSearchParamExtractor.extractValueAsString(this.myDurationSystemValueChild, theValue);
        String code = BaseSearchParamExtractor.extractValueAsString(this.myDurationCodeValueChild, theValue);
        BigDecimal value = BaseSearchParamExtractor.extractValueAsBigDecimal(this.myDurationValueValueChild, theValue);
        if (value != null) {
            value = this.normalizeQuantityContainingTimeUnitsIntoDaysForNumberParam(system, code, value);
            ResourceIndexedSearchParamNumber nextEntity = new ResourceIndexedSearchParamNumber(this.myPartitionSettings, theResourceType, theSearchParam.getName(), value);
            theParams.add(nextEntity);
        }
    }

    private void addNumber_Quantity(String theResourceType, Set<ResourceIndexedSearchParamNumber> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        BigDecimal value = BaseSearchParamExtractor.extractValueAsBigDecimal(this.myQuantityValueValueChild, theValue);
        if (value != null) {
            String system = BaseSearchParamExtractor.extractValueAsString(this.myQuantitySystemValueChild, theValue);
            String code = BaseSearchParamExtractor.extractValueAsString(this.myQuantityCodeValueChild, theValue);
            value = this.normalizeQuantityContainingTimeUnitsIntoDaysForNumberParam(system, code, value);
            ResourceIndexedSearchParamNumber nextEntity = new ResourceIndexedSearchParamNumber(this.myPartitionSettings, theResourceType, theSearchParam.getName(), value);
            theParams.add(nextEntity);
        }
    }

    private void addNumber_Range(String theResourceType, Set<ResourceIndexedSearchParamNumber> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        Optional low = this.myRangeLowValueChild.getAccessor().getFirstValueOrNull(theValue);
        low.ifPresent(value -> this.addNumber_Quantity(theResourceType, theParams, theSearchParam, (IBase)value));
        Optional high = this.myRangeHighValueChild.getAccessor().getFirstValueOrNull(theValue);
        high.ifPresent(value -> this.addNumber_Quantity(theResourceType, theParams, theSearchParam, (IBase)value));
    }

    private void addNumber_Integer(String theResourceType, Set<ResourceIndexedSearchParamNumber> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        IPrimitiveType value = (IPrimitiveType)theValue;
        if (value.getValue() != null) {
            BigDecimal valueDecimal = new BigDecimal((Integer)value.getValue());
            ResourceIndexedSearchParamNumber nextEntity = new ResourceIndexedSearchParamNumber(this.myPartitionSettings, theResourceType, theSearchParam.getName(), valueDecimal);
            theParams.add(nextEntity);
        }
    }

    private void addNumber_Decimal(String theResourceType, Set<ResourceIndexedSearchParamNumber> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        IPrimitiveType value = (IPrimitiveType)theValue;
        if (value.getValue() != null) {
            BigDecimal valueDecimal = (BigDecimal)value.getValue();
            ResourceIndexedSearchParamNumber nextEntity = new ResourceIndexedSearchParamNumber(this.myPartitionSettings, theResourceType, theSearchParam.getName(), valueDecimal);
            theParams.add(nextEntity);
        }
    }

    private void addCoords_Position(String theResourceType, ISearchParamExtractor.SearchParamSet<BaseResourceIndexedSearchParam> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        Location.LocationPositionComponent value;
        BigDecimal latitude = null;
        BigDecimal longitude = null;
        if (theValue instanceof Location.LocationPositionComponent) {
            value = (Location.LocationPositionComponent)theValue;
            latitude = value.getLatitude();
            longitude = value.getLongitude();
        } else if (theValue instanceof Location.LocationPositionComponent) {
            value = (Location.LocationPositionComponent)theValue;
            latitude = value.getLatitude();
            longitude = value.getLongitude();
        } else if (theValue instanceof Location.LocationPositionComponent) {
            value = (Location.LocationPositionComponent)theValue;
            latitude = value.getLatitude();
            longitude = value.getLongitude();
        }
        if (latitude != null && longitude != null) {
            double normalizedLatitude = GeopointNormalizer.normalizeLatitude(latitude.doubleValue());
            double normalizedLongitude = GeopointNormalizer.normalizeLongitude(longitude.doubleValue());
            ResourceIndexedSearchParamCoords nextEntity = new ResourceIndexedSearchParamCoords(this.myPartitionSettings, theResourceType, theSearchParam.getName(), normalizedLatitude, normalizedLongitude);
            theParams.add(nextEntity);
        }
    }

    private void addString_HumanName(String theResourceType, Set<ResourceIndexedSearchParamString> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        List<BaseRuntimeChildDefinition> myHumanNameChildren = Arrays.asList(this.myHumanNameFamilyValueChild, this.myHumanNameGivenValueChild, this.myHumanNameTextValueChild, this.myHumanNamePrefixValueChild, this.myHumanNameSuffixValueChild);
        for (BaseRuntimeChildDefinition theChild : myHumanNameChildren) {
            List<String> indices = BaseSearchParamExtractor.extractValuesAsStrings(theChild, theValue);
            for (String next : indices) {
                this.createStringIndexIfNotBlank(theResourceType, theParams, theSearchParam, next);
            }
        }
    }

    private void addString_Quantity(String theResourceType, Set<ResourceIndexedSearchParamString> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        BigDecimal value = BaseSearchParamExtractor.extractValueAsBigDecimal(this.myQuantityValueValueChild, theValue);
        if (value != null) {
            this.createStringIndexIfNotBlank(theResourceType, theParams, theSearchParam, value.toPlainString());
        }
    }

    private void addString_Range(String theResourceType, Set<ResourceIndexedSearchParamString> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        Optional value = this.myRangeLowValueChild.getAccessor().getFirstValueOrNull(theValue);
        value.ifPresent(t -> this.addString_Quantity(theResourceType, theParams, theSearchParam, (IBase)t));
    }

    private void addString_ContactPoint(String theResourceType, Set<ResourceIndexedSearchParamString> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        String value = BaseSearchParamExtractor.extractValueAsString(this.myContactPointValueValueChild, theValue);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.createStringIndexIfNotBlank(theResourceType, theParams, theSearchParam, value);
        }
    }

    private void addString_Address(String theResourceType, Set<ResourceIndexedSearchParamString> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        String postalCode;
        String country;
        String state;
        String district;
        ArrayList<String> allNames = new ArrayList<String>(BaseSearchParamExtractor.extractValuesAsStrings(this.myAddressLineValueChild, theValue));
        String city = BaseSearchParamExtractor.extractValueAsString(this.myAddressCityValueChild, theValue);
        if (StringUtils.isNotBlank((CharSequence)city)) {
            allNames.add(city);
        }
        if (StringUtils.isNotBlank((CharSequence)(district = BaseSearchParamExtractor.extractValueAsString(this.myAddressDistrictValueChild, theValue)))) {
            allNames.add(district);
        }
        if (StringUtils.isNotBlank((CharSequence)(state = BaseSearchParamExtractor.extractValueAsString(this.myAddressStateValueChild, theValue)))) {
            allNames.add(state);
        }
        if (StringUtils.isNotBlank((CharSequence)(country = BaseSearchParamExtractor.extractValueAsString(this.myAddressCountryValueChild, theValue)))) {
            allNames.add(country);
        }
        if (StringUtils.isNotBlank((CharSequence)(postalCode = BaseSearchParamExtractor.extractValueAsString(this.myAddressPostalCodeValueChild, theValue)))) {
            allNames.add(postalCode);
        }
        for (String nextName : allNames) {
            this.createStringIndexIfNotBlank(theResourceType, theParams, theSearchParam, nextName);
        }
    }

    <T> ISearchParamExtractor.SearchParamSet<T> extractSearchParams(IBaseResource theResource, IExtractor<T> theExtractor, RestSearchParameterTypeEnum theSearchParamType, boolean theWantLocalReferences, ISearchParamExtractor.ISearchParamFilter theSearchParamFilter) {
        ISearchParamExtractor.SearchParamSet retVal = new ISearchParamExtractor.SearchParamSet();
        Collection<RuntimeSearchParam> searchParams = this.getSearchParams(theResource);
        int preFilterSize = searchParams.size();
        Collection<RuntimeSearchParam> filteredSearchParams = theSearchParamFilter.filterSearchParams(searchParams);
        assert (filteredSearchParams.size() == preFilterSize || searchParams != filteredSearchParams);
        this.cleanUpContainedResourceReferences(theResource, theSearchParamType, filteredSearchParams);
        for (RuntimeSearchParam nextSpDef : filteredSearchParams) {
            if (nextSpDef.getParamType() != theSearchParamType || !this.myExtractResourceLevelParams && RuntimeSearchParamHelper.isResourceLevel(nextSpDef)) continue;
            this.extractSearchParam(nextSpDef, (IBase)theResource, theExtractor, retVal, theWantLocalReferences);
        }
        return retVal;
    }

    private boolean anySearchParameterUsesResolve(Collection<RuntimeSearchParam> searchParams, RestSearchParameterTypeEnum theSearchParamType) {
        return searchParams.stream().filter(param -> param.getParamType() != theSearchParamType).map(RuntimeSearchParam::getPath).filter(Objects::nonNull).anyMatch(path -> path.contains("resolve"));
    }

    private void cleanUpContainedResourceReferences(IBaseResource theResource, RestSearchParameterTypeEnum theSearchParamType, Collection<RuntimeSearchParam> searchParams) {
        boolean havePathWithResolveExpression;
        boolean bl = havePathWithResolveExpression = this.myStorageSettings.isIndexOnContainedResources() || this.anySearchParameterUsesResolve(searchParams, theSearchParamType);
        if (havePathWithResolveExpression && this.myContext.getParserOptions().isAutoContainReferenceTargetsWithNoId()) {
            this.myContext.newTerser().containResources(theResource, new FhirTerser.OptionsEnum[]{FhirTerser.OptionsEnum.MODIFY_RESOURCE, FhirTerser.OptionsEnum.STORE_AND_REUSE_RESULTS});
        }
    }

    @VisibleForTesting
    public <T> void extractSearchParam(RuntimeSearchParam theSearchParameterDef, IBase theResource, IExtractor<T> theExtractor, ISearchParamExtractor.SearchParamSet<T> theSetToPopulate, boolean theWantLocalReferences) {
        String nextPathUnsplit = theSearchParameterDef.getPath();
        this.extractSearchParam(theSearchParameterDef, nextPathUnsplit, theResource, theExtractor, theSetToPopulate, theWantLocalReferences);
    }

    private <T> void extractSearchParam(RuntimeSearchParam theSearchParameterDef, String thePathExpression, IBase theResource, IExtractor<T> theExtractor, ISearchParamExtractor.SearchParamSet<T> theSetToPopulate, boolean theWantLocalReferences) {
        String[] splitPaths;
        if (StringUtils.isBlank((CharSequence)thePathExpression)) {
            return;
        }
        for (String nextPath : splitPaths = this.split(thePathExpression)) {
            nextPath = StringUtils.trim((String)nextPath);
            for (IBase nextObject : this.extractValues(nextPath, theResource)) {
                String typeName;
                if (nextObject == null || this.myIgnoredForSearchDatatypes.contains(typeName = this.toRootTypeName(nextObject))) continue;
                theExtractor.extract(theSetToPopulate, theSearchParameterDef, nextObject, nextPath, theWantLocalReferences);
            }
        }
    }

    @Override
    public String toRootTypeName(IBase nextObject) {
        BaseRuntimeElementDefinition elementDefinition = this.getContext().getElementDefinition(nextObject.getClass());
        BaseRuntimeElementDefinition rootParentDefinition = elementDefinition.getRootParentDefinition();
        return rootParentDefinition.getName();
    }

    @Override
    public String toTypeName(IBase nextObject) {
        BaseRuntimeElementDefinition elementDefinition = this.getContext().getElementDefinition(nextObject.getClass());
        return elementDefinition.getName();
    }

    private void addUri_Uri(String theResourceType, Set<ResourceIndexedSearchParamUri> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
        IPrimitiveType value = (IPrimitiveType)theValue;
        String valueAsString = value.getValueAsString();
        if (StringUtils.isNotBlank((CharSequence)valueAsString)) {
            ResourceIndexedSearchParamUri nextEntity = new ResourceIndexedSearchParamUri(this.myPartitionSettings, theResourceType, theSearchParam.getName(), valueAsString);
            theParams.add(nextEntity);
        }
    }

    private void createStringIndexIfNotBlank(String theResourceType, Set<? extends BaseResourceIndexedSearchParam> theParams, RuntimeSearchParam theSearchParam, String theValue) {
        String value = theValue;
        if (StringUtils.isNotBlank((CharSequence)value)) {
            if (value.length() > 768) {
                value = value.substring(0, 768);
            }
            String searchParamName = theSearchParam.getName();
            String valueNormalized = StringUtil.normalizeStringForSearchIndexing((String)value);
            String valueEncoded = theSearchParam.encode(valueNormalized);
            if (valueEncoded.length() > 768) {
                valueEncoded = valueEncoded.substring(0, 768);
            }
            ResourceIndexedSearchParamString nextEntity = new ResourceIndexedSearchParamString(this.myPartitionSettings, this.getStorageSettings(), theResourceType, searchParamName, valueEncoded, value);
            Set<? extends BaseResourceIndexedSearchParam> params = theParams;
            params.add((BaseResourceIndexedSearchParam)nextEntity);
        }
    }

    private void createTokenIndexIfNotBlankAndAdd(String theResourceType, Set<BaseResourceIndexedSearchParam> theParams, RuntimeSearchParam theSearchParam, String theSystem, String theValue) {
        ResourceIndexedSearchParamToken nextEntity = this.createTokenIndexIfNotBlank(theResourceType, theSystem, theValue, theSearchParam.getName());
        if (nextEntity != null) {
            theParams.add((BaseResourceIndexedSearchParam)nextEntity);
        }
    }

    @VisibleForTesting
    public void setPartitionSettings(PartitionSettings thePartitionSettings) {
        this.myPartitionSettings = thePartitionSettings;
    }

    private ResourceIndexedSearchParamToken createTokenIndexIfNotBlank(String theResourceType, String theSystem, String theValue, String searchParamName) {
        ResourceIndexedSearchParamToken nextEntity = null;
        if (StringUtils.isNotBlank((CharSequence)theSystem) || StringUtils.isNotBlank((CharSequence)theValue)) {
            nextEntity = new ResourceIndexedSearchParamToken(this.myPartitionSettings, theResourceType, searchParamName, theSystem, theValue);
        }
        return nextEntity;
    }

    @Override
    public String[] split(String thePaths) {
        if (this.shouldAttemptToSplitPath(thePaths)) {
            return this.splitOutOfParensOrs(thePaths);
        }
        return new String[]{thePaths};
    }

    public boolean shouldAttemptToSplitPath(String thePath) {
        if (this.getContext().getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.R4)) {
            return thePath.contains("|");
        }
        return thePath.contains("|") || thePath.contains(" or ");
    }

    private String[] splitOutOfParensOrs(String thePaths) {
        List<String> topLevelOrExpressions = this.splitOutOfParensToken(thePaths, " or ");
        return (String[])topLevelOrExpressions.stream().flatMap(s -> this.splitOutOfParensToken((String)s, " |").stream()).toArray(String[]::new);
    }

    private List<String> splitOutOfParensToken(String thePath, String theToken) {
        int tokenLength = theToken.length();
        int index = thePath.indexOf(theToken);
        int rightIndex = 0;
        ArrayList<String> retVal = new ArrayList<String>();
        while (index > -1) {
            String left = thePath.substring(rightIndex, index);
            if (this.allParensHaveBeenClosed(left)) {
                retVal.add(left);
                rightIndex = index + tokenLength;
            }
            index = thePath.indexOf(theToken, index + tokenLength);
        }
        retVal.add(thePath.substring(rightIndex));
        return retVal;
    }

    private boolean allParensHaveBeenClosed(String thePaths) {
        int close;
        int open = StringUtils.countMatches((CharSequence)thePaths, (CharSequence)"(");
        return open == (close = StringUtils.countMatches((CharSequence)thePaths, (CharSequence)")"));
    }

    private BigDecimal normalizeQuantityContainingTimeUnitsIntoDaysForNumberParam(String theSystem, String theCode, BigDecimal theValue) {
        if ("http://unitsofmeasure.org".equals(theSystem) && StringUtils.isNotBlank((CharSequence)theCode)) {
            Unit unit = Unit.valueOf((CharSequence)theCode);
            UnitConverter dayConverter = unit.getConverterTo(NonSI.DAY);
            double dayValue = dayConverter.convert(theValue.doubleValue());
            theValue = new BigDecimal(dayValue);
        }
        return theValue;
    }

    @PostConstruct
    public void start() {
        this.myIgnoredForSearchDatatypes = new HashSet<String>();
        BaseSearchParamExtractor.addIgnoredType(this.getContext(), "Annotation", this.myIgnoredForSearchDatatypes);
        BaseSearchParamExtractor.addIgnoredType(this.getContext(), "Attachment", this.myIgnoredForSearchDatatypes);
        BaseSearchParamExtractor.addIgnoredType(this.getContext(), "Count", this.myIgnoredForSearchDatatypes);
        BaseSearchParamExtractor.addIgnoredType(this.getContext(), "Distance", this.myIgnoredForSearchDatatypes);
        BaseSearchParamExtractor.addIgnoredType(this.getContext(), "Ratio", this.myIgnoredForSearchDatatypes);
        BaseSearchParamExtractor.addIgnoredType(this.getContext(), "SampledData", this.myIgnoredForSearchDatatypes);
        BaseSearchParamExtractor.addIgnoredType(this.getContext(), "Signature", this.myIgnoredForSearchDatatypes);
        BaseRuntimeElementCompositeDefinition quantityDefinition = (BaseRuntimeElementCompositeDefinition)this.getContext().getElementDefinition("Quantity");
        this.myQuantityValueValueChild = quantityDefinition.getChildByName("value");
        this.myQuantitySystemValueChild = quantityDefinition.getChildByName("system");
        this.myQuantityCodeValueChild = quantityDefinition.getChildByName("code");
        BaseRuntimeElementCompositeDefinition moneyDefinition = (BaseRuntimeElementCompositeDefinition)this.getContext().getElementDefinition("Money");
        this.myMoneyValueChild = moneyDefinition.getChildByName("value");
        this.myMoneyCurrencyChild = moneyDefinition.getChildByName("currency");
        RuntimeResourceDefinition locationDefinition = this.getContext().getResourceDefinition("Location");
        BaseRuntimeChildDefinition locationPositionValueChild = locationDefinition.getChildByName("position");
        this.myLocationPositionDefinition = (BaseRuntimeElementCompositeDefinition)locationPositionValueChild.getChildByName("position");
        BaseRuntimeElementCompositeDefinition rangeDefinition = (BaseRuntimeElementCompositeDefinition)this.getContext().getElementDefinition("Range");
        this.myRangeLowValueChild = rangeDefinition.getChildByName("low");
        this.myRangeHighValueChild = rangeDefinition.getChildByName("high");
        BaseRuntimeElementCompositeDefinition addressDefinition = (BaseRuntimeElementCompositeDefinition)this.getContext().getElementDefinition("Address");
        this.myAddressLineValueChild = addressDefinition.getChildByName("line");
        this.myAddressCityValueChild = addressDefinition.getChildByName("city");
        this.myAddressDistrictValueChild = addressDefinition.getChildByName("district");
        this.myAddressStateValueChild = addressDefinition.getChildByName("state");
        this.myAddressCountryValueChild = addressDefinition.getChildByName("country");
        this.myAddressPostalCodeValueChild = addressDefinition.getChildByName("postalCode");
        BaseRuntimeElementCompositeDefinition periodDefinition = (BaseRuntimeElementCompositeDefinition)this.getContext().getElementDefinition("Period");
        this.myPeriodStartValueChild = periodDefinition.getChildByName("start");
        this.myPeriodEndValueChild = periodDefinition.getChildByName("end");
        BaseRuntimeElementCompositeDefinition timingDefinition = (BaseRuntimeElementCompositeDefinition)this.getContext().getElementDefinition("Timing");
        this.myTimingEventValueChild = timingDefinition.getChildByName("event");
        this.myTimingRepeatValueChild = timingDefinition.getChildByName("repeat");
        BaseRuntimeElementCompositeDefinition timingRepeatDefinition = (BaseRuntimeElementCompositeDefinition)this.myTimingRepeatValueChild.getChildByName("repeat");
        this.myTimingRepeatBoundsValueChild = timingRepeatDefinition.getChildByName("bounds[x]");
        BaseRuntimeElementCompositeDefinition durationDefinition = (BaseRuntimeElementCompositeDefinition)this.getContext().getElementDefinition("Duration");
        this.myDurationSystemValueChild = durationDefinition.getChildByName("system");
        this.myDurationCodeValueChild = durationDefinition.getChildByName("code");
        this.myDurationValueValueChild = durationDefinition.getChildByName("value");
        BaseRuntimeElementCompositeDefinition humanNameDefinition = (BaseRuntimeElementCompositeDefinition)this.getContext().getElementDefinition("HumanName");
        this.myHumanNameFamilyValueChild = humanNameDefinition.getChildByName("family");
        this.myHumanNameGivenValueChild = humanNameDefinition.getChildByName("given");
        this.myHumanNameTextValueChild = humanNameDefinition.getChildByName("text");
        this.myHumanNamePrefixValueChild = humanNameDefinition.getChildByName("prefix");
        this.myHumanNameSuffixValueChild = humanNameDefinition.getChildByName("suffix");
        BaseRuntimeElementCompositeDefinition contactPointDefinition = (BaseRuntimeElementCompositeDefinition)this.getContext().getElementDefinition("ContactPoint");
        this.myContactPointValueValueChild = contactPointDefinition.getChildByName("value");
        this.myContactPointSystemValueChild = contactPointDefinition.getChildByName("system");
        BaseRuntimeElementCompositeDefinition identifierDefinition = (BaseRuntimeElementCompositeDefinition)this.getContext().getElementDefinition("Identifier");
        this.myIdentifierSystemValueChild = identifierDefinition.getChildByName("system");
        this.myIdentifierValueValueChild = identifierDefinition.getChildByName("value");
        this.myIdentifierTypeValueChild = identifierDefinition.getChildByName("type");
        BaseRuntimeElementCompositeDefinition identifierTypeDefinition = (BaseRuntimeElementCompositeDefinition)this.myIdentifierTypeValueChild.getChildByName("type");
        this.myIdentifierTypeTextValueChild = identifierTypeDefinition.getChildByName("text");
        BaseRuntimeElementCompositeDefinition codeableConceptDefinition = (BaseRuntimeElementCompositeDefinition)this.getContext().getElementDefinition("CodeableConcept");
        this.myCodeableConceptCodingValueChild = codeableConceptDefinition.getChildByName("coding");
        this.myCodeableConceptTextValueChild = codeableConceptDefinition.getChildByName("text");
        BaseRuntimeElementCompositeDefinition codingDefinition = (BaseRuntimeElementCompositeDefinition)this.getContext().getElementDefinition("Coding");
        this.myCodingSystemValueChild = codingDefinition.getChildByName("system");
        this.myCodingCodeValueChild = codingDefinition.getChildByName("code");
        this.myCodingDisplayValueChild = codingDefinition.getChildByName("display");
        RuntimeResourceDefinition patientDefinition = this.getContext().getResourceDefinition("Patient");
        BaseRuntimeChildDefinition patientCommunicationValueChild = patientDefinition.getChildByName("communication");
        BaseRuntimeElementCompositeDefinition patientCommunicationDefinition = (BaseRuntimeElementCompositeDefinition)patientCommunicationValueChild.getChildByName("communication");
        this.myPatientCommunicationLanguageValueChild = patientCommunicationDefinition.getChildByName("language");
        if (this.getContext().getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.DSTU3)) {
            RuntimeResourceDefinition codeSystemDefinition = this.getContext().getResourceDefinition("CodeSystem");
            assert (codeSystemDefinition != null);
            this.myCodeSystemUrlValueChild = codeSystemDefinition.getChildByName("url");
            RuntimeResourceDefinition capabilityStatementDefinition = this.getContext().getResourceDefinition("CapabilityStatement");
            BaseRuntimeChildDefinition capabilityStatementRestChild = capabilityStatementDefinition.getChildByName("rest");
            BaseRuntimeElementCompositeDefinition capabilityStatementRestDefinition = (BaseRuntimeElementCompositeDefinition)capabilityStatementRestChild.getChildByName("rest");
            BaseRuntimeChildDefinition capabilityStatementRestSecurityValueChild = capabilityStatementRestDefinition.getChildByName("security");
            BaseRuntimeElementCompositeDefinition capabilityStatementRestSecurityDefinition = (BaseRuntimeElementCompositeDefinition)capabilityStatementRestSecurityValueChild.getChildByName("security");
            this.myCapabilityStatementRestSecurityServiceValueChild = capabilityStatementRestSecurityDefinition.getChildByName("service");
        }
        if (this.getContext().getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.R4B)) {
            BaseRuntimeElementCompositeDefinition codeableReferenceDef = (BaseRuntimeElementCompositeDefinition)this.getContext().getElementDefinition("CodeableReference");
            this.myCodeableReferenceConcept = codeableReferenceDef.getChildByName("concept");
            this.myCodeableReferenceReference = codeableReferenceDef.getChildByName("reference");
        }
    }

    @Nonnull
    public static String[] splitPathsR4(@Nonnull String thePaths) {
        StringTokenizer tok = new StringTokenizer(thePaths, " |");
        tok.setTrimmerMatcher((StringMatcher)new StringTrimmingTrimmerMatcher());
        return tok.getTokenArray();
    }

    public static boolean tokenTextIndexingEnabledForSearchParam(StorageSettings theStorageSettings, RuntimeSearchParam theSearchParam) {
        Optional<Boolean> noSuppressForSearchParam = theSearchParam.getExtensions("http://hapifhir.io/fhir/StructureDefinition/searchparameter-token-suppress-text-index").stream().map(IBaseExtension::getValue).map(val -> (IPrimitiveType)val).map(IPrimitiveType::getValueAsString).map(Boolean::parseBoolean).findFirst();
        if (noSuppressForSearchParam.isEmpty()) {
            return !theStorageSettings.isSuppressStringIndexingInTokens();
        }
        boolean suppressForSearchParam = noSuppressForSearchParam.get();
        ourLog.trace("Text indexing for SearchParameter {}: {}", (Object)theSearchParam.getName(), (Object)suppressForSearchParam);
        return !suppressForSearchParam;
    }

    private static void addIgnoredType(FhirContext theCtx, String theType, Set<String> theIgnoredTypes) {
        BaseRuntimeElementDefinition elementDefinition = theCtx.getElementDefinition(theType);
        if (elementDefinition != null) {
            theIgnoredTypes.add(elementDefinition.getName());
        }
    }

    protected static String extractValueAsString(BaseRuntimeChildDefinition theChildDefinition, IBase theElement) {
        return theChildDefinition.getAccessor().getFirstValueOrNull(theElement).map(IPrimitiveType::getValueAsString).orElse(null);
    }

    protected static Date extractValueAsDate(BaseRuntimeChildDefinition theChildDefinition, IBase theElement) {
        return theChildDefinition.getAccessor().getFirstValueOrNull(theElement).map(IPrimitiveType::getValue).orElse(null);
    }

    protected static BigDecimal extractValueAsBigDecimal(BaseRuntimeChildDefinition theChildDefinition, IBase theElement) {
        return theChildDefinition.getAccessor().getFirstValueOrNull(theElement).map(IPrimitiveType::getValue).orElse(null);
    }

    protected static List<IPrimitiveType<Date>> extractValuesAsFhirDates(BaseRuntimeChildDefinition theChildDefinition, IBase theElement) {
        return theChildDefinition.getAccessor().getValues(theElement);
    }

    protected static List<String> extractValuesAsStrings(BaseRuntimeChildDefinition theChildDefinition, IBase theValue) {
        return theChildDefinition.getAccessor().getValues(theValue).stream().map(t -> (IPrimitiveType)t).map(IPrimitiveType::getValueAsString).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    protected static <T extends Enum<?>> String extractSystem(IBaseEnumeration<T> theBoundCode) {
        if (theBoundCode.getValue() != null) {
            return theBoundCode.getEnumFactory().toSystem((Enum)theBoundCode.getValue());
        }
        return null;
    }

    public void setExtractResourceLevelParams(boolean theExtractResourceLevelParams) {
        this.myExtractResourceLevelParams = theExtractResourceLevelParams;
    }

    static {
        ourLog = LoggerFactory.getLogger(BaseSearchParamExtractor.class);
        HashSet coordsIndexPaths = Sets.newHashSet((Object[])new String[]{"Location.position"});
        COORDS_INDEX_PATHS = Collections.unmodifiableSet(coordsIndexPaths);
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface IExtractor<T> {
        public void extract(ISearchParamExtractor.SearchParamSet<T> var1, RuntimeSearchParam var2, IBase var3, String var4, boolean var5);
    }

    private class ResourceLinkExtractor
    implements IExtractor<PathAndRef> {
        private PathAndRef myPathAndRef = null;

        private ResourceLinkExtractor() {
        }

        @Override
        public void extract(ISearchParamExtractor.SearchParamSet<PathAndRef> theParams, RuntimeSearchParam theSearchParam, IBase theValue, String thePath, boolean theWantLocalReferences) {
            String nextType;
            if (theValue instanceof IBaseResource) {
                this.myPathAndRef = new PathAndRef(theSearchParam.getName(), thePath, (IBaseResource)theValue);
                theParams.add(this.myPathAndRef);
                return;
            }
            switch (nextType = BaseSearchParamExtractor.this.toRootTypeName(theValue)) {
                case "uri": 
                case "canonical": {
                    String typeName = BaseSearchParamExtractor.this.toTypeName(theValue);
                    IPrimitiveType valuePrimitive = (IPrimitiveType)theValue;
                    IBaseReference fakeReference = (IBaseReference)BaseSearchParamExtractor.this.myContext.getElementDefinition("Reference").newInstance();
                    fakeReference.setReference(valuePrimitive.getValueAsString());
                    if ("canonical".equals(typeName)) {
                        IIdType parsed = fakeReference.getReferenceElement();
                        if (parsed.hasIdPart() && parsed.hasResourceType() && !parsed.isAbsolute()) {
                            this.myPathAndRef = new PathAndRef(theSearchParam.getName(), thePath, fakeReference, false);
                            theParams.add(this.myPathAndRef);
                            break;
                        }
                        if (!parsed.isAbsolute()) break;
                        String refValue = fakeReference.getReferenceElement().getValue();
                        this.myPathAndRef = new PathAndRef(theSearchParam.getName(), thePath, fakeReference, true);
                        theParams.add(this.myPathAndRef);
                        if (refValue.contains("|")) {
                            fakeReference = (IBaseReference)BaseSearchParamExtractor.this.myContext.getElementDefinition("Reference").newInstance();
                            fakeReference.setReference(refValue.substring(0, refValue.indexOf(124)));
                        }
                        this.myPathAndRef = new PathAndRef(theSearchParam.getName(), thePath, fakeReference, true);
                        theParams.add(this.myPathAndRef);
                        break;
                    }
                    theParams.addWarning("Ignoring canonical reference (indexing canonical is not yet supported)");
                    break;
                }
                case "reference": 
                case "Reference": {
                    IBaseReference valueRef = (IBaseReference)theValue;
                    this.extractResourceLinkFromReference(theParams, theSearchParam, thePath, theWantLocalReferences, valueRef);
                    break;
                }
                case "CodeableReference": {
                    Optional referenceOpt = BaseSearchParamExtractor.this.myCodeableReferenceReference.getAccessor().getFirstValueOrNull(theValue);
                    if (!referenceOpt.isPresent()) break;
                    IBaseReference value = (IBaseReference)referenceOpt.get();
                    this.extractResourceLinkFromReference(theParams, theSearchParam, thePath, theWantLocalReferences, value);
                    break;
                }
                default: {
                    BaseSearchParamExtractor.this.addUnexpectedDatatypeWarning(theParams, theSearchParam, theValue, thePath);
                }
            }
        }

        private void extractResourceLinkFromReference(ISearchParamExtractor.SearchParamSet<PathAndRef> theParams, RuntimeSearchParam theSearchParam, String thePath, boolean theWantLocalReferences, IBaseReference valueRef) {
            IIdType nextId = valueRef.getReferenceElement();
            if (nextId.isEmpty() && valueRef.getResource() != null) {
                nextId = valueRef.getResource().getIdElement();
            }
            if (!(nextId == null || nextId.isEmpty() || !theWantLocalReferences && nextId.getValue().startsWith("#"))) {
                this.myPathAndRef = new PathAndRef(theSearchParam.getName(), thePath, valueRef, false);
                theParams.add(this.myPathAndRef);
            }
        }

        public PathAndRef get(IBase theValue, String thePath) {
            this.extract(new ISearchParamExtractor.SearchParamSet<PathAndRef>(), new RuntimeSearchParam(null, null, "Reference", null, null, null, null, null, null, null), theValue, thePath, false);
            return this.myPathAndRef;
        }
    }

    public class CompositeExtractor
    implements IExtractor<ResourceIndexedSearchParamComposite> {
        final IBaseResource myResource;
        final String myResourceType;

        public CompositeExtractor(IBaseResource theResource) {
            this.myResource = theResource;
            this.myResourceType = BaseSearchParamExtractor.this.toRootTypeName((IBase)theResource);
        }

        @Override
        public void extract(ISearchParamExtractor.SearchParamSet<ResourceIndexedSearchParamComposite> theParams, RuntimeSearchParam theCompositeSearchParam, IBase theValue, String thePath, boolean theWantLocalReferences) {
            if (!this.isExtractableComposite(theCompositeSearchParam)) {
                ourLog.info("CompositeExtractor - skipping unsupported search parameter {}", (Object)theCompositeSearchParam.getName());
                return;
            }
            String compositeSpName = theCompositeSearchParam.getName();
            ourLog.trace("CompositeExtractor - extracting {} {}", (Object)compositeSpName, (Object)theValue);
            ResourceIndexedSearchParamComposite e = new ResourceIndexedSearchParamComposite(compositeSpName, thePath);
            for (RuntimeSearchParam.Component component : theCompositeSearchParam.getComponents()) {
                String componentSpRef = component.getReference();
                String expression = component.getExpression();
                RuntimeSearchParam componentSp = BaseSearchParamExtractor.this.mySearchParamRegistry.getActiveSearchParamByUrl(componentSpRef);
                Validate.notNull((Object)componentSp, (String)"Misconfigured SP %s - failed to load component %s", (Object[])new Object[]{compositeSpName, componentSpRef});
                ISearchParamExtractor.SearchParamSet<BaseResourceIndexedSearchParam> componentIndexedSearchParams = this.extractCompositeComponentIndexData(theValue, componentSp, expression, theWantLocalReferences, theCompositeSearchParam);
                if (componentIndexedSearchParams.isEmpty()) {
                    return;
                }
                e.addComponentIndexedSearchParams(componentSp, componentIndexedSearchParams);
            }
            theParams.add(e);
        }

        @Nonnull
        private ISearchParamExtractor.SearchParamSet<BaseResourceIndexedSearchParam> extractCompositeComponentIndexData(IBase theFocusElement, RuntimeSearchParam theComponentSearchParam, String theSubPathExpression, boolean theWantLocalReferences, RuntimeSearchParam theCompositeSearchParam) {
            IExtractor componentExtractor = BaseSearchParamExtractor.this.createExtractor(theComponentSearchParam, this.myResource);
            ISearchParamExtractor.SearchParamSet<BaseResourceIndexedSearchParam> componentIndexData = new ISearchParamExtractor.SearchParamSet<BaseResourceIndexedSearchParam>();
            BaseSearchParamExtractor.this.extractSearchParam(theComponentSearchParam, theSubPathExpression, theFocusElement, componentExtractor, componentIndexData, theWantLocalReferences);
            ourLog.trace("CompositeExtractor - extracted {} index values for {}", (Object)componentIndexData.size(), (Object)theComponentSearchParam.getName());
            return componentIndexData;
        }

        private boolean isExtractableComposite(RuntimeSearchParam theSearchParam) {
            return RestSearchParameterTypeEnum.COMPOSITE.equals((Object)theSearchParam.getParamType()) && theSearchParam.getComponents().stream().noneMatch(this::isNotExtractableCompositeComponent);
        }

        private boolean isNotExtractableCompositeComponent(RuntimeSearchParam.Component c) {
            RuntimeSearchParam componentSearchParam = BaseSearchParamExtractor.this.mySearchParamRegistry.getActiveSearchParamByUrl(c.getReference());
            return componentSearchParam == null || RestSearchParameterTypeEnum.COMPOSITE.equals((Object)componentSearchParam.getParamType()) || c.getExpression() == null || c.getExpression().contains("%resource");
        }
    }

    private class TokenExtractor
    implements IExtractor<BaseResourceIndexedSearchParam> {
        private final String myResourceTypeName;
        private final String myUseSystem;

        public TokenExtractor(String theResourceTypeName, String theUseSystem) {
            this.myResourceTypeName = theResourceTypeName;
            this.myUseSystem = theUseSystem;
        }

        @Override
        public void extract(ISearchParamExtractor.SearchParamSet<BaseResourceIndexedSearchParam> params, RuntimeSearchParam searchParam, IBase value, String path, boolean theWantLocalReferences) {
            String nextType;
            if (value instanceof IBaseEnumeration) {
                IBaseEnumeration obj = (IBaseEnumeration)value;
                String system = BaseSearchParamExtractor.extractSystem(obj);
                String code = obj.getValueAsString();
                BaseSearchParamExtractor.this.createTokenIndexIfNotBlankAndAdd(this.myResourceTypeName, params, searchParam, system, code);
                return;
            }
            if (value instanceof BoundCodeDt) {
                BoundCodeDt boundCode = (BoundCodeDt)value;
                Enum valueAsEnum = boundCode.getValueAsEnum();
                String system = null;
                if (valueAsEnum != null) {
                    system = boundCode.getBinder().toSystemString(valueAsEnum);
                }
                String code = boundCode.getValueAsString();
                BaseSearchParamExtractor.this.createTokenIndexIfNotBlankAndAdd(this.myResourceTypeName, params, searchParam, system, code);
                return;
            }
            if (value instanceof IPrimitiveType) {
                IPrimitiveType nextValue = (IPrimitiveType)value;
                String systemAsString = null;
                String valueAsString = nextValue.getValueAsString();
                if ("CodeSystem.concept.code".equals(path)) {
                    systemAsString = this.myUseSystem;
                } else if ("ValueSet.codeSystem.concept.code".equals(path)) {
                    systemAsString = this.myUseSystem;
                }
                if (value instanceof IIdType) {
                    valueAsString = ((IIdType)value).getIdPart();
                }
                BaseSearchParamExtractor.this.createTokenIndexIfNotBlankAndAdd(this.myResourceTypeName, params, searchParam, systemAsString, valueAsString);
                return;
            }
            switch (path) {
                case "Patient.communication": {
                    BaseSearchParamExtractor.this.addToken_PatientCommunication(this.myResourceTypeName, params, searchParam, value);
                    return;
                }
                case "Consent.source": {
                    return;
                }
                case "Location.position": {
                    BaseSearchParamExtractor.this.addCoords_Position(this.myResourceTypeName, params, searchParam, value);
                    return;
                }
                case "StructureDefinition.context": {
                    ourLog.warn("StructureDefinition context indexing not currently supported");
                    return;
                }
                case "CapabilityStatement.rest.security": {
                    BaseSearchParamExtractor.this.addToken_CapabilityStatementRestSecurity(this.myResourceTypeName, params, searchParam, value);
                    return;
                }
            }
            switch (nextType = BaseSearchParamExtractor.this.toRootTypeName(value)) {
                case "Identifier": {
                    BaseSearchParamExtractor.this.addToken_Identifier(this.myResourceTypeName, params, searchParam, value);
                    break;
                }
                case "CodeableConcept": {
                    BaseSearchParamExtractor.this.addToken_CodeableConcept(this.myResourceTypeName, params, searchParam, value);
                    break;
                }
                case "CodeableReference": {
                    BaseSearchParamExtractor.this.addToken_CodeableReference(this.myResourceTypeName, params, searchParam, value);
                    break;
                }
                case "Coding": {
                    BaseSearchParamExtractor.this.addToken_Coding(this.myResourceTypeName, params, searchParam, value);
                    break;
                }
                case "ContactPoint": {
                    BaseSearchParamExtractor.this.addToken_ContactPoint(this.myResourceTypeName, params, searchParam, value);
                    break;
                }
                case "Range": {
                    break;
                }
                case "Quantity": {
                    break;
                }
                default: {
                    BaseSearchParamExtractor.this.addUnexpectedDatatypeWarning(params, searchParam, value, path);
                }
            }
        }
    }

    private class DateExtractor
    implements IExtractor<ResourceIndexedSearchParamDate> {
        final String myResourceType;
        ResourceIndexedSearchParamDate myIndexedSearchParamDate = null;

        public DateExtractor(IBaseResource theResource) {
            this(baseSearchParamExtractor.toRootTypeName((IBase)theResource));
        }

        public DateExtractor(String theResourceType) {
            this.myResourceType = theResourceType;
        }

        @Override
        public void extract(ISearchParamExtractor.SearchParamSet theParams, RuntimeSearchParam theSearchParam, IBase theValue, String thePath, boolean theWantLocalReferences) {
            String nextType;
            switch (nextType = BaseSearchParamExtractor.this.toRootTypeName(theValue)) {
                case "date": 
                case "dateTime": 
                case "instant": {
                    this.addDateTimeTypes(this.myResourceType, theParams, theSearchParam, theValue);
                    break;
                }
                case "Period": {
                    this.addDate_Period(this.myResourceType, theParams, theSearchParam, theValue);
                    break;
                }
                case "Timing": {
                    this.addDate_Timing(this.myResourceType, theParams, theSearchParam, theValue);
                    break;
                }
                case "string": {
                    break;
                }
                case "Quantity": {
                    break;
                }
                case "Range": {
                    break;
                }
                default: {
                    BaseSearchParamExtractor.this.addUnexpectedDatatypeWarning(theParams, theSearchParam, theValue, thePath);
                }
            }
        }

        private void addDate_Period(String theResourceType, Set<ResourceIndexedSearchParamDate> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
            Date start = BaseSearchParamExtractor.extractValueAsDate(BaseSearchParamExtractor.this.myPeriodStartValueChild, theValue);
            String startAsString = BaseSearchParamExtractor.extractValueAsString(BaseSearchParamExtractor.this.myPeriodStartValueChild, theValue);
            Date end = BaseSearchParamExtractor.extractValueAsDate(BaseSearchParamExtractor.this.myPeriodEndValueChild, theValue);
            String endAsString = BaseSearchParamExtractor.extractValueAsString(BaseSearchParamExtractor.this.myPeriodEndValueChild, theValue);
            if (start != null || end != null) {
                if (start == null) {
                    start = (Date)BaseSearchParamExtractor.this.myStorageSettings.getPeriodIndexStartOfTime().getValue();
                    startAsString = BaseSearchParamExtractor.this.myStorageSettings.getPeriodIndexStartOfTime().getValueAsString();
                }
                if (end == null) {
                    end = (Date)BaseSearchParamExtractor.this.myStorageSettings.getPeriodIndexEndOfTime().getValue();
                    endAsString = BaseSearchParamExtractor.this.myStorageSettings.getPeriodIndexEndOfTime().getValueAsString();
                }
                this.myIndexedSearchParamDate = new ResourceIndexedSearchParamDate(BaseSearchParamExtractor.this.myPartitionSettings, theResourceType, theSearchParam.getName(), start, startAsString, end, endAsString, startAsString);
                theParams.add(this.myIndexedSearchParamDate);
            }
        }

        private void addDate_Timing(String theResourceType, Set<ResourceIndexedSearchParamDate> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
            String boundsType;
            Optional bounds;
            List<IPrimitiveType<Date>> values = BaseSearchParamExtractor.extractValuesAsFhirDates(BaseSearchParamExtractor.this.myTimingEventValueChild, theValue);
            TreeSet<Date> dates = new TreeSet<Date>();
            String firstValue = null;
            String finalValue = null;
            for (IPrimitiveType<Date> nextEvent : values) {
                if (nextEvent.getValue() == null) continue;
                dates.add((Date)nextEvent.getValue());
                if (firstValue == null) {
                    firstValue = nextEvent.getValueAsString();
                }
                finalValue = nextEvent.getValueAsString();
            }
            Optional repeat = BaseSearchParamExtractor.this.myTimingRepeatValueChild.getAccessor().getFirstValueOrNull(theValue);
            if (repeat.isPresent() && (bounds = BaseSearchParamExtractor.this.myTimingRepeatBoundsValueChild.getAccessor().getFirstValueOrNull((IBase)repeat.get())).isPresent() && "Period".equals(boundsType = BaseSearchParamExtractor.this.toRootTypeName((IBase)bounds.get()))) {
                Date start = BaseSearchParamExtractor.extractValueAsDate(BaseSearchParamExtractor.this.myPeriodStartValueChild, (IBase)bounds.get());
                Date end = BaseSearchParamExtractor.extractValueAsDate(BaseSearchParamExtractor.this.myPeriodEndValueChild, (IBase)bounds.get());
                if (start != null) {
                    dates.add(start);
                }
                if (end != null) {
                    dates.add(end);
                }
            }
            if (!dates.isEmpty()) {
                this.myIndexedSearchParamDate = new ResourceIndexedSearchParamDate(BaseSearchParamExtractor.this.myPartitionSettings, theResourceType, theSearchParam.getName(), (Date)dates.first(), firstValue, (Date)dates.last(), finalValue, firstValue);
                theParams.add(this.myIndexedSearchParamDate);
            }
        }

        private void addDateTimeTypes(String theResourceType, Set<ResourceIndexedSearchParamDate> theParams, RuntimeSearchParam theSearchParam, IBase theValue) {
            IPrimitiveType nextBaseDateTime = (IPrimitiveType)theValue;
            if (nextBaseDateTime.getValue() != null) {
                this.myIndexedSearchParamDate = new ResourceIndexedSearchParamDate(BaseSearchParamExtractor.this.myPartitionSettings, theResourceType, theSearchParam.getName(), (Date)nextBaseDateTime.getValue(), nextBaseDateTime.getValueAsString(), (Date)nextBaseDateTime.getValue(), nextBaseDateTime.getValueAsString(), nextBaseDateTime.getValueAsString());
                ourLog.trace("DateExtractor - extracted {} for {}", (Object)nextBaseDateTime, (Object)theSearchParam.getName());
                theParams.add(this.myIndexedSearchParamDate);
            }
        }

        public ResourceIndexedSearchParamDate get(IBase theValue, String thePath, boolean theWantLocalReferences) {
            this.extract(new ISearchParamExtractor.SearchParamSet(), new RuntimeSearchParam(null, null, "date", null, null, null, null, null, null, null), theValue, thePath, theWantLocalReferences);
            return this.myIndexedSearchParamDate;
        }
    }

    private static class MultiplexExtractor<T>
    implements IExtractor<T> {
        private final IExtractor<T> myExtractor0;
        private final IExtractor<T> myExtractor1;

        private MultiplexExtractor(IExtractor<T> theExtractor0, IExtractor<T> theExtractor1) {
            this.myExtractor0 = theExtractor0;
            this.myExtractor1 = theExtractor1;
        }

        @Override
        public void extract(ISearchParamExtractor.SearchParamSet<T> theParams, RuntimeSearchParam theSearchParam, IBase theValue, String thePath, boolean theWantLocalReferences) {
            this.myExtractor0.extract(theParams, theSearchParam, theValue, thePath, theWantLocalReferences);
            this.myExtractor1.extract(theParams, theSearchParam, theValue, thePath, theWantLocalReferences);
        }
    }

    @FunctionalInterface
    public static interface IValueExtractor {
        public List<? extends IBase> get() throws FHIRException;
    }
}

