/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.extractor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.searchparam.extractor.BaseSearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.fhirpath.FHIRPathEngine;
import org.hl7.fhir.dstu3.hapi.ctx.HapiWorkerContext;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.instance.model.api.IBase;

public class SearchParamExtractorDstu3
extends BaseSearchParamExtractor
implements ISearchParamExtractor {
    private FHIRPathEngine myFhirPathEngine;

    public SearchParamExtractorDstu3() {
    }

    @VisibleForTesting
    public SearchParamExtractorDstu3(StorageSettings theStorageSettings, PartitionSettings thePartitionSettings, FhirContext theCtx, ISearchParamRegistry theSearchParamRegistry) {
        super(theStorageSettings, thePartitionSettings, theCtx, theSearchParamRegistry);
        this.initFhirPathEngine();
        this.start();
    }

    @Override
    public BaseSearchParamExtractor.IValueExtractor getPathValueExtractor(IBase theResource, String theSinglePath) {
        return () -> {
            ArrayList values = new ArrayList();
            List allValues = this.myFhirPathEngine.evaluate((Base)theResource, theSinglePath);
            if (!allValues.isEmpty()) {
                values.addAll(allValues);
            }
            return values;
        };
    }

    @Override
    @PostConstruct
    public void start() {
        super.start();
        if (this.myFhirPathEngine == null) {
            this.initFhirPathEngine();
        }
    }

    public void initFhirPathEngine() {
        HapiWorkerContext worker = new HapiWorkerContext(this.getContext(), this.getContext().getValidationSupport());
        this.myFhirPathEngine = new FHIRPathEngine((IWorkerContext)worker);
    }
}

