/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.extractor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.cross.IResourceLookup;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.BasePartitionable;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.IResourceIndexComboSearchParameter;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboStringUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboTokenNonUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceLink;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.SearchParamPresentEntity;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.model.search.StorageProcessingMessage;
import ca.uhn.fhir.jpa.searchparam.extractor.BaseSearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.CrossPartitionReferenceDetails;
import ca.uhn.fhir.jpa.searchparam.extractor.IResourceLinkResolver;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.LogicalReferenceHelper;
import ca.uhn.fhir.jpa.searchparam.extractor.PathAndRef;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParams;
import ca.uhn.fhir.jpa.searchparam.extractor.SearchParamExtractionUtil;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import ca.uhn.fhir.util.FhirTerser;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.IdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SearchParamExtractorService {
    private static final Logger ourLog = LoggerFactory.getLogger(SearchParamExtractorService.class);
    @Autowired
    private ISearchParamExtractor mySearchParamExtractor;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private StorageSettings myStorageSettings;
    @Autowired
    private FhirContext myContext;
    @Autowired
    private ISearchParamRegistry mySearchParamRegistry;
    @Autowired
    private PartitionSettings myPartitionSettings;
    @Autowired(required=false)
    private IResourceLinkResolver myResourceLinkResolver;
    private SearchParamExtractionUtil mySearchParamExtractionUtil;

    @VisibleForTesting
    public void setSearchParamExtractor(ISearchParamExtractor theSearchParamExtractor) {
        this.mySearchParamExtractor = theSearchParamExtractor;
    }

    public void extractFromResource(RequestPartitionId theRequestPartitionId, RequestDetails theRequestDetails, ResourceIndexedSearchParams theNewParams, ResourceIndexedSearchParams theExistingParams, ResourceTable theEntity, IBaseResource theResource, TransactionDetails theTransactionDetails, boolean theFailOnInvalidReference, @Nonnull ISearchParamExtractor.ISearchParamFilter theSearchParamFilter) {
        ResourceIndexedSearchParams containedParams;
        ResourceIndexedSearchParams normalParams = ResourceIndexedSearchParams.withSets();
        this.getExtractionUtil().extractSearchIndexParameters(theRequestDetails, normalParams, theResource, theSearchParamFilter);
        this.mergeParams(normalParams, theNewParams);
        boolean indexOnContainedResources = this.myStorageSettings.isIndexOnContainedResources();
        ISearchParamExtractor.SearchParamSet<PathAndRef> indexedReferences = this.mySearchParamExtractor.extractResourceLinks(theResource, indexOnContainedResources);
        SearchParamExtractorService.handleWarnings(theRequestDetails, this.myInterceptorBroadcaster, indexedReferences);
        if (indexOnContainedResources) {
            containedParams = ResourceIndexedSearchParams.withSets();
            this.extractSearchIndexParametersForContainedResources(theRequestDetails, containedParams, theResource, theEntity, indexedReferences);
            this.mergeParams(containedParams, theNewParams);
        }
        if (this.myStorageSettings.isIndexOnUpliftedRefchains()) {
            containedParams = ResourceIndexedSearchParams.withSets();
            this.extractSearchIndexParametersForUpliftedRefchains(theRequestDetails, containedParams, theEntity, theRequestPartitionId, theTransactionDetails, indexedReferences);
            this.mergeParams(containedParams, theNewParams);
        }
        this.populateResourceTables(theNewParams, theEntity);
        this.extractResourceLinks(theRequestPartitionId, theExistingParams, theNewParams, theEntity, theResource, theTransactionDetails, theFailOnInvalidReference, theRequestDetails, indexedReferences);
        if (indexOnContainedResources) {
            this.extractResourceLinksForContainedResources(theRequestPartitionId, theNewParams, theEntity, theResource, theTransactionDetails, theFailOnInvalidReference, theRequestDetails);
        }
        if (this.myStorageSettings.getIndexMissingFields() == StorageSettings.IndexEnabledEnum.ENABLED) {
            Map<String, Boolean> presenceMap = this.getReferenceSearchParamPresenceMap(theEntity, theNewParams);
            presenceMap.forEach((key, value) -> {
                SearchParamPresentEntity present = new SearchParamPresentEntity();
                present.setPartitionSettings(this.myPartitionSettings);
                present.setResource(theEntity);
                present.setParamName(key);
                present.setPresent(value.booleanValue());
                present.setPartitionId(theEntity.getPartitionId());
                present.calculateHashes();
                theNewParams.mySearchParamPresentEntities.add(present);
            });
            ResourceSearchParams activeSearchParams = this.mySearchParamRegistry.getActiveSearchParams(theEntity.getResourceType());
            theNewParams.findMissingSearchParams(this.myPartitionSettings, this.myStorageSettings, theEntity, activeSearchParams);
        }
        this.extractSearchParamComboUnique(theEntity, theNewParams);
        this.extractSearchParamComboNonUnique(theEntity, theNewParams);
        theNewParams.setUpdatedTime(theTransactionDetails.getTransactionDate());
    }

    private SearchParamExtractionUtil getExtractionUtil() {
        if (this.mySearchParamExtractionUtil == null) {
            this.mySearchParamExtractionUtil = new SearchParamExtractionUtil(this.myContext, this.myStorageSettings, this.mySearchParamExtractor, this.myInterceptorBroadcaster);
        }
        return this.mySearchParamExtractionUtil;
    }

    @Nonnull
    private Map<String, Boolean> getReferenceSearchParamPresenceMap(ResourceTable entity, ResourceIndexedSearchParams newParams) {
        HashMap<String, Boolean> retval = new HashMap<String, Boolean>();
        for (String nextKey : newParams.getPopulatedResourceLinkParameters()) {
            retval.put(nextKey, Boolean.TRUE);
        }
        ResourceSearchParams activeSearchParams = this.mySearchParamRegistry.getActiveSearchParams(entity.getResourceType());
        activeSearchParams.getReferenceSearchParamNames().forEach(key -> retval.putIfAbsent((String)key, Boolean.FALSE));
        return retval;
    }

    @VisibleForTesting
    public void setStorageSettings(StorageSettings theStorageSettings) {
        this.myStorageSettings = theStorageSettings;
    }

    private void extractSearchIndexParametersForContainedResources(RequestDetails theRequestDetails, ResourceIndexedSearchParams theParams, IBaseResource theResource, ResourceTable theEntity, ISearchParamExtractor.SearchParamSet<PathAndRef> theIndexedReferences) {
        FhirTerser terser = this.myContext.newTerser();
        final Collection containedResources = terser.getAllEmbeddedResources(theResource, false);
        IChainedSearchParameterExtractionStrategy strategy = new IChainedSearchParameterExtractionStrategy(){

            @Override
            @Nonnull
            public ISearchParamExtractor.ISearchParamFilter getSearchParamFilter(@Nonnull PathAndRef thePathAndRef) {
                return ISearchParamExtractor.ALL_PARAMS;
            }

            @Override
            public IBaseResource fetchResourceAtPath(@Nonnull PathAndRef thePathAndRef) {
                if (thePathAndRef.getRef() == null) {
                    return null;
                }
                return SearchParamExtractorService.this.findContainedResource(containedResources, thePathAndRef.getRef());
            }
        };
        boolean recurse = this.myStorageSettings.isIndexOnContainedResourcesRecursively();
        this.extractSearchIndexParametersForTargetResources(theRequestDetails, theParams, theEntity, new HashSet<IBaseResource>(), strategy, theIndexedReferences, recurse, true);
    }

    private void extractSearchIndexParametersForUpliftedRefchains(final RequestDetails theRequestDetails, ResourceIndexedSearchParams theParams, final ResourceTable theEntity, final RequestPartitionId theRequestPartitionId, final TransactionDetails theTransactionDetails, ISearchParamExtractor.SearchParamSet<PathAndRef> theIndexedReferences) {
        IChainedSearchParameterExtractionStrategy strategy = new IChainedSearchParameterExtractionStrategy(){

            @Override
            @Nonnull
            public ISearchParamExtractor.ISearchParamFilter getSearchParamFilter(@Nonnull PathAndRef thePathAndRef) {
                String searchParamName = thePathAndRef.getSearchParamName();
                RuntimeSearchParam searchParam = SearchParamExtractorService.this.mySearchParamRegistry.getActiveSearchParam(theEntity.getResourceType(), searchParamName);
                Set upliftRefchainCodes = searchParam.getUpliftRefchainCodes();
                if (upliftRefchainCodes.isEmpty()) {
                    return ISearchParamExtractor.NO_PARAMS;
                }
                return sp -> sp.stream().filter(t -> upliftRefchainCodes.contains(t.getName())).collect(Collectors.toList());
            }

            @Override
            public IBaseResource fetchResourceAtPath(@Nonnull PathAndRef thePathAndRef) {
                RequestPartitionId targetRequestPartitionId;
                if (thePathAndRef.getResource() != null) {
                    return thePathAndRef.getResource();
                }
                IIdType reference = thePathAndRef.getRef().getReferenceElement();
                IBaseResource resolvedResource = theTransactionDetails.getResolvedResource(reference);
                if (resolvedResource == null && SearchParamExtractorService.this.myResourceLinkResolver != null && !reference.getValue().startsWith("urn:uuid:") && (resolvedResource = SearchParamExtractorService.this.myResourceLinkResolver.loadTargetResource(targetRequestPartitionId = SearchParamExtractorService.this.determineResolverPartitionId(theRequestPartitionId), theEntity.getResourceType(), thePathAndRef, theRequestDetails, theTransactionDetails)) != null) {
                    ourLog.trace("Found target: {}", (Object)resolvedResource.getIdElement());
                    theTransactionDetails.addResolvedResource(thePathAndRef.getRef().getReferenceElement(), resolvedResource);
                }
                return resolvedResource;
            }
        };
        this.extractSearchIndexParametersForTargetResources(theRequestDetails, theParams, theEntity, new HashSet<IBaseResource>(), strategy, theIndexedReferences, false, false);
    }

    private void extractSearchIndexParametersForTargetResources(RequestDetails theRequestDetails, ResourceIndexedSearchParams theParams, ResourceTable theEntity, Collection<IBaseResource> theAlreadySeenResources, IChainedSearchParameterExtractionStrategy theTargetIndexingStrategy, ISearchParamExtractor.SearchParamSet<PathAndRef> theIndexedReferences, boolean theRecurse, boolean theIndexOnContainedResources) {
        for (PathAndRef nextPathAndRef : theIndexedReferences) {
            IBaseResource targetResource;
            ISearchParamExtractor.ISearchParamFilter searchParamsToIndex;
            String spnamePrefix = nextPathAndRef.getSearchParamName();
            if (spnamePrefix == null || nextPathAndRef.getRef() == null && nextPathAndRef.getResource() == null || (searchParamsToIndex = theTargetIndexingStrategy.getSearchParamFilter(nextPathAndRef)) == ISearchParamExtractor.NO_PARAMS || (targetResource = theTargetIndexingStrategy.fetchResourceAtPath(nextPathAndRef)) == null || theAlreadySeenResources.contains(targetResource)) continue;
            ResourceIndexedSearchParams currParams = ResourceIndexedSearchParams.withSets();
            this.getExtractionUtil().extractSearchIndexParameters(theRequestDetails, currParams, targetResource, searchParamsToIndex);
            if (theRecurse) {
                HashSet<IBaseResource> nextAlreadySeenResources = new HashSet<IBaseResource>(theAlreadySeenResources);
                nextAlreadySeenResources.add(targetResource);
                ISearchParamExtractor.SearchParamSet<PathAndRef> indexedReferences = this.mySearchParamExtractor.extractResourceLinks(targetResource, theIndexOnContainedResources);
                SearchParamExtractorService.handleWarnings(theRequestDetails, this.myInterceptorBroadcaster, indexedReferences);
                this.extractSearchIndexParametersForTargetResources(theRequestDetails, currParams, theEntity, nextAlreadySeenResources, theTargetIndexingStrategy, indexedReferences, true, theIndexOnContainedResources);
            }
            currParams.updateSpnamePrefixForIndexOnUpliftedChain(theEntity.getResourceType(), nextPathAndRef.getSearchParamName());
            this.mergeParams(currParams, theParams);
        }
    }

    private IBaseResource findContainedResource(Collection<IBaseResource> resources, IBaseReference reference) {
        for (IBaseResource resource : resources) {
            if (!resource.getIdElement().equals(reference.getReferenceElement())) continue;
            return resource;
        }
        return null;
    }

    private void mergeParams(ResourceIndexedSearchParams theSrcParams, ResourceIndexedSearchParams theTargetParams) {
        theTargetParams.myNumberParams.addAll(theSrcParams.myNumberParams);
        theTargetParams.myQuantityParams.addAll(theSrcParams.myQuantityParams);
        theTargetParams.myQuantityNormalizedParams.addAll(theSrcParams.myQuantityNormalizedParams);
        theTargetParams.myDateParams.addAll(theSrcParams.myDateParams);
        theTargetParams.myUriParams.addAll(theSrcParams.myUriParams);
        theTargetParams.myTokenParams.addAll(theSrcParams.myTokenParams);
        theTargetParams.myStringParams.addAll(theSrcParams.myStringParams);
        theTargetParams.myCoordsParams.addAll(theSrcParams.myCoordsParams);
        theTargetParams.myCompositeParams.addAll(theSrcParams.myCompositeParams);
    }

    private void populateResourceTables(ResourceIndexedSearchParams theParams, ResourceTable theEntity) {
        this.populateResourceTable(theParams.myNumberParams, theEntity);
        this.populateResourceTable(theParams.myQuantityParams, theEntity);
        this.populateResourceTable(theParams.myQuantityNormalizedParams, theEntity);
        this.populateResourceTable(theParams.myDateParams, theEntity);
        this.populateResourceTable(theParams.myUriParams, theEntity);
        this.populateResourceTable(theParams.myTokenParams, theEntity);
        this.populateResourceTable(theParams.myStringParams, theEntity);
        this.populateResourceTable(theParams.myCoordsParams, theEntity);
    }

    @VisibleForTesting
    public void setContext(FhirContext theContext) {
        this.myContext = theContext;
    }

    private void extractResourceLinks(RequestPartitionId theRequestPartitionId, ResourceIndexedSearchParams theParams, ResourceTable theEntity, IBaseResource theResource, TransactionDetails theTransactionDetails, boolean theFailOnInvalidReference, RequestDetails theRequest, ISearchParamExtractor.SearchParamSet<PathAndRef> theIndexedReferences) {
        this.extractResourceLinks(theRequestPartitionId, ResourceIndexedSearchParams.withSets(), theParams, theEntity, theResource, theTransactionDetails, theFailOnInvalidReference, theRequest, theIndexedReferences);
    }

    private void extractResourceLinks(RequestPartitionId theRequestPartitionId, ResourceIndexedSearchParams theExistingParams, ResourceIndexedSearchParams theNewParams, ResourceTable theEntity, IBaseResource theResource, TransactionDetails theTransactionDetails, boolean theFailOnInvalidReference, RequestDetails theRequest, ISearchParamExtractor.SearchParamSet<PathAndRef> theIndexedReferences) {
        String sourceResourceName = this.myContext.getResourceType(theResource);
        for (PathAndRef nextPathAndRef : theIndexedReferences) {
            if (nextPathAndRef.getRef() == null || nextPathAndRef.getRef().getReferenceElement().isLocal()) continue;
            RuntimeSearchParam searchParam = this.mySearchParamRegistry.getActiveSearchParam(sourceResourceName, nextPathAndRef.getSearchParamName());
            this.extractResourceLinks(theRequestPartitionId, theExistingParams, theNewParams, theEntity, theTransactionDetails, sourceResourceName, searchParam, nextPathAndRef, theFailOnInvalidReference, theRequest);
        }
        theEntity.setHasLinks(!theNewParams.myLinks.isEmpty());
    }

    private void extractResourceLinks(@Nonnull RequestPartitionId theRequestPartitionId, ResourceIndexedSearchParams theExistingParams, ResourceIndexedSearchParams theNewParams, ResourceTable theEntity, TransactionDetails theTransactionDetails, String theSourceResourceName, RuntimeSearchParam theRuntimeSearchParam, PathAndRef thePathAndRef, boolean theFailOnInvalidReference, RequestDetails theRequest) {
        ResourceLink resourceLink;
        RuntimeResourceDefinition resourceDefinition;
        String typeString;
        IBaseReference nextReference = thePathAndRef.getRef();
        IIdType nextId = nextReference.getReferenceElement();
        String path = thePathAndRef.getPath();
        Date transactionDate = theTransactionDetails.getTransactionDate();
        if (nextId.isEmpty() && nextReference.getResource() != null) {
            nextId = nextReference.getResource().getIdElement();
        }
        if (this.myContext.getParserOptions().isStripVersionsFromReferences() && !this.myContext.getParserOptions().getDontStripVersionsFromReferencesAtPaths().contains(thePathAndRef.getPath()) && nextId.hasVersionIdPart()) {
            nextId = nextId.toVersionless();
        }
        theNewParams.myPopulatedResourceLinkParameters.add(thePathAndRef.getSearchParamName());
        boolean canonical = thePathAndRef.isCanonical();
        if (LogicalReferenceHelper.isLogicalReference(this.myStorageSettings, nextId) || canonical) {
            String value = nextId.getValue();
            ResourceLink resourceLink2 = ResourceLink.forLogicalReference((String)thePathAndRef.getPath(), (ResourceTable)theEntity, (String)value, (Date)transactionDate);
            if (theNewParams.myLinks.add(resourceLink2)) {
                ourLog.debug("Indexing remote resource reference URL: {}", (Object)nextId);
            }
            return;
        }
        String baseUrl = nextId.getBaseUrl();
        int questionMarkIndex = nextId.getValue().indexOf(63);
        if (questionMarkIndex != -1) {
            IdType preQueryId = new IdType(nextId.getValue().substring(0, questionMarkIndex - 1));
            baseUrl = preQueryId.getBaseUrl();
        }
        if (StringUtils.isBlank((CharSequence)(typeString = nextId.getResourceType()))) {
            String msg = "Invalid resource reference found at path[" + path + "] - Does not contain resource type - " + nextId.getValue();
            if (theFailOnInvalidReference) {
                throw new InvalidRequestException(Msg.code((int)505) + msg);
            }
            ourLog.debug(msg);
            return;
        }
        try {
            resourceDefinition = this.myContext.getResourceDefinition(typeString);
        }
        catch (DataFormatException e) {
            String msg = "Invalid resource reference found at path[" + path + "] - Resource type is unknown or not supported on this server - " + nextId.getValue();
            if (theFailOnInvalidReference) {
                throw new InvalidRequestException(Msg.code((int)506) + msg);
            }
            ourLog.debug(msg);
            return;
        }
        if (theRuntimeSearchParam.hasTargets() && !theRuntimeSearchParam.getTargets().contains(typeString)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)baseUrl)) {
            if (!this.myStorageSettings.getTreatBaseUrlsAsLocal().contains(baseUrl) && !this.myStorageSettings.isAllowExternalReferences()) {
                String msg = this.myContext.getLocalizer().getMessage(BaseSearchParamExtractor.class, "externalReferenceNotAllowed", new Object[]{nextId.getValue()});
                throw new InvalidRequestException(Msg.code((int)507) + msg);
            }
            ResourceLink resourceLink3 = ResourceLink.forAbsoluteReference((String)thePathAndRef.getPath(), (ResourceTable)theEntity, (IIdType)nextId, (Date)transactionDate);
            if (theNewParams.myLinks.add(resourceLink3)) {
                ourLog.debug("Indexing remote resource reference URL: {}", (Object)nextId);
            }
            return;
        }
        Class type = resourceDefinition.getImplementingClass();
        String targetId = nextId.getIdPart();
        if (StringUtils.isBlank((CharSequence)targetId)) {
            String msg = "Invalid resource reference found at path[" + path + "] - Does not contain resource ID - " + nextId.getValue();
            if (theFailOnInvalidReference) {
                throw new InvalidRequestException(Msg.code((int)508) + msg);
            }
            ourLog.debug(msg);
            return;
        }
        IIdType referenceElement = thePathAndRef.getRef().getReferenceElement();
        JpaPid resolvedTargetId = (JpaPid)theTransactionDetails.getResolvedResourceId(referenceElement);
        Long targetVersionId = nextId.getVersionIdPartAsLong();
        if (resolvedTargetId != null) {
            this.myResourceLinkResolver.validateTypeOrThrowException(type);
            ResourceLink.ResourceLinkForLocalReferenceParams params = ResourceLink.ResourceLinkForLocalReferenceParams.instance().setSourcePath(thePathAndRef.getPath()).setSourceResource(theEntity).setTargetResourceType(typeString).setTargetResourcePid(resolvedTargetId.getId()).setTargetResourceId(targetId).setUpdated(transactionDate).setTargetResourceVersion(targetVersionId).setTargetResourcePartitionablePartitionId(resolvedTargetId.getPartitionablePartitionId());
            resourceLink = ResourceLink.forLocalReference((ResourceLink.ResourceLinkForLocalReferenceParams)params);
        } else if (theFailOnInvalidReference) {
            this.myResourceLinkResolver.validateTypeOrThrowException(type);
            Optional<ResourceLink> optionalResourceLink = this.findMatchingResourceLink(thePathAndRef, theExistingParams.getResourceLinks());
            resourceLink = optionalResourceLink.isPresent() ? optionalResourceLink.get() : this.resolveTargetAndCreateResourceLinkOrReturnNull(theRequestPartitionId, theSourceResourceName, thePathAndRef, theEntity, transactionDate, nextId, theRequest, theTransactionDetails);
            if (resourceLink == null) {
                return;
            }
            JpaPid persistentId = JpaPid.fromId((Long)resourceLink.getTargetResourcePid());
            persistentId.setPartitionablePartitionId(resourceLink.getTargetResourcePartitionId());
            theTransactionDetails.addResolvedResourceId(referenceElement, (IResourcePersistentId)persistentId);
        } else {
            ResourceLink.ResourceLinkForLocalReferenceParams params = ResourceLink.ResourceLinkForLocalReferenceParams.instance().setSourcePath(thePathAndRef.getPath()).setSourceResource(theEntity).setTargetResourceType(typeString).setTargetResourceId(targetId).setUpdated(transactionDate).setTargetResourceVersion(targetVersionId);
            resourceLink = ResourceLink.forLocalReference((ResourceLink.ResourceLinkForLocalReferenceParams)params);
        }
        theNewParams.myLinks.add(resourceLink);
    }

    private Optional<ResourceLink> findMatchingResourceLink(PathAndRef thePathAndRef, Collection<ResourceLink> theResourceLinks) {
        IIdType referenceElement = thePathAndRef.getRef().getReferenceElement();
        ArrayList<ResourceLink> resourceLinks = new ArrayList<ResourceLink>(theResourceLinks);
        for (ResourceLink resourceLink : resourceLinks) {
            boolean hasMatchingResourceVersion;
            boolean hasMatchingSearchParamPath = StringUtils.equals((CharSequence)resourceLink.getSourcePath(), (CharSequence)thePathAndRef.getPath());
            boolean hasMatchingResourceType = StringUtils.equals((CharSequence)resourceLink.getTargetResourceType(), (CharSequence)referenceElement.getResourceType());
            boolean hasMatchingResourceId = StringUtils.equals((CharSequence)resourceLink.getTargetResourceId(), (CharSequence)referenceElement.getIdPart());
            boolean bl = hasMatchingResourceVersion = this.myContext.getParserOptions().isStripVersionsFromReferences() || referenceElement.getVersionIdPartAsLong() == null || referenceElement.getVersionIdPartAsLong().equals(resourceLink.getTargetResourceVersion());
            if (!hasMatchingSearchParamPath || !hasMatchingResourceType || !hasMatchingResourceId || !hasMatchingResourceVersion) continue;
            return Optional.of(resourceLink);
        }
        return Optional.empty();
    }

    private void extractResourceLinksForContainedResources(RequestPartitionId theRequestPartitionId, ResourceIndexedSearchParams theParams, ResourceTable theEntity, IBaseResource theResource, TransactionDetails theTransactionDetails, boolean theFailOnInvalidReference, RequestDetails theRequest) {
        FhirTerser terser = this.myContext.newTerser();
        Collection containedResources = terser.getAllEmbeddedResources(theResource, false);
        this.extractResourceLinksForContainedResources(theRequestPartitionId, theParams, theEntity, theResource, theTransactionDetails, theFailOnInvalidReference, theRequest, containedResources, new HashSet<IBaseResource>());
    }

    private void extractResourceLinksForContainedResources(RequestPartitionId theRequestPartitionId, ResourceIndexedSearchParams theParams, ResourceTable theEntity, IBaseResource theResource, TransactionDetails theTransactionDetails, boolean theFailOnInvalidReference, RequestDetails theRequest, Collection<IBaseResource> theContainedResources, Collection<IBaseResource> theAlreadySeenResources) {
        ISearchParamExtractor.SearchParamSet<PathAndRef> referencedSearchParamSet = this.mySearchParamExtractor.extractResourceLinks(theResource, true);
        for (PathAndRef nextPathAndRef : referencedSearchParamSet) {
            IBaseResource containedResource;
            String spNamePrefix = nextPathAndRef.getSearchParamName();
            if (spNamePrefix == null || nextPathAndRef.getRef() == null || (containedResource = this.findContainedResource(theContainedResources, nextPathAndRef.getRef())) == null || theAlreadySeenResources.contains(containedResource)) continue;
            ResourceIndexedSearchParams currParams = ResourceIndexedSearchParams.withSets();
            ISearchParamExtractor.SearchParamSet<PathAndRef> indexedReferences = this.mySearchParamExtractor.extractResourceLinks(containedResource, true);
            this.extractResourceLinks(theRequestPartitionId, currParams, theEntity, containedResource, theTransactionDetails, theFailOnInvalidReference, theRequest, indexedReferences);
            if (this.myStorageSettings.isIndexOnContainedResourcesRecursively()) {
                HashSet<IBaseResource> nextAlreadySeenResources = new HashSet<IBaseResource>(theAlreadySeenResources);
                nextAlreadySeenResources.add(containedResource);
                this.extractResourceLinksForContainedResources(theRequestPartitionId, currParams, theEntity, containedResource, theTransactionDetails, theFailOnInvalidReference, theRequest, theContainedResources, nextAlreadySeenResources);
            }
            currParams.updateSpnamePrefixForLinksOnContainedResource(nextPathAndRef.getPath());
            theParams.getResourceLinks().addAll(currParams.getResourceLinks());
        }
    }

    private ResourceLink resolveTargetAndCreateResourceLinkOrReturnNull(@Nonnull RequestPartitionId theRequestPartitionId, String theSourceResourceName, PathAndRef thePathAndRef, ResourceTable theEntity, Date theUpdateTime, IIdType theNextId, RequestDetails theRequest, TransactionDetails theTransactionDetails) {
        IResourceLookup targetResource;
        JpaPid resolvedResourceId = (JpaPid)theTransactionDetails.getResolvedResourceId(theNextId);
        if (resolvedResourceId != null) {
            String targetResourceType = theNextId.getResourceType();
            Long targetResourcePid = resolvedResourceId.getId();
            String targetResourceIdPart = theNextId.getIdPart();
            Long targetVersion = theNextId.getVersionIdPartAsLong();
            ResourceLink.ResourceLinkForLocalReferenceParams params = ResourceLink.ResourceLinkForLocalReferenceParams.instance().setSourcePath(thePathAndRef.getPath()).setSourceResource(theEntity).setTargetResourceType(targetResourceType).setTargetResourcePid(targetResourcePid).setTargetResourceId(targetResourceIdPart).setUpdated(theUpdateTime).setTargetResourceVersion(targetVersion).setTargetResourcePartitionablePartitionId(resolvedResourceId.getPartitionablePartitionId());
            return ResourceLink.forLocalReference((ResourceLink.ResourceLinkForLocalReferenceParams)params);
        }
        if (this.myPartitionSettings.isPartitioningEnabled()) {
            if (this.myPartitionSettings.getAllowReferencesAcrossPartitions() == PartitionSettings.CrossPartitionReferenceMode.ALLOWED_UNQUALIFIED) {
                if (CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.JPA_RESOLVE_CROSS_PARTITION_REFERENCE, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest)) {
                    CrossPartitionReferenceDetails referenceDetails = new CrossPartitionReferenceDetails(theRequestPartitionId, theSourceResourceName, thePathAndRef, theRequest, theTransactionDetails);
                    HookParams params = new HookParams(new Object[]{referenceDetails});
                    targetResource = (IResourceLookup)CompositeInterceptorBroadcaster.doCallHooksAndReturnObject((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.JPA_RESOLVE_CROSS_PARTITION_REFERENCE, (HookParams)params);
                } else {
                    targetResource = this.myResourceLinkResolver.findTargetResource(RequestPartitionId.allPartitions(), theSourceResourceName, thePathAndRef, theRequest, theTransactionDetails);
                }
            } else {
                targetResource = this.myResourceLinkResolver.findTargetResource(theRequestPartitionId, theSourceResourceName, thePathAndRef, theRequest, theTransactionDetails);
            }
        } else {
            targetResource = this.myResourceLinkResolver.findTargetResource(theRequestPartitionId, theSourceResourceName, thePathAndRef, theRequest, theTransactionDetails);
        }
        if (targetResource == null) {
            return null;
        }
        String targetResourceType = targetResource.getResourceType();
        Long targetResourcePid = ((JpaPid)targetResource.getPersistentId()).getId();
        String targetResourceIdPart = theNextId.getIdPart();
        Long targetVersion = theNextId.getVersionIdPartAsLong();
        ResourceLink.ResourceLinkForLocalReferenceParams params = ResourceLink.ResourceLinkForLocalReferenceParams.instance().setSourcePath(thePathAndRef.getPath()).setSourceResource(theEntity).setTargetResourceType(targetResourceType).setTargetResourcePid(targetResourcePid).setTargetResourceId(targetResourceIdPart).setUpdated(theUpdateTime).setTargetResourceVersion(targetVersion).setTargetResourcePartitionablePartitionId(((JpaPid)targetResource.getPersistentId()).getPartitionablePartitionId());
        return ResourceLink.forLocalReference((ResourceLink.ResourceLinkForLocalReferenceParams)params);
    }

    private RequestPartitionId determineResolverPartitionId(@Nonnull RequestPartitionId theRequestPartitionId) {
        RequestPartitionId targetRequestPartitionId = theRequestPartitionId;
        if (this.myPartitionSettings.isPartitioningEnabled() && this.myPartitionSettings.getAllowReferencesAcrossPartitions() == PartitionSettings.CrossPartitionReferenceMode.ALLOWED_UNQUALIFIED) {
            targetRequestPartitionId = RequestPartitionId.allPartitions();
        }
        return targetRequestPartitionId;
    }

    private void populateResourceTable(Collection<? extends BaseResourceIndexedSearchParam> theParams, ResourceTable theResourceTable) {
        for (BaseResourceIndexedSearchParam baseResourceIndexedSearchParam : theParams) {
            if (baseResourceIndexedSearchParam.getResourcePid() != null) continue;
            baseResourceIndexedSearchParam.setResource(theResourceTable);
        }
    }

    private void populateResourceTableForComboParams(Collection<? extends IResourceIndexComboSearchParameter> theParams, ResourceTable theResourceTable) {
        for (IResourceIndexComboSearchParameter iResourceIndexComboSearchParameter : theParams) {
            if (iResourceIndexComboSearchParameter.getResource() != null) continue;
            iResourceIndexComboSearchParameter.setResource(theResourceTable);
            if (!(iResourceIndexComboSearchParameter instanceof BasePartitionable)) continue;
            ((BasePartitionable)iResourceIndexComboSearchParameter).setPartitionId(theResourceTable.getPartitionId());
        }
    }

    @VisibleForTesting
    void setInterceptorBroadcasterForUnitTest(IInterceptorBroadcaster theInterceptorBroadcaster) {
        this.myInterceptorBroadcaster = theInterceptorBroadcaster;
    }

    @Nonnull
    public List<String> extractParamValuesAsStrings(RuntimeSearchParam theActiveSearchParam, IBaseResource theResource) {
        return this.mySearchParamExtractor.extractParamValuesAsStrings(theActiveSearchParam, theResource);
    }

    public void extractSearchParamComboUnique(ResourceTable theEntity, ResourceIndexedSearchParams theParams) {
        String resourceType = theEntity.getResourceType();
        ISearchParamExtractor.SearchParamSet<ResourceIndexedComboStringUnique> comboUniques = this.mySearchParamExtractor.extractSearchParamComboUnique(resourceType, theParams);
        theParams.myComboStringUniques.addAll(comboUniques);
        this.populateResourceTableForComboParams(theParams.myComboStringUniques, theEntity);
    }

    public void extractSearchParamComboNonUnique(ResourceTable theEntity, ResourceIndexedSearchParams theParams) {
        String resourceType = theEntity.getResourceType();
        ISearchParamExtractor.SearchParamSet<ResourceIndexedComboTokenNonUnique> comboNonUniques = this.mySearchParamExtractor.extractSearchParamComboNonUnique(resourceType, theParams);
        theParams.myComboTokenNonUnique.addAll(comboNonUniques);
        this.populateResourceTableForComboParams(theParams.myComboTokenNonUnique, theEntity);
    }

    static void handleWarnings(RequestDetails theRequestDetails, IInterceptorBroadcaster theInterceptorBroadcaster, ISearchParamExtractor.SearchParamSet<?> theSearchParamSet) {
        if (theSearchParamSet.getWarnings().isEmpty()) {
            return;
        }
        if (CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.JPA_PERFTRACE_WARNING, (IInterceptorBroadcaster)theInterceptorBroadcaster, (RequestDetails)theRequestDetails)) {
            for (String next : theSearchParamSet.getWarnings()) {
                StorageProcessingMessage messageHolder = new StorageProcessingMessage();
                messageHolder.setMessage(next);
                HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(StorageProcessingMessage.class, (Object)messageHolder);
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)theInterceptorBroadcaster, (RequestDetails)theRequestDetails, (Pointcut)Pointcut.JPA_PERFTRACE_WARNING, (HookParams)params);
            }
        }
    }

    private static interface IChainedSearchParameterExtractionStrategy {
        @Nonnull
        public ISearchParamExtractor.ISearchParamFilter getSearchParamFilter(@Nonnull PathAndRef var1);

        @Nullable
        public IBaseResource fetchResourceAtPath(@Nonnull PathAndRef var1);
    }
}

