/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.matcher;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamToken;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParams;
import ca.uhn.fhir.jpa.searchparam.extractor.SearchParamExtractorService;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.searchparam.matcher.IndexedSearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.util.SourceParam;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.BaseParamWithPrefix;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.TokenParamModifier;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.MetaUtil;
import ca.uhn.fhir.util.UrlUtil;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class InMemoryResourceMatcher {
    public static final Set<String> UNSUPPORTED_PARAMETER_NAMES = Sets.newHashSet((Object[])new String[]{"_has"});
    private static final Logger ourLog = LoggerFactory.getLogger(InMemoryResourceMatcher.class);
    @Autowired
    ApplicationContext myApplicationContext;
    @Autowired
    ISearchParamRegistry mySearchParamRegistry;
    @Autowired
    StorageSettings myStorageSettings;
    @Autowired
    FhirContext myFhirContext;
    @Autowired
    SearchParamExtractorService mySearchParamExtractorService;
    @Autowired
    IndexedSearchParamExtractor myIndexedSearchParamExtractor;
    @Autowired
    private MatchUrlService myMatchUrlService;
    private ValidationSupportInitializationState validationSupportState = ValidationSupportInitializationState.NOT_INITIALIZED;
    private IValidationSupport myValidationSupport = null;

    private IValidationSupport getValidationSupportOrNull() {
        if (this.validationSupportState == ValidationSupportInitializationState.NOT_INITIALIZED) {
            try {
                this.myValidationSupport = (IValidationSupport)this.myApplicationContext.getBean(IValidationSupport.class);
                this.validationSupportState = ValidationSupportInitializationState.INITIALIZED;
            }
            catch (ConfigurationException | BeansException ignore) {
                ourLog.warn(Msg.code((int)2100) + "No bean satisfying IValidationSupport could be initialized. Qualifiers dependent on IValidationSupport will not be supported.");
                this.validationSupportState = ValidationSupportInitializationState.FAILED;
            }
        }
        return this.myValidationSupport;
    }

    @Deprecated
    public InMemoryMatchResult match(String theCriteria, IBaseResource theResource, @Nullable ResourceIndexedSearchParams theIndexedSearchParams) {
        return this.match(theCriteria, theResource, theIndexedSearchParams, null);
    }

    public InMemoryMatchResult match(String theCriteria, IBaseResource theResource, @Nullable ResourceIndexedSearchParams theIndexedSearchParams, RequestDetails theRequestDetails) {
        SearchParameterMap searchParameterMap;
        RuntimeResourceDefinition resourceDefinition;
        if (theResource == null) {
            Validate.isTrue((!theCriteria.startsWith("?") ? 1 : 0) != 0, (String)"Invalid match URL format (must match \"[resourceType]?[params]\")", (Object[])new Object[0]);
            Validate.isTrue((boolean)theCriteria.contains("?"), (String)"Invalid match URL format (must match \"[resourceType]?[params]\")", (Object[])new Object[0]);
            resourceDefinition = UrlUtil.parseUrlResourceType((FhirContext)this.myFhirContext, (String)theCriteria);
        } else {
            resourceDefinition = this.myFhirContext.getResourceDefinition(theResource);
        }
        try {
            searchParameterMap = this.myMatchUrlService.translateMatchUrl(theCriteria, resourceDefinition, new MatchUrlService.Flag[0]);
        }
        catch (UnsupportedOperationException e) {
            return InMemoryMatchResult.unsupportedFromReason("Failed to translate parse query string");
        }
        searchParameterMap.clean();
        ResourceIndexedSearchParams relevantSearchParams = null;
        if (theIndexedSearchParams != null) {
            relevantSearchParams = theIndexedSearchParams;
        } else if (theResource != null) {
            ISearchParamExtractor.ISearchParamFilter filter = theSearchParams -> theSearchParams.stream().filter(t -> searchParameterMap.containsKey(t.getName())).collect(Collectors.toList());
            relevantSearchParams = this.myIndexedSearchParamExtractor.extractIndexedSearchParams(theResource, theRequestDetails, filter);
        }
        return this.match(searchParameterMap, theResource, resourceDefinition, relevantSearchParams);
    }

    public InMemoryMatchResult canBeEvaluatedInMemory(String theCriteria) {
        return this.match(theCriteria, null, null, null);
    }

    public InMemoryMatchResult canBeEvaluatedInMemory(SearchParameterMap theSearchParameterMap, RuntimeResourceDefinition theResourceDefinition) {
        return this.match(theSearchParameterMap, null, theResourceDefinition, null);
    }

    @Nonnull
    public InMemoryMatchResult match(SearchParameterMap theSearchParameterMap, IBaseResource theResource, RuntimeResourceDefinition theResourceDefinition, ResourceIndexedSearchParams theSearchParams) {
        if (theSearchParameterMap.getLastUpdated() != null) {
            return InMemoryMatchResult.unsupportedFromParameterAndReason("_lastUpdated", "Standard parameters not supported");
        }
        if (theSearchParameterMap.containsKey("near")) {
            return InMemoryMatchResult.unsupportedFromReason("Location.position near not supported");
        }
        for (Map.Entry<String, List<List<IQueryParameterType>>> entry : theSearchParameterMap.entrySet()) {
            List<List<IQueryParameterType>> theAndOrParams;
            String theParamName = entry.getKey();
            InMemoryMatchResult result = this.matchIdsWithAndOr(theParamName, theAndOrParams = entry.getValue(), theResourceDefinition, theResource, theSearchParams);
            if (result.matched()) continue;
            return result;
        }
        return InMemoryMatchResult.successfulMatch();
    }

    private InMemoryMatchResult matchIdsWithAndOr(String theParamName, List<List<IQueryParameterType>> theAndOrParams, RuntimeResourceDefinition theResourceDefinition, IBaseResource theResource, ResourceIndexedSearchParams theSearchParams) {
        if (theAndOrParams.isEmpty()) {
            return InMemoryMatchResult.successfulMatch();
        }
        String resourceName = theResourceDefinition.getName();
        RuntimeSearchParam paramDef = this.mySearchParamRegistry.getActiveSearchParam(resourceName, theParamName);
        InMemoryMatchResult checkUnsupportedResult = this.checkForUnsupportedParameters(theParamName, paramDef, theAndOrParams);
        if (!checkUnsupportedResult.supported()) {
            return checkUnsupportedResult;
        }
        switch (theParamName) {
            case "_id": {
                return InMemoryMatchResult.fromBoolean(this.matchIdsAndOr(theAndOrParams, theResource));
            }
            case "_source": {
                return InMemoryMatchResult.fromBoolean(this.matchSourcesAndOr(theAndOrParams, theResource));
            }
            case "_tag": {
                return InMemoryMatchResult.fromBoolean(this.matchTagsOrSecurityAndOr(theAndOrParams, theResource, true));
            }
            case "_security": {
                return InMemoryMatchResult.fromBoolean(this.matchTagsOrSecurityAndOr(theAndOrParams, theResource, false));
            }
            case "_profile": {
                return InMemoryMatchResult.fromBoolean(this.matchProfilesAndOr(theAndOrParams, theResource));
            }
        }
        return this.matchResourceParam(this.myStorageSettings, theParamName, theAndOrParams, theSearchParams, resourceName, paramDef);
    }

    private InMemoryMatchResult checkForUnsupportedParameters(String theParamName, RuntimeSearchParam theParamDef, List<List<IQueryParameterType>> theAndOrParams) {
        if (UNSUPPORTED_PARAMETER_NAMES.contains(theParamName)) {
            return InMemoryMatchResult.unsupportedFromParameterAndReason(theParamName, "Parameter not supported");
        }
        for (List<IQueryParameterType> orParams : theAndOrParams) {
            InMemoryMatchResult checkUnsupportedResult;
            if (orParams.size() <= 0 || (checkUnsupportedResult = this.checkOneParameterForUnsupportedModifiers(theParamName, theParamDef, orParams.get(0))).supported()) continue;
            return checkUnsupportedResult;
        }
        return InMemoryMatchResult.successfulMatch();
    }

    private InMemoryMatchResult checkOneParameterForUnsupportedModifiers(String theParamName, RuntimeSearchParam theParamDef, IQueryParameterType theParam) {
        InMemoryMatchResult checkUnsupportedResult = InMemoryMatchResult.successfulMatch();
        if (this.hasChain(theParam)) {
            checkUnsupportedResult = InMemoryMatchResult.unsupportedFromParameterAndReason(theParamName + "." + ((ReferenceParam)theParam).getChain(), "Chained parameters are not supported");
        }
        if (checkUnsupportedResult.supported()) {
            checkUnsupportedResult = this.checkUnsupportedQualifiers(theParamName, theParamDef, theParam);
        }
        if (checkUnsupportedResult.supported()) {
            checkUnsupportedResult = this.checkUnsupportedPrefixes(theParamName, theParamDef, theParam);
        }
        return checkUnsupportedResult;
    }

    private boolean matchProfilesAndOr(List<List<IQueryParameterType>> theAndOrParams, IBaseResource theResource) {
        if (theResource == null) {
            return true;
        }
        return theAndOrParams.stream().allMatch(nextAnd -> this.matchProfilesOr((List<IQueryParameterType>)nextAnd, theResource));
    }

    private boolean matchProfilesOr(List<IQueryParameterType> theOrParams, IBaseResource theResource) {
        return theOrParams.stream().anyMatch(param -> this.matchProfile((IQueryParameterType)param, theResource));
    }

    private boolean matchProfile(IQueryParameterType theProfileParam, IBaseResource theResource) {
        UriParam paramProfile = new UriParam(theProfileParam.getValueAsQueryToken(this.myFhirContext));
        String paramProfileValue = paramProfile.getValue();
        if (StringUtils.isBlank((CharSequence)paramProfileValue)) {
            return false;
        }
        return theResource.getMeta().getProfile().stream().map(IPrimitiveType::getValueAsString).anyMatch(profileValue -> profileValue != null && profileValue.equals(paramProfileValue));
    }

    private boolean matchSourcesAndOr(List<List<IQueryParameterType>> theAndOrParams, IBaseResource theResource) {
        if (theResource == null) {
            return true;
        }
        return theAndOrParams.stream().allMatch(nextAnd -> this.matchSourcesOr((List<IQueryParameterType>)nextAnd, theResource));
    }

    private boolean matchSourcesOr(List<IQueryParameterType> theOrParams, IBaseResource theResource) {
        return theOrParams.stream().anyMatch(param -> this.matchSource((IQueryParameterType)param, theResource));
    }

    private boolean matchSource(IQueryParameterType theSourceParam, IBaseResource theResource) {
        SourceParam paramSource = new SourceParam(theSourceParam.getValueAsQueryToken(this.myFhirContext));
        SourceParam resourceSource = new SourceParam(MetaUtil.getSource((FhirContext)this.myFhirContext, (IBaseMetaType)theResource.getMeta()));
        boolean matches = true;
        if (paramSource.getSourceUri() != null) {
            matches = this.matchSourceWithModifiers(theSourceParam, paramSource, resourceSource.getSourceUri());
        }
        if (paramSource.getRequestId() != null) {
            matches &= paramSource.getRequestId().equals(resourceSource.getRequestId());
        }
        return matches;
    }

    private boolean matchSourceWithModifiers(IQueryParameterType parameterType, SourceParam paramSource, String theSourceUri) {
        if (parameterType.getMissing() != null) {
            return parameterType.getMissing() == StringUtils.isBlank((CharSequence)theSourceUri);
        }
        if (parameterType instanceof UriParam && ((UriParam)parameterType).getQualifier() != null) {
            UriParam uriParam = (UriParam)parameterType;
            switch (uriParam.getQualifier()) {
                case ABOVE: {
                    return UrlUtil.getAboveUriCandidates((String)paramSource.getSourceUri()).stream().anyMatch(candidate -> candidate.equals(theSourceUri));
                }
                case BELOW: {
                    return theSourceUri.startsWith(paramSource.getSourceUri());
                }
                case CONTAINS: {
                    return StringUtils.containsIgnoreCase((CharSequence)theSourceUri, (CharSequence)paramSource.getSourceUri());
                }
            }
            return false;
        }
        return paramSource.getSourceUri().equals(theSourceUri);
    }

    private boolean matchTagsOrSecurityAndOr(List<List<IQueryParameterType>> theAndOrParams, IBaseResource theResource, boolean theTag) {
        if (theResource == null) {
            return true;
        }
        return theAndOrParams.stream().allMatch(nextAnd -> this.matchTagsOrSecurityOr((List<IQueryParameterType>)nextAnd, theResource, theTag));
    }

    private boolean matchTagsOrSecurityOr(List<IQueryParameterType> theOrParams, IBaseResource theResource, boolean theTag) {
        return theOrParams.stream().anyMatch(param -> this.matchTagOrSecurity((IQueryParameterType)param, theResource, theTag));
    }

    private boolean matchTagOrSecurity(IQueryParameterType theParam, IBaseResource theResource, boolean theTag) {
        TokenParam param = (TokenParam)theParam;
        List list = theTag ? theResource.getMeta().getTag() : theResource.getMeta().getSecurity();
        boolean haveMatch = false;
        boolean haveCandidate = false;
        for (IBaseCoding next : list) {
            if (param.getSystem() == null && param.getValue() == null) continue;
            haveCandidate = true;
            if (StringUtils.isNotBlank((CharSequence)param.getSystem()) && !param.getSystem().equals(next.getSystem()) || StringUtils.isNotBlank((CharSequence)param.getValue()) && !param.getValue().equals(next.getCode())) continue;
            haveMatch = true;
            break;
        }
        if (param.getModifier() == TokenParamModifier.NOT) {
            haveMatch = !haveMatch;
        }
        return haveMatch && haveCandidate;
    }

    private boolean matchIdsAndOr(List<List<IQueryParameterType>> theAndOrParams, IBaseResource theResource) {
        if (theResource == null) {
            return true;
        }
        return theAndOrParams.stream().allMatch(nextAnd -> this.matchIdsOr((List<IQueryParameterType>)nextAnd, theResource));
    }

    private boolean matchIdsOr(List<IQueryParameterType> theOrParams, IBaseResource theResource) {
        return theOrParams.stream().anyMatch(param -> param instanceof StringParam && this.matchId(((StringParam)param).getValue(), theResource.getIdElement()));
    }

    private boolean matchId(String theValue, IIdType theId) {
        return theValue.equals(theId.getValue()) || theValue.equals(theId.getIdPart());
    }

    private InMemoryMatchResult matchResourceParam(StorageSettings theStorageSettings, String theParamName, List<List<IQueryParameterType>> theAndOrParams, ResourceIndexedSearchParams theSearchParams, String theResourceName, RuntimeSearchParam theParamDef) {
        if (theParamDef != null) {
            switch (theParamDef.getParamType()) {
                case QUANTITY: 
                case TOKEN: 
                case STRING: 
                case NUMBER: 
                case URI: 
                case DATE: 
                case REFERENCE: {
                    if (theSearchParams == null) {
                        return InMemoryMatchResult.successfulMatch();
                    }
                    return InMemoryMatchResult.fromBoolean(theAndOrParams.stream().allMatch(nextAnd -> this.matchParams(theStorageSettings, theResourceName, theParamName, theParamDef, (List<? extends IQueryParameterType>)nextAnd, theSearchParams)));
                }
            }
            return InMemoryMatchResult.unsupportedFromParameterAndReason(theParamName, "Parameter not supported");
        }
        if ("_content".equals(theParamName) || "_text".equals(theParamName)) {
            return InMemoryMatchResult.unsupportedFromParameterAndReason(theParamName, "Parameter not supported");
        }
        throw new InvalidRequestException(Msg.code((int)509) + "Unknown search parameter " + theParamName + " for resource type " + theResourceName);
    }

    private boolean matchParams(StorageSettings theStorageSettings, String theResourceName, String theParamName, RuntimeSearchParam theParamDef, List<? extends IQueryParameterType> theOrList, ResourceIndexedSearchParams theSearchParams) {
        boolean isNegativeTest = this.isNegative(theParamDef, theOrList);
        if (isNegativeTest) {
            return theOrList.stream().allMatch(token -> this.matchParam(theStorageSettings, theResourceName, theParamName, theParamDef, theSearchParams, (IQueryParameterType)token));
        }
        return theOrList.stream().anyMatch(token -> this.matchParam(theStorageSettings, theResourceName, theParamName, theParamDef, theSearchParams, (IQueryParameterType)token));
    }

    private boolean isNegative(RuntimeSearchParam theParamDef, List<? extends IQueryParameterType> theOrList) {
        if (theParamDef.getParamType().equals((Object)RestSearchParameterTypeEnum.TOKEN)) {
            TokenParam tokenParam = (TokenParam)theOrList.get(0);
            TokenParamModifier modifier = tokenParam.getModifier();
            return modifier != null && modifier.isNegative();
        }
        return false;
    }

    private boolean matchParam(StorageSettings theStorageSettings, String theResourceName, String theParamName, RuntimeSearchParam theParamDef, ResourceIndexedSearchParams theSearchParams, IQueryParameterType theToken) {
        if (theParamDef.getParamType().equals((Object)RestSearchParameterTypeEnum.TOKEN)) {
            return this.matchTokenParam(theStorageSettings, theResourceName, theParamName, theParamDef, theSearchParams, (TokenParam)theToken);
        }
        return theSearchParams.matchParam(theStorageSettings, theResourceName, theParamName, theParamDef, theToken);
    }

    private boolean matchTokenParam(StorageSettings theStorageSettings, String theResourceName, String theParamName, RuntimeSearchParam theParamDef, ResourceIndexedSearchParams theSearchParams, TokenParam theQueryParam) {
        if (theQueryParam.getModifier() != null) {
            switch (theQueryParam.getModifier()) {
                case IN: {
                    return theSearchParams.myTokenParams.stream().filter(t -> ResourceIndexedSearchParams.isMatchSearchParam(theStorageSettings, theResourceName, theParamName, (BaseResourceIndexedSearchParam)t)).anyMatch(t -> this.systemContainsCode(theQueryParam, (ResourceIndexedSearchParamToken)t));
                }
                case NOT_IN: {
                    return theSearchParams.myTokenParams.stream().filter(t -> ResourceIndexedSearchParams.isMatchSearchParam(theStorageSettings, theResourceName, theParamName, (BaseResourceIndexedSearchParam)t)).noneMatch(t -> this.systemContainsCode(theQueryParam, (ResourceIndexedSearchParamToken)t));
                }
                case NOT: {
                    return !theSearchParams.matchParam(theStorageSettings, theResourceName, theParamName, theParamDef, (IQueryParameterType)theQueryParam);
                }
            }
            return theSearchParams.matchParam(theStorageSettings, theResourceName, theParamName, theParamDef, (IQueryParameterType)theQueryParam);
        }
        return theSearchParams.matchParam(theStorageSettings, theResourceName, theParamName, theParamDef, (IQueryParameterType)theQueryParam);
    }

    private boolean systemContainsCode(TokenParam theQueryParam, ResourceIndexedSearchParamToken theSearchParamToken) {
        IValidationSupport validationSupport = this.getValidationSupportOrNull();
        if (validationSupport == null) {
            ourLog.error(Msg.code((int)2096) + "Attempting to evaluate an unsupported qualifier. This should not happen.");
            return false;
        }
        IValidationSupport.CodeValidationResult codeValidationResult = validationSupport.validateCode(new ValidationSupportContext(validationSupport), new ConceptValidationOptions(), theSearchParamToken.getSystem(), theSearchParamToken.getValue(), null, theQueryParam.getValue());
        if (codeValidationResult != null) {
            return codeValidationResult.isOk();
        }
        return false;
    }

    private boolean hasChain(IQueryParameterType theParam) {
        return theParam instanceof ReferenceParam && ((ReferenceParam)theParam).getChain() != null;
    }

    private boolean hasQualifiers(IQueryParameterType theParam) {
        return theParam.getQueryParameterQualifier() != null;
    }

    private InMemoryMatchResult checkUnsupportedPrefixes(String theParamName, RuntimeSearchParam theParamDef, IQueryParameterType theParam) {
        RestSearchParameterTypeEnum paramType;
        ParamPrefixEnum prefix;
        if (theParamDef != null && theParam instanceof BaseParamWithPrefix && !this.supportedPrefix(prefix = ((BaseParamWithPrefix)theParam).getPrefix(), paramType = theParamDef.getParamType())) {
            return InMemoryMatchResult.unsupportedFromParameterAndReason(theParamName, String.format("The prefix %s is not supported for param type %s", prefix, paramType));
        }
        return InMemoryMatchResult.successfulMatch();
    }

    private boolean supportedPrefix(ParamPrefixEnum theParam, RestSearchParameterTypeEnum theParamType) {
        if (theParam == null || theParamType == null) {
            return true;
        }
        switch (theParamType) {
            case DATE: {
                switch (theParam) {
                    case GREATERTHAN: 
                    case GREATERTHAN_OR_EQUALS: 
                    case LESSTHAN: 
                    case LESSTHAN_OR_EQUALS: 
                    case EQUAL: {
                        return true;
                    }
                }
                break;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    private InMemoryMatchResult checkUnsupportedQualifiers(String theParamName, RuntimeSearchParam theParamDef, IQueryParameterType theParam) {
        if (this.hasQualifiers(theParam) && !this.supportedQualifier(theParamDef, theParam)) {
            return InMemoryMatchResult.unsupportedFromParameterAndReason(theParamName + theParam.getQueryParameterQualifier(), "Qualified parameter not supported");
        }
        return InMemoryMatchResult.successfulMatch();
    }

    private boolean supportedQualifier(RuntimeSearchParam theParamDef, IQueryParameterType theParam) {
        if (theParamDef == null || theParam == null) {
            return true;
        }
        switch (theParamDef.getParamType()) {
            case TOKEN: {
                TokenParam tokenParam = (TokenParam)theParam;
                switch (tokenParam.getModifier()) {
                    case IN: 
                    case NOT_IN: {
                        return this.getValidationSupportOrNull() != null;
                    }
                    case NOT: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private static enum ValidationSupportInitializationState {
        NOT_INITIALIZED,
        INITIALIZED,
        FAILED;

    }
}

