/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.nickname;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.nickname.INicknameSvc;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.StringParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NicknameInterceptor {
    private static final Logger ourLog = LoggerFactory.getLogger(NicknameInterceptor.class);
    private final INicknameSvc myNicknameSvc;

    public NicknameInterceptor(INicknameSvc theNicknameSvc) {
        this.myNicknameSvc = theNicknameSvc;
    }

    @Hook(value=Pointcut.STORAGE_PRESEARCH_REGISTERED)
    public void expandNicknames(SearchParameterMap theSearchParameterMap) {
        for (Map.Entry<String, List<List<IQueryParameterType>>> set : theSearchParameterMap.entrySet()) {
            String paramName = set.getKey();
            List<List<IQueryParameterType>> andList = set.getValue();
            for (List<IQueryParameterType> orList : andList) {
                this.expandAnyNicknameParameters(paramName, orList);
            }
        }
    }

    private void expandAnyNicknameParameters(String theParamName, List<IQueryParameterType> orList) {
        ArrayList toAdd = new ArrayList();
        ArrayList<StringParam> toRemove = new ArrayList<StringParam>();
        for (IQueryParameterType iQueryParameterType : orList) {
            StringParam stringParam;
            if (!(iQueryParameterType instanceof StringParam) || !(stringParam = (StringParam)iQueryParameterType).isNicknameExpand()) continue;
            ourLog.debug("Found a nickname parameter to expand: {} {}", (Object)theParamName, (Object)stringParam);
            toRemove.add(stringParam);
            String name = stringParam.getValue().toLowerCase(Locale.ROOT);
            Collection expansions = this.myNicknameSvc.getEquivalentNames(name);
            if (expansions == null) continue;
            ourLog.debug("Parameter has been expanded to: {} {}", (Object)theParamName, (Object)String.join((CharSequence)", ", expansions));
            expansions.stream().map(StringParam::new).forEach(toAdd::add);
        }
        orList.removeAll(toRemove);
        orList.addAll(toAdd);
    }
}

