/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.searchparam.matcher.SearchParamMatcher;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.provider.HashMapResourceProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class SearchableHashMapResourceProvider<T extends IBaseResource>
extends HashMapResourceProvider<T> {
    private final SearchParamMatcher mySearchParamMatcher;

    public SearchableHashMapResourceProvider(FhirContext theFhirContext, Class<T> theResourceType, SearchParamMatcher theSearchParamMatcher) {
        super(theFhirContext, theResourceType);
        this.mySearchParamMatcher = theSearchParamMatcher;
    }

    public List<IBaseResource> searchByCriteria(String theCriteria, RequestDetails theRequest) {
        return this.searchBy(resource -> this.mySearchParamMatcher.match(theCriteria, (IBaseResource)resource, theRequest), theRequest);
    }

    public List<IBaseResource> searchByParams(SearchParameterMap theSearchParams, RequestDetails theRequest) {
        return this.searchBy(resource -> this.mySearchParamMatcher.match(theSearchParams.toNormalizedQueryString(this.getFhirContext()), (IBaseResource)resource, theRequest), theRequest);
    }

    private List<IBaseResource> searchBy(Function<IBaseResource, InMemoryMatchResult> theMatcher, RequestDetails theRequest) {
        this.mySearchCount.incrementAndGet();
        List allEResources = this.getAllResources();
        ArrayList<IBaseResource> matches = new ArrayList<IBaseResource>();
        for (IBaseResource resource : allEResources) {
            InMemoryMatchResult result = theMatcher.apply(resource);
            if (!result.supported()) {
                throw new InvalidRequestException(Msg.code((int)502) + "Search not supported by in-memory matcher: " + result.getUnsupportedReason());
            }
            if (!result.matched()) continue;
            matches.add(resource);
        }
        return SearchableHashMapResourceProvider.fireInterceptorsAndFilterAsNeeded(matches, (RequestDetails)theRequest);
    }
}

