/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.registry;

import ca.uhn.fhir.context.ComboSearchParamType;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.context.phonetic.IPhoneticEncoder;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.IInterceptorService;
import ca.uhn.fhir.jpa.cache.IResourceChangeEvent;
import ca.uhn.fhir.jpa.cache.IResourceChangeListener;
import ca.uhn.fhir.jpa.cache.IResourceChangeListenerCache;
import ca.uhn.fhir.jpa.cache.IResourceChangeListenerRegistry;
import ca.uhn.fhir.jpa.cache.ResourceChangeResult;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.model.search.ISearchParamHashIdentityRegistry;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.registry.ISearchParamProvider;
import ca.uhn.fhir.jpa.searchparam.registry.ISearchParamRegistryController;
import ca.uhn.fhir.jpa.searchparam.registry.JpaSearchParamCache;
import ca.uhn.fhir.jpa.searchparam.registry.ReadOnlySearchParamCache;
import ca.uhn.fhir.jpa.searchparam.registry.RuntimeSearchParamCache;
import ca.uhn.fhir.jpa.searchparam.registry.SearchParameterCanonicalizer;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.rest.server.util.IndexedSearchParam;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import ca.uhn.fhir.util.SearchParameterUtil;
import ca.uhn.fhir.util.StopWatch;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SearchParamRegistryImpl
implements ISearchParamRegistry,
IResourceChangeListener,
ISearchParamRegistryController,
ISearchParamHashIdentityRegistry {
    public static final Set<String> NON_DISABLEABLE_SEARCH_PARAMS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"*:url", "Subscription:*", "SearchParameter:*"}));
    private static final Logger ourLog = LoggerFactory.getLogger(SearchParamRegistryImpl.class);
    private static final int MAX_MANAGED_PARAM_COUNT = 10000;
    private static final long REFRESH_INTERVAL = 60000L;
    private final JpaSearchParamCache myJpaSearchParamCache = new JpaSearchParamCache();
    @Autowired
    private StorageSettings myStorageSettings;
    @Autowired
    private ISearchParamProvider mySearchParamProvider;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private SearchParameterCanonicalizer mySearchParameterCanonicalizer;
    @Autowired
    private IInterceptorService myInterceptorBroadcaster;
    @Autowired
    private IResourceChangeListenerRegistry myResourceChangeListenerRegistry;
    private IResourceChangeListenerCache myResourceChangeListenerCache;
    private volatile ReadOnlySearchParamCache myBuiltInSearchParams;
    private volatile IPhoneticEncoder myPhoneticEncoder;
    private volatile RuntimeSearchParamCache myActiveSearchParams;

    public RuntimeSearchParam getActiveSearchParam(String theResourceName, String theParamName) {
        this.requiresActiveSearchParams();
        if (this.myActiveSearchParams != null) {
            return this.myActiveSearchParams.get(theResourceName, theParamName);
        }
        return null;
    }

    @Nonnull
    public ResourceSearchParams getActiveSearchParams(String theResourceName) {
        this.requiresActiveSearchParams();
        return this.getActiveSearchParams().getSearchParamMap(theResourceName);
    }

    private void requiresActiveSearchParams() {
        if (this.myActiveSearchParams == null) {
            this.myResourceChangeListenerCache.forceRefresh();
        }
    }

    public List<RuntimeSearchParam> getActiveComboSearchParams(String theResourceName) {
        return this.myJpaSearchParamCache.getActiveComboSearchParams(theResourceName);
    }

    public List<RuntimeSearchParam> getActiveComboSearchParams(String theResourceName, ComboSearchParamType theParamType) {
        return this.myJpaSearchParamCache.getActiveComboSearchParams(theResourceName, theParamType);
    }

    public List<RuntimeSearchParam> getActiveComboSearchParams(String theResourceName, Set<String> theParamNames) {
        return this.myJpaSearchParamCache.getActiveComboSearchParams(theResourceName, theParamNames);
    }

    public Optional<IndexedSearchParam> getIndexedSearchParamByHashIdentity(Long theHashIdentity) {
        return this.myJpaSearchParamCache.getIndexedSearchParamByHashIdentity(theHashIdentity);
    }

    @Nullable
    public RuntimeSearchParam getActiveSearchParamByUrl(String theUrl) {
        if (this.myActiveSearchParams != null) {
            return this.myActiveSearchParams.getByUrl(theUrl);
        }
        return null;
    }

    public Optional<RuntimeSearchParam> getActiveComboSearchParamById(String theResourceName, IIdType theId) {
        return this.myJpaSearchParamCache.getActiveComboSearchParamById(theResourceName, theId);
    }

    private void rebuildActiveSearchParams() {
        ourLog.info("Rebuilding SearchParamRegistry");
        SearchParameterMap params = new SearchParameterMap();
        params.setLoadSynchronousUpTo(10000);
        params.setCount(10000);
        IBundleProvider allSearchParamsBp = this.mySearchParamProvider.search(params);
        List allSearchParams = allSearchParamsBp.getResources(0, 10000);
        Integer size = allSearchParamsBp.size();
        ourLog.trace("Loaded {} search params from the DB", (Object)allSearchParams.size());
        if (size == null) {
            ourLog.error("Only {} search parameters have been loaded, but there are more than that in the repository.  Is offset search configured on this server?", (Object)allSearchParams.size());
        } else if (size >= 10000) {
            ourLog.warn("Unable to support >10000 search params!");
        }
        this.initializeActiveSearchParams(allSearchParams);
    }

    private void initializeActiveSearchParams(Collection<IBaseResource> theJpaSearchParams) {
        StopWatch sw = new StopWatch();
        ReadOnlySearchParamCache builtInSearchParams = this.getBuiltInSearchParams();
        RuntimeSearchParamCache searchParams = RuntimeSearchParamCache.fromReadOnlySearchParamCache(builtInSearchParams);
        long overriddenCount = this.overrideBuiltinSearchParamsWithActiveJpaSearchParams(searchParams, theJpaSearchParams);
        ourLog.trace("Have overridden {} built-in search parameters", (Object)overriddenCount);
        this.removeInactiveSearchParams(searchParams);
        if (this.myStorageSettings.isLanguageSearchParameterEnabled()) {
            IIdType id = this.myFhirContext.getVersion().newIdType();
            id.setValue("SearchParameter/Resource-language");
            RuntimeSearchParam sp = new RuntimeSearchParam(id, "http://hl7.org/fhir/SearchParameter/Resource-language", "_language", "Language of the resource content", "language", RestSearchParameterTypeEnum.TOKEN, Collections.emptySet(), Collections.emptySet(), RuntimeSearchParam.RuntimeSearchParamStatusEnum.ACTIVE, (Collection)this.myFhirContext.getResourceTypes());
            for (String baseResourceType : sp.getBase()) {
                searchParams.add(baseResourceType, sp.getName(), sp);
            }
        }
        this.setActiveSearchParams(searchParams);
        this.myJpaSearchParamCache.populateActiveSearchParams(this.myInterceptorBroadcaster, this.myPhoneticEncoder, this.myActiveSearchParams);
        ourLog.debug("Refreshed search parameter cache in {}ms", (Object)sw.getMillis());
    }

    @VisibleForTesting
    public void setFhirContext(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    private ReadOnlySearchParamCache getBuiltInSearchParams() {
        if (this.myBuiltInSearchParams == null) {
            this.myBuiltInSearchParams = this.myStorageSettings.isAutoSupportDefaultSearchParams() ? ReadOnlySearchParamCache.fromFhirContext(this.myFhirContext, this.mySearchParameterCanonicalizer) : ReadOnlySearchParamCache.fromFhirContext(this.myFhirContext, this.mySearchParameterCanonicalizer, NON_DISABLEABLE_SEARCH_PARAMS);
        }
        return this.myBuiltInSearchParams;
    }

    private void removeInactiveSearchParams(RuntimeSearchParamCache theSearchParams) {
        for (String resourceName : theSearchParams.getResourceNameKeys()) {
            ResourceSearchParams resourceSearchParams = theSearchParams.getSearchParamMap(resourceName);
            resourceSearchParams.removeInactive();
        }
    }

    @VisibleForTesting
    public void setStorageSettings(StorageSettings theStorageSettings) {
        this.myStorageSettings = theStorageSettings;
    }

    private long overrideBuiltinSearchParamsWithActiveJpaSearchParams(RuntimeSearchParamCache theSearchParamCache, Collection<IBaseResource> theSearchParams) {
        if (!this.myStorageSettings.isDefaultSearchParamsCanBeOverridden() || theSearchParams == null) {
            return 0L;
        }
        long retval = 0L;
        for (IBaseResource searchParam : theSearchParams) {
            retval += this.overrideSearchParam(theSearchParamCache, searchParam);
        }
        return retval;
    }

    private long overrideSearchParam(RuntimeSearchParamCache theSearchParams, IBaseResource theSearchParameter) {
        if (theSearchParameter == null) {
            return 0L;
        }
        RuntimeSearchParam runtimeSp = this.mySearchParameterCanonicalizer.canonicalizeSearchParameter(theSearchParameter);
        if (runtimeSp == null) {
            return 0L;
        }
        if (runtimeSp.getStatus() == RuntimeSearchParam.RuntimeSearchParamStatusEnum.DRAFT) {
            return 0L;
        }
        long retval = 0L;
        for (String nextBaseName : SearchParameterUtil.getBaseAsStrings((FhirContext)this.myFhirContext, (IBaseResource)theSearchParameter)) {
            if (StringUtils.isBlank((CharSequence)nextBaseName)) continue;
            String name = runtimeSp.getName();
            theSearchParams.add(nextBaseName, name, runtimeSp);
            ourLog.debug("Adding search parameter {}.{} to SearchParamRegistry", (Object)nextBaseName, (Object)StringUtils.defaultString((String)name, (String)"[composite]"));
            ++retval;
        }
        return retval;
    }

    public void requestRefresh() {
        this.myResourceChangeListenerCache.requestRefresh();
    }

    public void forceRefresh() {
        RuntimeSearchParamCache activeSearchParams = this.myActiveSearchParams;
        this.myResourceChangeListenerCache.forceRefresh();
        if (this.myActiveSearchParams == activeSearchParams) {
            this.rebuildActiveSearchParams();
        }
    }

    @Override
    public ResourceChangeResult refreshCacheIfNecessary() {
        return this.myResourceChangeListenerCache.refreshCacheIfNecessary();
    }

    @VisibleForTesting
    public void setResourceChangeListenerRegistry(IResourceChangeListenerRegistry theResourceChangeListenerRegistry) {
        this.myResourceChangeListenerRegistry = theResourceChangeListenerRegistry;
    }

    @PostConstruct
    public void registerListener() {
        SearchParameterMap spMap = SearchParameterMap.newSynchronous();
        spMap.setLoadSynchronousUpTo(10000);
        this.myResourceChangeListenerCache = this.myResourceChangeListenerRegistry.registerResourceResourceChangeListener("SearchParameter", spMap, this, 60000L);
    }

    @PreDestroy
    public void unregisterListener() {
        this.myResourceChangeListenerRegistry.unregisterResourceResourceChangeListener(this);
    }

    public ReadOnlySearchParamCache getActiveSearchParams() {
        this.requiresActiveSearchParams();
        if (this.myActiveSearchParams == null) {
            throw new IllegalStateException(Msg.code((int)511) + "SearchParamRegistry has not been initialized");
        }
        return ReadOnlySearchParamCache.fromRuntimeSearchParamCache(this.myActiveSearchParams);
    }

    public void setPhoneticEncoder(IPhoneticEncoder thePhoneticEncoder) {
        this.myPhoneticEncoder = thePhoneticEncoder;
        if (this.myActiveSearchParams == null) {
            return;
        }
        this.myActiveSearchParams.getSearchParamStream().forEach(searchParam -> this.myJpaSearchParamCache.setPhoneticEncoder(this.myPhoneticEncoder, (RuntimeSearchParam)searchParam));
    }

    @Override
    public void handleChange(IResourceChangeEvent theResourceChangeEvent) {
        if (theResourceChangeEvent.isEmpty()) {
            return;
        }
        ResourceChangeResult result = ResourceChangeResult.fromResourceChangeEvent(theResourceChangeEvent);
        if (result.created > 0L) {
            ourLog.info("Adding {} search parameters to SearchParamRegistry: {}", (Object)result.created, (Object)this.unqualified(theResourceChangeEvent.getCreatedResourceIds()));
        }
        if (result.updated > 0L) {
            ourLog.info("Updating {} search parameters in SearchParamRegistry: {}", (Object)result.updated, (Object)this.unqualified(theResourceChangeEvent.getUpdatedResourceIds()));
        }
        if (result.deleted > 0L) {
            ourLog.info("Deleting {} search parameters from SearchParamRegistry: {}", (Object)result.deleted, (Object)this.unqualified(theResourceChangeEvent.getDeletedResourceIds()));
        }
        this.rebuildActiveSearchParams();
    }

    private String unqualified(List<IIdType> theIds) {
        Iterator unqualifiedIds = theIds.stream().map(IIdType::toUnqualifiedVersionless).map(IIdType::getValue).iterator();
        return StringUtils.join(unqualifiedIds, (String)", ");
    }

    @Override
    public void handleInit(Collection<IIdType> theResourceIds) {
        ArrayList<IBaseResource> searchParams = new ArrayList<IBaseResource>();
        for (IIdType id : theResourceIds) {
            try {
                IBaseResource searchParam = this.mySearchParamProvider.read(id);
                searchParams.add(searchParam);
            }
            catch (ResourceNotFoundException e) {
                ourLog.warn("SearchParameter {} not found.  Excluding from list of active search params.", (Object)id);
            }
        }
        this.initializeActiveSearchParams(searchParams);
    }

    public boolean isInitialized() {
        return this.myActiveSearchParams != null;
    }

    @VisibleForTesting
    public void resetForUnitTest() {
        this.myBuiltInSearchParams = null;
        this.setActiveSearchParams(null);
        this.handleInit(Collections.emptyList());
    }

    @VisibleForTesting
    public void setSearchParameterCanonicalizerForUnitTest(SearchParameterCanonicalizer theSearchParameterCanonicalizerForUnitTest) {
        this.mySearchParameterCanonicalizer = theSearchParameterCanonicalizerForUnitTest;
    }

    @VisibleForTesting
    public int getMaxManagedParamCountForUnitTests() {
        return 10000;
    }

    @VisibleForTesting
    public void setActiveSearchParams(RuntimeSearchParamCache theSearchParams) {
        this.myActiveSearchParams = theSearchParams;
    }
}

