/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;

public class LastNParameterHelper {
    public static boolean isLastNParameter(String theParamName, FhirContext theContext) {
        if (theParamName == null) {
            return false;
        }
        FhirVersionEnum version = theContext.getVersion().getVersion();
        if (LastNParameterHelper.isR5(version) && LastNParameterHelper.isLastNParameterR5(theParamName)) {
            return true;
        }
        if (LastNParameterHelper.isR4(version) && LastNParameterHelper.isLastNParameterR4(theParamName)) {
            return true;
        }
        return LastNParameterHelper.isDstu3(version) && LastNParameterHelper.isLastNParameterDstu3(theParamName);
    }

    private static boolean isDstu3(FhirVersionEnum theVersion) {
        return theVersion == FhirVersionEnum.DSTU3;
    }

    private static boolean isR4(FhirVersionEnum theVersion) {
        return theVersion == FhirVersionEnum.R4;
    }

    private static boolean isR5(FhirVersionEnum theVersion) {
        return theVersion == FhirVersionEnum.R5;
    }

    private static boolean isLastNParameterDstu3(String theParamName) {
        return theParamName.equals("subject") || theParamName.equals("patient") || theParamName.equals("category") || theParamName.equals("code") || theParamName.equals("date");
    }

    private static boolean isLastNParameterR4(String theParamName) {
        return theParamName.equals("subject") || theParamName.equals("patient") || theParamName.equals("category") || theParamName.equals("code") || theParamName.equals("date");
    }

    private static boolean isLastNParameterR5(String theParamName) {
        return theParamName.equals("subject") || theParamName.equals("patient") || theParamName.equals("category") || theParamName.equals("code") || theParamName.equals("date");
    }

    public static String getSubjectParamName(FhirContext theContext) {
        if (theContext.getVersion().getVersion() == FhirVersionEnum.R5) {
            return "subject";
        }
        if (theContext.getVersion().getVersion() == FhirVersionEnum.R4) {
            return "subject";
        }
        if (theContext.getVersion().getVersion() == FhirVersionEnum.DSTU3) {
            return "subject";
        }
        throw new InvalidRequestException(Msg.code((int)489) + "$lastn operation is not implemented for FHIR Version " + theContext.getVersion().getVersion().getFhirVersionString());
    }

    public static String getPatientParamName(FhirContext theContext) {
        if (theContext.getVersion().getVersion() == FhirVersionEnum.R5) {
            return "patient";
        }
        if (theContext.getVersion().getVersion() == FhirVersionEnum.R4) {
            return "patient";
        }
        if (theContext.getVersion().getVersion() == FhirVersionEnum.DSTU3) {
            return "patient";
        }
        throw new InvalidRequestException(Msg.code((int)490) + "$lastn operation is not implemented for FHIR Version " + theContext.getVersion().getVersion().getFhirVersionString());
    }

    public static String getEffectiveParamName(FhirContext theContext) {
        if (theContext.getVersion().getVersion() == FhirVersionEnum.R5) {
            return "date";
        }
        if (theContext.getVersion().getVersion() == FhirVersionEnum.R4) {
            return "date";
        }
        if (theContext.getVersion().getVersion() == FhirVersionEnum.DSTU3) {
            return "date";
        }
        throw new InvalidRequestException(Msg.code((int)491) + "$lastn operation is not implemented for FHIR Version " + theContext.getVersion().getVersion().getFhirVersionString());
    }

    public static String getCategoryParamName(FhirContext theContext) {
        if (theContext.getVersion().getVersion() == FhirVersionEnum.R5) {
            return "category";
        }
        if (theContext.getVersion().getVersion() == FhirVersionEnum.R4) {
            return "category";
        }
        if (theContext.getVersion().getVersion() == FhirVersionEnum.DSTU3) {
            return "category";
        }
        throw new InvalidRequestException(Msg.code((int)492) + "$lastn operation is not implemented for FHIR Version " + theContext.getVersion().getVersion().getFhirVersionString());
    }

    public static String getCodeParamName(FhirContext theContext) {
        if (theContext.getVersion().getVersion() == FhirVersionEnum.R5) {
            return "code";
        }
        if (theContext.getVersion().getVersion() == FhirVersionEnum.R4) {
            return "code";
        }
        if (theContext.getVersion().getVersion() == FhirVersionEnum.DSTU3) {
            return "code";
        }
        throw new InvalidRequestException(Msg.code((int)493) + "$lastn operation is not implemented for FHIR Version " + theContext.getVersion().getVersion().getFhirVersionString());
    }
}

