/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.cache;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.IInterceptorService;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.cache.IResourceChangeListenerRegistry;
import jakarta.annotation.PreDestroy;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
public class ResourceChangeListenerRegistryInterceptor {
    @Autowired
    private IInterceptorService myInterceptorBroadcaster;
    @Autowired
    private IResourceChangeListenerRegistry myResourceChangeListenerRegistry;

    @EventListener(classes={ContextRefreshedEvent.class})
    @Order(value=200)
    public void start() {
        this.myInterceptorBroadcaster.registerInterceptor((Object)this);
    }

    @PreDestroy
    public void stop() {
        this.myInterceptorBroadcaster.unregisterInterceptor((Object)this);
    }

    @Hook(value=Pointcut.STORAGE_PRECOMMIT_RESOURCE_CREATED)
    public void created(IBaseResource theResource) {
        this.handle(theResource);
    }

    @Hook(value=Pointcut.STORAGE_PRECOMMIT_RESOURCE_DELETED)
    public void deleted(IBaseResource theResource) {
        this.handle(theResource);
    }

    @Hook(value=Pointcut.STORAGE_PRECOMMIT_RESOURCE_UPDATED)
    public void updated(IBaseResource theResource) {
        this.handle(theResource);
    }

    private void handle(IBaseResource theResource) {
        if (theResource == null) {
            return;
        }
        this.myResourceChangeListenerRegistry.requestRefreshIfWatching(theResource);
    }
}

