/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.cache;

import ca.uhn.fhir.jpa.cache.IResourceChangeEvent;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ResourceChangeResult {
    public final long created;
    public final long updated;
    public final long deleted;

    public ResourceChangeResult() {
        this.created = 0L;
        this.updated = 0L;
        this.deleted = 0L;
    }

    private ResourceChangeResult(long theCreated, long theUpdated, long theDeleted) {
        this.created = theCreated;
        this.updated = theUpdated;
        this.deleted = theDeleted;
    }

    public static ResourceChangeResult fromCreated(int theCreated) {
        return new ResourceChangeResult(theCreated, 0L, 0L);
    }

    public static ResourceChangeResult fromResourceChangeEvent(IResourceChangeEvent theResourceChangeEvent) {
        return new ResourceChangeResult(theResourceChangeEvent.getCreatedResourceIds().size(), theResourceChangeEvent.getUpdatedResourceIds().size(), theResourceChangeEvent.getDeletedResourceIds().size());
    }

    public ResourceChangeResult plus(ResourceChangeResult theResult) {
        return new ResourceChangeResult(this.created + theResult.created, this.updated + theResult.updated, this.deleted + theResult.deleted);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("created", this.created).append("updated", this.updated).append("deleted", this.deleted).toString();
    }
}

