/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.config;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.cache.IResourceChangeListener;
import ca.uhn.fhir.jpa.cache.IResourceChangeListenerCacheRefresher;
import ca.uhn.fhir.jpa.cache.IResourceChangeListenerRegistry;
import ca.uhn.fhir.jpa.cache.ResourceChangeListenerCache;
import ca.uhn.fhir.jpa.cache.ResourceChangeListenerCacheFactory;
import ca.uhn.fhir.jpa.cache.ResourceChangeListenerCacheRefresherImpl;
import ca.uhn.fhir.jpa.cache.ResourceChangeListenerRegistryImpl;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.SearchParamExtractorDstu2;
import ca.uhn.fhir.jpa.searchparam.extractor.SearchParamExtractorDstu3;
import ca.uhn.fhir.jpa.searchparam.extractor.SearchParamExtractorR4;
import ca.uhn.fhir.jpa.searchparam.extractor.SearchParamExtractorR4B;
import ca.uhn.fhir.jpa.searchparam.extractor.SearchParamExtractorR5;
import ca.uhn.fhir.jpa.searchparam.extractor.SearchParamExtractorService;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryResourceMatcher;
import ca.uhn.fhir.jpa.searchparam.matcher.IndexedSearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.matcher.SearchParamMatcher;
import ca.uhn.fhir.jpa.searchparam.registry.SearchParamRegistryImpl;
import ca.uhn.fhir.jpa.searchparam.registry.SearchParameterCanonicalizer;
import ca.uhn.fhir.jpa.searchparam.util.SearchParameterHelper;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;

@Configuration
public class SearchParamConfig {
    @Autowired
    private FhirContext myFhirContext;

    @Bean
    public ISearchParamExtractor searchParamExtractor() {
        switch (this.myFhirContext.getVersion().getVersion()) {
            case DSTU2: {
                return new SearchParamExtractorDstu2();
            }
            case DSTU3: {
                return new SearchParamExtractorDstu3();
            }
            case R4: {
                return new SearchParamExtractorR4();
            }
            case R4B: {
                return new SearchParamExtractorR4B();
            }
            case R5: {
                return new SearchParamExtractorR5();
            }
        }
        throw new IllegalStateException(Msg.code((int)501) + "Can not handle version: " + String.valueOf(this.myFhirContext.getVersion().getVersion()));
    }

    @Bean
    public ISearchParamRegistry searchParamRegistry() {
        return new SearchParamRegistryImpl();
    }

    @Bean
    public MatchUrlService matchUrlService() {
        return new MatchUrlService();
    }

    @Bean
    @Lazy
    public SearchParamExtractorService searchParamExtractorService() {
        return new SearchParamExtractorService();
    }

    @Bean
    @Lazy
    public SearchParameterCanonicalizer searchParameterCanonicalizer(FhirContext theFhirContext) {
        return new SearchParameterCanonicalizer(theFhirContext);
    }

    @Bean
    public IndexedSearchParamExtractor indexedSearchParamExtractor() {
        return new IndexedSearchParamExtractor();
    }

    @Bean
    public InMemoryResourceMatcher inMemoryResourceMatcher() {
        return new InMemoryResourceMatcher();
    }

    @Bean
    public SearchParamMatcher searchParamMatcher() {
        return new SearchParamMatcher();
    }

    @Bean
    IResourceChangeListenerRegistry resourceChangeListenerRegistry(FhirContext theFhirContext, ResourceChangeListenerCacheFactory theResourceChangeListenerCacheFactory, InMemoryResourceMatcher theInMemoryResourceMatcher) {
        return new ResourceChangeListenerRegistryImpl(theFhirContext, theResourceChangeListenerCacheFactory, theInMemoryResourceMatcher);
    }

    @Bean
    IResourceChangeListenerCacheRefresher resourceChangeListenerCacheRefresher() {
        return new ResourceChangeListenerCacheRefresherImpl();
    }

    @Bean
    ResourceChangeListenerCacheFactory registeredResourceListenerFactory() {
        return new ResourceChangeListenerCacheFactory();
    }

    @Bean
    @Scope(value="prototype")
    ResourceChangeListenerCache registeredResourceChangeListener(String theResourceName, IResourceChangeListener theResourceChangeListener, SearchParameterMap theSearchParameterMap, long theRemoteRefreshIntervalMs) {
        return new ResourceChangeListenerCache(theResourceName, theResourceChangeListener, theSearchParameterMap, theRemoteRefreshIntervalMs);
    }

    @Bean
    @Lazy
    SearchParameterHelper searchParameterHelper(FhirContext theFhirContext) {
        return new SearchParameterHelper(this.searchParameterCanonicalizer(theFhirContext));
    }
}

