/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.extractor;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ResourceIndexedSearchParamComposite {
    private final String mySearchParamName;
    private final String myPath;
    private final List<Component> myComponents = new ArrayList<Component>();

    public ResourceIndexedSearchParamComposite(String theSearchParamName, String thePath) {
        this.mySearchParamName = theSearchParamName;
        this.myPath = thePath;
    }

    public String getSearchParamName() {
        return this.mySearchParamName;
    }

    public String getPath() {
        return this.myPath;
    }

    public List<Component> getComponents() {
        return this.myComponents;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public void addComponentIndexedSearchParams(RuntimeSearchParam theComponentSearchParam, ISearchParamExtractor.SearchParamSet<BaseResourceIndexedSearchParam> theExtractedParams) {
        this.addComponentIndexedSearchParams(theComponentSearchParam.getName(), theComponentSearchParam.getParamType(), theExtractedParams);
    }

    public void addComponentIndexedSearchParams(String theComponentSearchParamName, RestSearchParameterTypeEnum theComponentSearchParamType, ISearchParamExtractor.SearchParamSet<BaseResourceIndexedSearchParam> theExtractedParams) {
        this.myComponents.add(new Component(theComponentSearchParamName, theComponentSearchParamType, theExtractedParams));
    }

    public static class Component {
        private final String mySearchParamName;
        private final RestSearchParameterTypeEnum mySearchParameterType;
        private final ISearchParamExtractor.SearchParamSet<BaseResourceIndexedSearchParam> myParamIndexValues;

        private Component(String theComponentSearchParamName, RestSearchParameterTypeEnum theComponentSearchParamType, ISearchParamExtractor.SearchParamSet<BaseResourceIndexedSearchParam> theParamIndexValues) {
            this.mySearchParamName = theComponentSearchParamName;
            this.mySearchParameterType = theComponentSearchParamType;
            this.myParamIndexValues = theParamIndexValues;
        }

        public String getSearchParamName() {
            return this.mySearchParamName;
        }

        public RestSearchParameterTypeEnum getSearchParameterType() {
            return this.mySearchParameterType;
        }

        public ISearchParamExtractor.SearchParamSet<BaseResourceIndexedSearchParam> getParamIndexValues() {
            return this.myParamIndexValues;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

