/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.extractor;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.NormalizedQuantitySearchLevel;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboStringUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboTokenNonUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamCoords;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamDate;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamNumber;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantity;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantityNormalized;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamString;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamToken;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamUri;
import ca.uhn.fhir.jpa.model.entity.ResourceLink;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.SearchParamPresentEntity;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.model.util.ResourceLinkUtils;
import ca.uhn.fhir.jpa.model.util.SearchParamHash;
import ca.uhn.fhir.jpa.model.util.UcumServiceUtil;
import ca.uhn.fhir.jpa.searchparam.extractor.BaseSearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParamComposite;
import ca.uhn.fhir.jpa.searchparam.util.RuntimeSearchParamHelper;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public final class ResourceIndexedSearchParams {
    private static final Set<String> myIgnoredParams = Set.of("_text", "_content");
    public final Collection<ResourceIndexedSearchParamString> myStringParams;
    public final Collection<ResourceIndexedSearchParamToken> myTokenParams;
    public final Collection<ResourceIndexedSearchParamNumber> myNumberParams;
    public final Collection<ResourceIndexedSearchParamQuantity> myQuantityParams;
    public final Collection<ResourceIndexedSearchParamQuantityNormalized> myQuantityNormalizedParams;
    public final Collection<ResourceIndexedSearchParamDate> myDateParams;
    public final Collection<ResourceIndexedSearchParamUri> myUriParams;
    public final Collection<ResourceIndexedSearchParamCoords> myCoordsParams;
    public final Collection<ResourceIndexedComboStringUnique> myComboStringUniques;
    public final Collection<ResourceIndexedComboTokenNonUnique> myComboTokenNonUnique;
    public final Collection<ResourceLink> myLinks;
    public final Collection<SearchParamPresentEntity> mySearchParamPresentEntities;
    public final Collection<ResourceIndexedSearchParamComposite> myCompositeParams;
    public final Set<String> myPopulatedResourceLinkParameters = new HashSet<String>();

    @Deprecated
    public ResourceIndexedSearchParams() {
        this(Mode.SET);
    }

    private ResourceIndexedSearchParams(Mode theMode) {
        this.myStringParams = theMode.newCollection();
        this.myTokenParams = theMode.newCollection();
        this.myNumberParams = theMode.newCollection();
        this.myQuantityParams = theMode.newCollection();
        this.myQuantityNormalizedParams = theMode.newCollection();
        this.myDateParams = theMode.newCollection();
        this.myUriParams = theMode.newCollection();
        this.myCoordsParams = theMode.newCollection();
        this.myComboStringUniques = theMode.newCollection();
        this.myComboTokenNonUnique = theMode.newCollection();
        this.myLinks = theMode.newCollection();
        this.mySearchParamPresentEntities = theMode.newCollection();
        this.myCompositeParams = theMode.newCollection();
    }

    private ResourceIndexedSearchParams(ResourceTable theEntity, Mode theMode) {
        this(theMode);
        if (theEntity.isParamsStringPopulated()) {
            this.myStringParams.addAll(theEntity.getParamsString());
        }
        if (theEntity.isParamsTokenPopulated()) {
            this.myTokenParams.addAll(theEntity.getParamsToken());
        }
        if (theEntity.isParamsNumberPopulated()) {
            this.myNumberParams.addAll(theEntity.getParamsNumber());
        }
        if (theEntity.isParamsQuantityPopulated()) {
            this.myQuantityParams.addAll(theEntity.getParamsQuantity());
        }
        if (theEntity.isParamsQuantityNormalizedPopulated().booleanValue()) {
            this.myQuantityNormalizedParams.addAll(theEntity.getParamsQuantityNormalized());
        }
        if (theEntity.isParamsDatePopulated()) {
            this.myDateParams.addAll(theEntity.getParamsDate());
        }
        if (theEntity.isParamsUriPopulated()) {
            this.myUriParams.addAll(theEntity.getParamsUri());
        }
        if (theEntity.isParamsCoordsPopulated()) {
            this.myCoordsParams.addAll(theEntity.getParamsCoords());
        }
        if (theEntity.isHasLinks()) {
            this.myLinks.addAll(theEntity.getResourceLinks());
        }
        if (theEntity.isParamsComboStringUniquePresent()) {
            this.myComboStringUniques.addAll(theEntity.getParamsComboStringUnique());
        }
        if (theEntity.isParamsComboTokensNonUniquePresent()) {
            this.myComboTokenNonUnique.addAll(theEntity.getmyParamsComboTokensNonUnique());
        }
    }

    public Collection<ResourceLink> getResourceLinks() {
        return this.myLinks;
    }

    public void populateResourceTableSearchParamsPresentFlags(ResourceTable theEntity) {
        theEntity.setParamsStringPopulated(!this.myStringParams.isEmpty());
        theEntity.setParamsTokenPopulated(!this.myTokenParams.isEmpty());
        theEntity.setParamsNumberPopulated(!this.myNumberParams.isEmpty());
        theEntity.setParamsQuantityPopulated(!this.myQuantityParams.isEmpty());
        theEntity.setParamsQuantityNormalizedPopulated(Boolean.valueOf(!this.myQuantityNormalizedParams.isEmpty()));
        theEntity.setParamsDatePopulated(!this.myDateParams.isEmpty());
        theEntity.setParamsUriPopulated(!this.myUriParams.isEmpty());
        theEntity.setParamsCoordsPopulated(!this.myCoordsParams.isEmpty());
        theEntity.setParamsComboStringUniquePresent(!this.myComboStringUniques.isEmpty());
        theEntity.setParamsComboTokensNonUniquePresent(!this.myComboTokenNonUnique.isEmpty());
        theEntity.setHasLinks(!this.myLinks.isEmpty());
    }

    public void populateResourceTableParamCollections(ResourceTable theEntity) {
        theEntity.setParamsString(this.myStringParams);
        theEntity.setParamsToken(this.myTokenParams);
        theEntity.setParamsNumber(this.myNumberParams);
        theEntity.setParamsQuantity(this.myQuantityParams);
        theEntity.setParamsQuantityNormalized(this.myQuantityNormalizedParams);
        theEntity.setParamsDate(this.myDateParams);
        theEntity.setParamsUri(this.myUriParams);
        theEntity.setParamsCoords(this.myCoordsParams);
        theEntity.setResourceLinks(this.myLinks);
    }

    public void updateSpnamePrefixForIndexOnUpliftedChain(String theContainingType, String theSpnamePrefix) {
        this.updateSpnamePrefixForIndexOnUpliftedChain(theContainingType, this.myNumberParams, theSpnamePrefix);
        this.updateSpnamePrefixForIndexOnUpliftedChain(theContainingType, this.myQuantityParams, theSpnamePrefix);
        this.updateSpnamePrefixForIndexOnUpliftedChain(theContainingType, this.myQuantityNormalizedParams, theSpnamePrefix);
        this.updateSpnamePrefixForIndexOnUpliftedChain(theContainingType, this.myDateParams, theSpnamePrefix);
        this.updateSpnamePrefixForIndexOnUpliftedChain(theContainingType, this.myUriParams, theSpnamePrefix);
        this.updateSpnamePrefixForIndexOnUpliftedChain(theContainingType, this.myTokenParams, theSpnamePrefix);
        this.updateSpnamePrefixForIndexOnUpliftedChain(theContainingType, this.myStringParams, theSpnamePrefix);
        this.updateSpnamePrefixForIndexOnUpliftedChain(theContainingType, this.myCoordsParams, theSpnamePrefix);
    }

    public void updateSpnamePrefixForLinksOnContainedResource(String theSpNamePrefix) {
        for (ResourceLink param : this.myLinks) {
            int index = param.getSourcePath().indexOf(46);
            if (index > -1) {
                param.setSourcePath(theSpNamePrefix + param.getSourcePath().substring(index));
            } else {
                param.setSourcePath(theSpNamePrefix + "." + param.getSourcePath());
            }
            param.calculateHashes();
        }
    }

    void setUpdatedTime(Date theUpdateTime) {
        this.setUpdatedTime(this.myStringParams, theUpdateTime);
        this.setUpdatedTime(this.myNumberParams, theUpdateTime);
        this.setUpdatedTime(this.myQuantityParams, theUpdateTime);
        this.setUpdatedTime(this.myQuantityNormalizedParams, theUpdateTime);
        this.setUpdatedTime(this.myDateParams, theUpdateTime);
        this.setUpdatedTime(this.myUriParams, theUpdateTime);
        this.setUpdatedTime(this.myCoordsParams, theUpdateTime);
        this.setUpdatedTime(this.myTokenParams, theUpdateTime);
    }

    private void setUpdatedTime(Collection<? extends BaseResourceIndexedSearchParam> theParams, Date theUpdateTime) {
        for (BaseResourceIndexedSearchParam baseResourceIndexedSearchParam : theParams) {
            baseResourceIndexedSearchParam.setUpdated(theUpdateTime);
        }
    }

    private void updateSpnamePrefixForIndexOnUpliftedChain(String theContainingType, Collection<? extends BaseResourceIndexedSearchParam> theParams, @Nonnull String theSpnamePrefix) {
        for (BaseResourceIndexedSearchParam baseResourceIndexedSearchParam : theParams) {
            baseResourceIndexedSearchParam.setResourceType(theContainingType);
            baseResourceIndexedSearchParam.setParamName(theSpnamePrefix + "." + baseResourceIndexedSearchParam.getParamName());
            baseResourceIndexedSearchParam.calculateHashes();
        }
    }

    public Set<String> getPopulatedResourceLinkParameters() {
        return this.myPopulatedResourceLinkParameters;
    }

    public boolean matchParam(StorageSettings theStorageSettings, String theResourceName, String theParamName, RuntimeSearchParam theParamDef, IQueryParameterType theValue) {
        if (theParamDef == null) {
            return false;
        }
        Collection<ResourceIndexedSearchParamToken> resourceParams = null;
        IQueryParameterType value = theValue;
        switch (theParamDef.getParamType()) {
            case TOKEN: {
                resourceParams = this.myTokenParams;
                break;
            }
            case QUANTITY: {
                QuantityParam quantity;
                QuantityParam quantityParam;
                if (theStorageSettings.getNormalizedQuantitySearchLevel().equals((Object)NormalizedQuantitySearchLevel.NORMALIZED_QUANTITY_SEARCH_SUPPORTED) && (quantityParam = UcumServiceUtil.toCanonicalQuantityOrNull((QuantityParam)(quantity = QuantityParam.toQuantityParam((IQueryParameterType)theValue)))) != null) {
                    resourceParams = this.myQuantityNormalizedParams;
                    value = quantityParam;
                }
                if (resourceParams != null) break;
                resourceParams = this.myQuantityParams;
                break;
            }
            case STRING: {
                resourceParams = this.myStringParams;
                break;
            }
            case NUMBER: {
                resourceParams = this.myNumberParams;
                break;
            }
            case URI: {
                resourceParams = this.myUriParams;
                break;
            }
            case DATE: {
                resourceParams = this.myDateParams;
                break;
            }
            case REFERENCE: {
                return this.matchResourceLinks(theStorageSettings, theResourceName, theParamName, value, theParamDef.getPathsSplitForResourceType(theResourceName));
            }
            default: {
                resourceParams = null;
            }
        }
        if (resourceParams == null) {
            return false;
        }
        for (BaseResourceIndexedSearchParam baseResourceIndexedSearchParam : resourceParams) {
            if (!ResourceIndexedSearchParams.isMatchSearchParam(theStorageSettings, theResourceName, theParamName, baseResourceIndexedSearchParam) || !baseResourceIndexedSearchParam.matches(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMatchSearchParam(StorageSettings theStorageSettings, String theResourceName, String theParamName, BaseResourceIndexedSearchParam theIndexedSearchParam) {
        if (theStorageSettings.isIndexStorageOptimized()) {
            Long hashIdentity = SearchParamHash.hashSearchParam((PartitionSettings)new PartitionSettings(), (RequestPartitionId)RequestPartitionId.defaultPartition(), (String[])new String[]{theResourceName, theParamName});
            return theIndexedSearchParam.getHashIdentity().equals(hashIdentity);
        }
        return theIndexedSearchParam.getParamName().equalsIgnoreCase(theParamName);
    }

    @Deprecated
    public boolean matchResourceLinks(String theResourceName, String theParamName, IQueryParameterType theParam, String theParamPath) {
        return this.matchResourceLinks(new StorageSettings(), theResourceName, theParamName, theParam, theParamPath);
    }

    public boolean matchResourceLinks(StorageSettings theStorageSettings, String theResourceName, String theParamName, IQueryParameterType theParam, List<String> theParamPaths) {
        for (String nextPath : theParamPaths) {
            if (!this.matchResourceLinks(theStorageSettings, theResourceName, theParamName, theParam, nextPath)) continue;
            return true;
        }
        return false;
    }

    public boolean matchResourceLinks(StorageSettings theStorageSettings, String theResourceName, String theParamName, IQueryParameterType theParam, String theParamPath) {
        ReferenceParam reference = (ReferenceParam)theParam;
        Predicate<ResourceLink> namedParamPredicate = resourceLink -> this.searchParameterPathMatches(theResourceName, (ResourceLink)resourceLink, theParamName, theParamPath) && this.resourceIdMatches(theStorageSettings, (ResourceLink)resourceLink, reference);
        return this.myLinks.stream().anyMatch(namedParamPredicate);
    }

    private boolean resourceIdMatches(StorageSettings theStorageSettings, ResourceLink theResourceLink, ReferenceParam theReference) {
        String baseUrl = theReference.getBaseUrl();
        if (StringUtils.isNotBlank((CharSequence)baseUrl)) {
            if (ResourceLinkUtils.isTargetCanonicalUrl((ResourceLink)theResourceLink)) {
                return theReference.getValue().equals(theResourceLink.getTargetResourceUrl());
            }
            if (!theStorageSettings.getTreatBaseUrlsAsLocal().contains(baseUrl)) {
                return false;
            }
        }
        String targetType = theResourceLink.getTargetResourceType();
        String targetId = theResourceLink.getTargetResourceId();
        assert (StringUtils.isNotBlank((CharSequence)targetType));
        assert (StringUtils.isNotBlank((CharSequence)targetId));
        if (theReference.hasResourceType() && !theReference.getResourceType().equals(targetType)) {
            return false;
        }
        return targetId.equals(theReference.getIdPart());
    }

    private boolean searchParameterPathMatches(String theResourceName, ResourceLink theResourceLink, String theParamName, String theParamPath) {
        String sourcePath = theResourceLink.getSourcePath();
        return sourcePath.equalsIgnoreCase(theParamPath);
    }

    public String toString() {
        return "ResourceIndexedSearchParams{stringParams=" + String.valueOf(this.myStringParams) + ", tokenParams=" + String.valueOf(this.myTokenParams) + ", numberParams=" + String.valueOf(this.myNumberParams) + ", quantityParams=" + String.valueOf(this.myQuantityParams) + ", quantityNormalizedParams=" + String.valueOf(this.myQuantityNormalizedParams) + ", dateParams=" + String.valueOf(this.myDateParams) + ", uriParams=" + String.valueOf(this.myUriParams) + ", coordsParams=" + String.valueOf(this.myCoordsParams) + ", comboStringUniques=" + String.valueOf(this.myComboStringUniques) + ", comboTokenNonUniques=" + String.valueOf(this.myComboTokenNonUnique) + ", links=" + String.valueOf(this.myLinks) + "}";
    }

    public void findMissingSearchParams(PartitionSettings thePartitionSettings, StorageSettings theStorageSettings, ResourceTable theEntity, ResourceSearchParams theActiveSearchParams) {
        this.findMissingSearchParams(thePartitionSettings, theStorageSettings, theEntity, theActiveSearchParams, RestSearchParameterTypeEnum.STRING, this.myStringParams);
        this.findMissingSearchParams(thePartitionSettings, theStorageSettings, theEntity, theActiveSearchParams, RestSearchParameterTypeEnum.NUMBER, this.myNumberParams);
        this.findMissingSearchParams(thePartitionSettings, theStorageSettings, theEntity, theActiveSearchParams, RestSearchParameterTypeEnum.QUANTITY, this.myQuantityParams);
        this.findMissingSearchParams(thePartitionSettings, theStorageSettings, theEntity, theActiveSearchParams, RestSearchParameterTypeEnum.DATE, this.myDateParams);
        this.findMissingSearchParams(thePartitionSettings, theStorageSettings, theEntity, theActiveSearchParams, RestSearchParameterTypeEnum.URI, this.myUriParams);
        this.findMissingSearchParams(thePartitionSettings, theStorageSettings, theEntity, theActiveSearchParams, RestSearchParameterTypeEnum.TOKEN, this.myTokenParams);
        this.findMissingSearchParams(thePartitionSettings, theStorageSettings, theEntity, theActiveSearchParams, RestSearchParameterTypeEnum.SPECIAL, this.myCoordsParams);
    }

    private <RT extends BaseResourceIndexedSearchParam> void findMissingSearchParams(PartitionSettings thePartitionSettings, StorageSettings theStorageSettings, ResourceTable theEntity, ResourceSearchParams activeSearchParams, RestSearchParameterTypeEnum type, Collection<RT> paramCollection) {
        block9: for (String nextParamName : activeSearchParams.getSearchParamNames()) {
            ResourceIndexedSearchParamDate param;
            RuntimeSearchParam searchParam;
            if (nextParamName == null || myIgnoredParams.contains(nextParamName) || RuntimeSearchParamHelper.isResourceLevel(searchParam = activeSearchParams.get(nextParamName)) || searchParam.getParamType() != type) continue;
            boolean haveParam = false;
            for (BaseResourceIndexedSearchParam nextParam : paramCollection) {
                if (!nextParam.getParamName().equals(nextParamName)) continue;
                haveParam = true;
                break;
            }
            if (haveParam) continue;
            switch (type) {
                case DATE: {
                    param = new ResourceIndexedSearchParamDate();
                    break;
                }
                case NUMBER: {
                    param = new ResourceIndexedSearchParamNumber();
                    break;
                }
                case QUANTITY: {
                    param = new ResourceIndexedSearchParamQuantity();
                    break;
                }
                case STRING: {
                    param = new ResourceIndexedSearchParamString().setStorageSettings(theStorageSettings);
                    break;
                }
                case TOKEN: {
                    param = new ResourceIndexedSearchParamToken();
                    break;
                }
                case URI: {
                    param = new ResourceIndexedSearchParamUri();
                    break;
                }
                case SPECIAL: {
                    if (!BaseSearchParamExtractor.COORDS_INDEX_PATHS.contains(searchParam.getPath())) continue block9;
                    param = new ResourceIndexedSearchParamCoords();
                    break;
                }
                default: {
                    continue block9;
                }
            }
            param.setPartitionSettings(thePartitionSettings);
            param.setResource(theEntity);
            param.setMissing(true);
            param.setParamName(nextParamName);
            param.calculateHashes();
            paramCollection.add(param);
        }
    }

    public static Set<String> extractCompositeStringUniquesValueChains(String theResourceType, List<List<String>> thePartsChoices) {
        for (List<String> next : thePartsChoices) {
            next.removeIf(StringUtils::isBlank);
            if (!next.isEmpty()) continue;
            return Collections.emptySet();
        }
        if (thePartsChoices.isEmpty()) {
            return Collections.emptySet();
        }
        thePartsChoices.sort((o1, o2) -> {
            String str1 = null;
            String str2 = null;
            if (o1.size() > 0) {
                str1 = (String)o1.get(0);
            }
            if (o2.size() > 0) {
                str2 = (String)o2.get(0);
            }
            return StringUtils.compare((String)str1, str2);
        });
        ArrayList<String> values = new ArrayList<String>();
        HashSet<String> queryStringsToPopulate = new HashSet<String>();
        ResourceIndexedSearchParams.extractCompositeStringUniquesValueChains(theResourceType, thePartsChoices, values, queryStringsToPopulate);
        values.removeIf(StringUtils::isBlank);
        return queryStringsToPopulate;
    }

    private static void extractCompositeStringUniquesValueChains(String theResourceType, List<List<String>> thePartsChoices, List<String> theValues, Set<String> theQueryStringsToPopulate) {
        if (thePartsChoices.size() > 0) {
            List<String> nextList = thePartsChoices.get(0);
            Collections.sort(nextList);
            for (String nextChoice : nextList) {
                theValues.add(nextChoice);
                ResourceIndexedSearchParams.extractCompositeStringUniquesValueChains(theResourceType, thePartsChoices.subList(1, thePartsChoices.size()), theValues, theQueryStringsToPopulate);
                theValues.remove(theValues.size() - 1);
            }
        } else if (theValues.size() > 0) {
            StringBuilder uniqueString = new StringBuilder();
            uniqueString.append(theResourceType);
            for (int i = 0; i < theValues.size(); ++i) {
                uniqueString.append(i == 0 ? "?" : "&");
                uniqueString.append(theValues.get(i));
            }
            theQueryStringsToPopulate.add(uniqueString.toString());
        }
    }

    public static ResourceIndexedSearchParams withSets() {
        return new ResourceIndexedSearchParams(Mode.SET);
    }

    public static ResourceIndexedSearchParams empty() {
        return new ResourceIndexedSearchParams(Mode.EMPTY);
    }

    public static ResourceIndexedSearchParams withLists(ResourceTable theResourceTable) {
        return new ResourceIndexedSearchParams(theResourceTable, Mode.LIST);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Mode {
        LIST{

            @Override
            public <T> Collection<T> newCollection() {
                return new ArrayList();
            }
        }
        ,
        SET{

            @Override
            public <T> Collection<T> newCollection() {
                return new HashSet();
            }
        }
        ,
        EMPTY{

            @Override
            public <T> Collection<T> newCollection() {
                return List.of();
            }
        };


        public abstract <T> Collection<T> newCollection();
    }
}

