/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.matcher;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParams;
import ca.uhn.fhir.jpa.searchparam.extractor.SearchParamExtractorService;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import jakarta.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.factory.annotation.Autowired;

public class IndexedSearchParamExtractor {
    @Autowired
    private FhirContext myContext;
    @Autowired
    private SearchParamExtractorService mySearchParamExtractorService;

    @Nonnull
    public ResourceIndexedSearchParams extractIndexedSearchParams(IBaseResource theResource, RequestDetails theRequest) {
        return this.extractIndexedSearchParams(theResource, theRequest, ISearchParamExtractor.ALL_PARAMS);
    }

    @Nonnull
    public ResourceIndexedSearchParams extractIndexedSearchParams(IBaseResource theResource, RequestDetails theRequest, ISearchParamExtractor.ISearchParamFilter filter) {
        ResourceTable entity = new ResourceTable();
        TransactionDetails transactionDetails = new TransactionDetails();
        String resourceType = this.myContext.getResourceType(theResource);
        entity.setResourceType(resourceType);
        ResourceIndexedSearchParams resourceIndexedSearchParams = ResourceIndexedSearchParams.withSets();
        this.mySearchParamExtractorService.extractFromResource(null, theRequest, resourceIndexedSearchParams, ResourceIndexedSearchParams.empty(), entity, theResource, transactionDetails, false, filter);
        return resourceIndexedSearchParams;
    }
}

