/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.registry;

import ca.uhn.fhir.context.ComboSearchParamType;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.context.phonetic.IPhoneticEncoder;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.IInterceptorService;
import ca.uhn.fhir.jpa.cache.IResourceChangeEvent;
import ca.uhn.fhir.jpa.cache.IResourceChangeListener;
import ca.uhn.fhir.jpa.cache.IResourceChangeListenerCache;
import ca.uhn.fhir.jpa.cache.IResourceChangeListenerRegistry;
import ca.uhn.fhir.jpa.cache.ISearchParamIdentityCacheSvc;
import ca.uhn.fhir.jpa.cache.ResourceChangeResult;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.registry.ISearchParamProvider;
import ca.uhn.fhir.jpa.searchparam.registry.ISearchParamRegistryController;
import ca.uhn.fhir.jpa.searchparam.registry.JpaSearchParamCache;
import ca.uhn.fhir.jpa.searchparam.registry.ReadOnlySearchParamCache;
import ca.uhn.fhir.jpa.searchparam.registry.RuntimeSearchParamCache;
import ca.uhn.fhir.jpa.searchparam.registry.SearchParameterCanonicalizer;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.rest.server.util.IndexedSearchParam;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import ca.uhn.fhir.util.SearchParameterUtil;
import ca.uhn.fhir.util.StopWatch;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;

public class SearchParamRegistryImpl
implements ISearchParamRegistry,
IResourceChangeListener,
ISearchParamRegistryController {
    public static final Set<String> NON_DISABLEABLE_SEARCH_PARAMS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"*:url", "Subscription:*", "SearchParameter:*", "Basic:*"}));
    private static final Logger ourLog = LoggerFactory.getLogger(SearchParamRegistryImpl.class);
    public static final int MAX_MANAGED_PARAM_COUNT = 10000;
    private static final long REFRESH_INTERVAL = 60000L;
    public static final String PARAM_LANGUAGE_ID = "SearchParameter/Resource-language";
    public static final String PARAM_LANGUAGE_DESCRIPTION = "Language of the resource content";
    public static final String PARAM_LANGUAGE_PATH = "language";
    public static final String PARAM_TEXT_DESCRIPTION = "Text search against the narrative";
    public static final String PARAM_CONTENT_DESCRIPTION = "Search on the entire content of the resource";
    private JpaSearchParamCache myJpaSearchParamCache;
    @Autowired
    private StorageSettings myStorageSettings;
    @Autowired
    private ISearchParamProvider mySearchParamProvider;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private SearchParameterCanonicalizer mySearchParameterCanonicalizer;
    @Autowired
    private IInterceptorService myInterceptorBroadcaster;
    @Autowired
    private IResourceChangeListenerRegistry myResourceChangeListenerRegistry;
    @Autowired
    private PartitionSettings myPartitionSettings;
    @Autowired
    private ObjectProvider<ISearchParamIdentityCacheSvc> mySearchParamIdentityCacheSvcProvider;
    private IResourceChangeListenerCache myResourceChangeListenerCache;
    private volatile ReadOnlySearchParamCache myBuiltInSearchParams;
    private volatile IPhoneticEncoder myPhoneticEncoder;
    private volatile RuntimeSearchParamCache myActiveSearchParams;
    private boolean myPrePopulateSearchParamIdentities = true;

    @VisibleForTesting
    public void setPopulateSearchParamIdentities(boolean myPrePopulateSearchParamIdentities) {
        this.myPrePopulateSearchParamIdentities = myPrePopulateSearchParamIdentities;
    }

    @PostConstruct
    public void start() {
        this.myJpaSearchParamCache = new JpaSearchParamCache(this.myPartitionSettings);
    }

    public RuntimeSearchParam getActiveSearchParam(@Nonnull String theResourceName, @Nonnull String theParamName, @Nonnull ISearchParamRegistry.SearchParamLookupContextEnum theContext) {
        RuntimeSearchParam param;
        this.requiresActiveSearchParams();
        if (this.myActiveSearchParams != null && (param = this.myActiveSearchParams.get(theResourceName, theParamName)) != null && ISearchParamRegistry.isAllowedForContext((RuntimeSearchParam)param, (ISearchParamRegistry.SearchParamLookupContextEnum)theContext)) {
            return param;
        }
        return null;
    }

    @Nonnull
    public ResourceSearchParams getActiveSearchParams(@Nonnull String theResourceName, @Nonnull ISearchParamRegistry.SearchParamLookupContextEnum theContext) {
        this.requiresActiveSearchParams();
        return this.getActiveSearchParams().getSearchParamMap(theResourceName).toFilteredForContext(theContext);
    }

    private void requiresActiveSearchParams() {
        if (this.myActiveSearchParams == null) {
            this.myResourceChangeListenerCache.forceRefresh();
        }
    }

    public List<RuntimeSearchParam> getActiveComboSearchParams(@Nonnull String theResourceName, @Nonnull ISearchParamRegistry.SearchParamLookupContextEnum theContext) {
        return SearchParamRegistryImpl.filteredForContext(this.myJpaSearchParamCache.getActiveComboSearchParams(theResourceName), theContext);
    }

    public List<RuntimeSearchParam> getActiveComboSearchParams(@Nonnull String theResourceName, @Nonnull ComboSearchParamType theParamType, @Nonnull ISearchParamRegistry.SearchParamLookupContextEnum theContext) {
        return SearchParamRegistryImpl.filteredForContext(this.myJpaSearchParamCache.getActiveComboSearchParams(theResourceName, theParamType), theContext);
    }

    public List<RuntimeSearchParam> getActiveComboSearchParams(@Nonnull String theResourceName, @Nonnull Set<String> theParamNames, @Nonnull ISearchParamRegistry.SearchParamLookupContextEnum theContext) {
        return SearchParamRegistryImpl.filteredForContext(this.myJpaSearchParamCache.getActiveComboSearchParams(theResourceName, theParamNames), theContext);
    }

    @Nullable
    public RuntimeSearchParam getActiveSearchParamByUrl(@Nonnull String theUrl, @Nonnull ISearchParamRegistry.SearchParamLookupContextEnum theContext) {
        RuntimeSearchParam param;
        if (this.myActiveSearchParams != null && ISearchParamRegistry.isAllowedForContext((RuntimeSearchParam)(param = this.myActiveSearchParams.getByUrl(theUrl)), (ISearchParamRegistry.SearchParamLookupContextEnum)theContext)) {
            return param;
        }
        return null;
    }

    public Optional<RuntimeSearchParam> getActiveComboSearchParamById(@Nonnull String theResourceName, @Nonnull IIdType theId) {
        return this.myJpaSearchParamCache.getActiveComboSearchParamById(theResourceName, theId);
    }

    private void rebuildActiveSearchParams() {
        ourLog.info("Rebuilding SearchParamRegistry");
        SearchParameterMap params = new SearchParameterMap();
        params.setLoadSynchronousUpTo(10000);
        params.setCount(10000);
        IBundleProvider allSearchParamsBp = this.mySearchParamProvider.search(params);
        List allSearchParams = allSearchParamsBp.getResources(0, 10000);
        Integer size = allSearchParamsBp.size();
        ourLog.trace("Loaded {} search params from the DB", (Object)allSearchParams.size());
        if (size == null) {
            ourLog.error("Only {} search parameters have been loaded, but there are more than that in the repository.  Is offset search configured on this server?", (Object)allSearchParams.size());
        } else if (size >= 10000) {
            ourLog.warn("Unable to support >10000 search params!");
        }
        this.initializeActiveSearchParams(allSearchParams);
    }

    private void initializeActiveSearchParams(Collection<IBaseResource> theJpaSearchParams) {
        StopWatch sw = new StopWatch();
        ReadOnlySearchParamCache builtInSearchParams = this.getBuiltInSearchParams();
        RuntimeSearchParamCache searchParams = RuntimeSearchParamCache.fromReadOnlySearchParamCache(builtInSearchParams);
        long overriddenCount = this.overrideBuiltinSearchParamsWithActiveJpaSearchParams(searchParams, theJpaSearchParams);
        ourLog.trace("Have overridden {} built-in search parameters", (Object)overriddenCount);
        if (this.myStorageSettings.isLanguageSearchParameterEnabled()) {
            this.registerImplicitSearchParam(searchParams, "http://hl7.org/fhir/SearchParameter/Resource-language", "_language", PARAM_LANGUAGE_DESCRIPTION, PARAM_LANGUAGE_PATH, RestSearchParameterTypeEnum.TOKEN);
        } else {
            this.unregisterImplicitSearchParam(searchParams, "_language");
        }
        if (this.myStorageSettings.isHibernateSearchIndexFullText()) {
            this.registerImplicitSearchParam(searchParams, "http://hl7.org/fhir/SearchParameter/DomainResource-text", "_text", PARAM_TEXT_DESCRIPTION, "Resource", RestSearchParameterTypeEnum.STRING);
            this.registerImplicitSearchParam(searchParams, "http://hl7.org/fhir/SearchParameter/Resource-content", "_content", PARAM_CONTENT_DESCRIPTION, "Resource", RestSearchParameterTypeEnum.STRING);
        } else {
            this.unregisterImplicitSearchParam(searchParams, "_content");
            this.unregisterImplicitSearchParam(searchParams, "_text");
        }
        this.removeInactiveSearchParams(searchParams);
        this.setActiveSearchParams(searchParams);
        this.myJpaSearchParamCache.populateActiveSearchParams(this.myInterceptorBroadcaster, this.myPhoneticEncoder, this.myActiveSearchParams);
        this.updateSearchParameterIdentityCache();
        ourLog.debug("Refreshed search parameter cache in {}ms", (Object)sw.getMillis());
    }

    private void unregisterImplicitSearchParam(RuntimeSearchParamCache theSearchParams, String theParamName) {
        for (String resourceType : theSearchParams.getResourceNameKeys()) {
            theSearchParams.remove(resourceType, theParamName);
        }
    }

    private void registerImplicitSearchParam(RuntimeSearchParamCache searchParams, String url, String code, String description, String path, RestSearchParameterTypeEnum type) {
        if (searchParams.getByUrl(url) == null) {
            RuntimeSearchParam sp = new RuntimeSearchParam(this.myFhirContext.getVersion().newIdType(PARAM_LANGUAGE_ID), url, code, description, path, type, Collections.emptySet(), Collections.emptySet(), RuntimeSearchParam.RuntimeSearchParamStatusEnum.ACTIVE, (Collection)this.myFhirContext.getResourceTypes());
            for (String baseResourceType : sp.getBase()) {
                searchParams.add(baseResourceType, sp.getName(), sp);
            }
        }
    }

    private void updateSearchParameterIdentityCache() {
        if (!this.myPrePopulateSearchParamIdentities) {
            return;
        }
        ISearchParamIdentityCacheSvc spIdentityCacheSvc = (ISearchParamIdentityCacheSvc)this.mySearchParamIdentityCacheSvcProvider.getIfAvailable();
        if (spIdentityCacheSvc == null) {
            return;
        }
        this.myJpaSearchParamCache.getHashIdentityToIndexedSearchParamMap().forEach((hash, param) -> spIdentityCacheSvc.findOrCreateSearchParamIdentity((Long)hash, param.getResourceType(), param.getParameterName()));
    }

    @VisibleForTesting
    public Map<Long, IndexedSearchParam> getHashIdentityToIndexedSearchParamMap() {
        return this.myJpaSearchParamCache.getHashIdentityToIndexedSearchParamMap();
    }

    @VisibleForTesting
    public void setFhirContext(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    private ReadOnlySearchParamCache getBuiltInSearchParams() {
        if (this.myBuiltInSearchParams == null) {
            this.myBuiltInSearchParams = this.myStorageSettings.isAutoSupportDefaultSearchParams() ? ReadOnlySearchParamCache.fromFhirContext(this.myFhirContext, this.mySearchParameterCanonicalizer) : ReadOnlySearchParamCache.fromFhirContext(this.myFhirContext, this.mySearchParameterCanonicalizer, NON_DISABLEABLE_SEARCH_PARAMS);
        }
        return this.myBuiltInSearchParams;
    }

    private void removeInactiveSearchParams(RuntimeSearchParamCache theSearchParams) {
        for (String resourceName : theSearchParams.getResourceNameKeys()) {
            ResourceSearchParams resourceSearchParams = theSearchParams.getSearchParamMap(resourceName);
            resourceSearchParams.removeInactive();
        }
    }

    @VisibleForTesting
    public void setStorageSettings(StorageSettings theStorageSettings) {
        this.myStorageSettings = theStorageSettings;
    }

    private long overrideBuiltinSearchParamsWithActiveJpaSearchParams(RuntimeSearchParamCache theSearchParamCache, Collection<IBaseResource> theSearchParams) {
        if (!this.myStorageSettings.isDefaultSearchParamsCanBeOverridden() || theSearchParams == null) {
            return 0L;
        }
        long retval = 0L;
        for (IBaseResource searchParam : theSearchParams) {
            retval += this.overrideSearchParam(theSearchParamCache, searchParam);
        }
        return retval;
    }

    private long overrideSearchParam(RuntimeSearchParamCache theSearchParams, IBaseResource theSearchParameter) {
        if (theSearchParameter == null) {
            return 0L;
        }
        RuntimeSearchParam runtimeSp = this.mySearchParameterCanonicalizer.canonicalizeSearchParameter(theSearchParameter);
        if (runtimeSp == null) {
            return 0L;
        }
        if (runtimeSp.getStatus() == RuntimeSearchParam.RuntimeSearchParamStatusEnum.DRAFT) {
            return 0L;
        }
        String url = runtimeSp.getUri();
        RuntimeSearchParam existingParam = theSearchParams.getByUrl(url);
        if (existingParam != null) {
            if (StringUtils.isNotBlank((CharSequence)existingParam.getName()) && !existingParam.getName().equals(runtimeSp.getName())) {
                ourLog.warn("Existing SearchParameter with URL[{}] and name[{}] doesn't match name[{}] found on SearchParameter: {}", new Object[]{url, existingParam.getName(), runtimeSp.getName(), runtimeSp.getId()});
            } else {
                Set<String> expandedBases = this.expandBaseList(existingParam.getBase());
                for (String base : expandedBases) {
                    theSearchParams.remove(base, existingParam.getName());
                }
            }
        }
        long retval = 0L;
        for (String nextBaseName : this.expandBaseList(SearchParameterUtil.getBaseAsStrings((FhirContext)this.myFhirContext, (IBaseResource)theSearchParameter))) {
            String name = runtimeSp.getName();
            theSearchParams.add(nextBaseName, name, runtimeSp);
            ourLog.debug("Adding search parameter {}.{} to SearchParamRegistry", (Object)nextBaseName, (Object)Objects.toString(name, "[composite]"));
            ++retval;
        }
        return retval;
    }

    @Nonnull
    private Set<String> expandBaseList(Collection<String> nextBase) {
        HashSet<String> expandedBases = new HashSet<String>();
        for (String base : nextBase) {
            if ("Resource".equals(base) || "DomainResource".equals(base)) {
                expandedBases.addAll(this.myFhirContext.getResourceTypes());
                break;
            }
            expandedBases.add(base);
        }
        return expandedBases;
    }

    public void requestRefresh() {
        this.myResourceChangeListenerCache.requestRefresh();
    }

    public void forceRefresh() {
        RuntimeSearchParamCache activeSearchParams = this.myActiveSearchParams;
        this.myResourceChangeListenerCache.forceRefresh();
        if (this.myActiveSearchParams == activeSearchParams) {
            this.rebuildActiveSearchParams();
        }
    }

    @Override
    public ResourceChangeResult refreshCacheIfNecessary() {
        return this.myResourceChangeListenerCache.refreshCacheIfNecessary();
    }

    @VisibleForTesting
    public void setResourceChangeListenerRegistry(IResourceChangeListenerRegistry theResourceChangeListenerRegistry) {
        this.myResourceChangeListenerRegistry = theResourceChangeListenerRegistry;
    }

    @PostConstruct
    public void registerListener() {
        SearchParameterMap spMap = SearchParameterMap.newSynchronous();
        spMap.setLoadSynchronousUpTo(10000);
        this.myResourceChangeListenerCache = this.myResourceChangeListenerRegistry.registerResourceResourceChangeListener("SearchParameter", spMap, this, 60000L);
    }

    @PreDestroy
    public void unregisterListener() {
        this.myResourceChangeListenerRegistry.unregisterResourceResourceChangeListener(this);
    }

    public ReadOnlySearchParamCache getActiveSearchParams() {
        this.requiresActiveSearchParams();
        if (this.myActiveSearchParams == null) {
            throw new IllegalStateException(Msg.code((int)511) + "SearchParamRegistry has not been initialized");
        }
        return ReadOnlySearchParamCache.fromRuntimeSearchParamCache(this.myActiveSearchParams);
    }

    @VisibleForTesting
    public void setActiveSearchParams(RuntimeSearchParamCache theSearchParams) {
        this.myActiveSearchParams = theSearchParams;
    }

    public void setPhoneticEncoder(IPhoneticEncoder thePhoneticEncoder) {
        this.myPhoneticEncoder = thePhoneticEncoder;
        if (this.myActiveSearchParams == null) {
            return;
        }
        this.myActiveSearchParams.getSearchParamStream().forEach(searchParam -> this.myJpaSearchParamCache.setPhoneticEncoder(this.myPhoneticEncoder, (RuntimeSearchParam)searchParam));
    }

    @Override
    public void handleChange(IResourceChangeEvent theResourceChangeEvent) {
        if (theResourceChangeEvent.isEmpty()) {
            return;
        }
        ResourceChangeResult result = ResourceChangeResult.fromResourceChangeEvent(theResourceChangeEvent);
        if (result.created > 0L) {
            ourLog.info("Adding {} search parameters to SearchParamRegistry: {}", (Object)result.created, (Object)this.unqualified(theResourceChangeEvent.getCreatedResourceIds()));
        }
        if (result.updated > 0L) {
            ourLog.info("Updating {} search parameters in SearchParamRegistry: {}", (Object)result.updated, (Object)this.unqualified(theResourceChangeEvent.getUpdatedResourceIds()));
        }
        if (result.deleted > 0L) {
            ourLog.info("Deleting {} search parameters from SearchParamRegistry: {}", (Object)result.deleted, (Object)this.unqualified(theResourceChangeEvent.getDeletedResourceIds()));
        }
        this.rebuildActiveSearchParams();
    }

    private String unqualified(List<IIdType> theIds) {
        Iterator unqualifiedIds = theIds.stream().map(IIdType::toUnqualifiedVersionless).map(IIdType::getValue).iterator();
        return StringUtils.join(unqualifiedIds, (String)", ");
    }

    @Override
    public void handleInit(Collection<IIdType> theResourceIds) {
        ArrayList<IBaseResource> searchParams = new ArrayList<IBaseResource>();
        for (IIdType id : theResourceIds) {
            try {
                IBaseResource searchParam = this.mySearchParamProvider.read(id);
                searchParams.add(searchParam);
            }
            catch (ResourceNotFoundException e) {
                ourLog.warn("SearchParameter {} not found.  Excluding from list of active search params.", (Object)id);
            }
        }
        this.initializeActiveSearchParams(searchParams);
    }

    public boolean isInitialized() {
        return this.myActiveSearchParams != null;
    }

    @VisibleForTesting
    public void resetForUnitTest() {
        this.myBuiltInSearchParams = null;
        this.setActiveSearchParams(null);
        this.handleInit(Collections.emptyList());
    }

    @VisibleForTesting
    public void setSearchParameterCanonicalizerForUnitTest(SearchParameterCanonicalizer theSearchParameterCanonicalizerForUnitTest) {
        this.mySearchParameterCanonicalizer = theSearchParameterCanonicalizerForUnitTest;
    }

    private static List<RuntimeSearchParam> filteredForContext(List<RuntimeSearchParam> theActiveComboSearchParams, ISearchParamRegistry.SearchParamLookupContextEnum theContext) {
        return theActiveComboSearchParams.stream().filter(t -> ISearchParamRegistry.isAllowedForContext((RuntimeSearchParam)t, (ISearchParamRegistry.SearchParamLookupContextEnum)theContext)).collect(Collectors.toList());
    }
}

