/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.util;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class Dstu3DistanceHelper {
    public static void setNearDistance(Class<? extends IBaseResource> theResourceType, SearchParameterMap theParams) {
        List<List<IQueryParameterType>> paramAndList;
        ReferenceParam referenceParam;
        if (theResourceType == Location.class && theParams.containsKey("near-distance")) {
            List<List<IQueryParameterType>> paramAndList2 = theParams.get("near-distance");
            QuantityParam quantityParam = Dstu3DistanceHelper.getNearDistanceParam(paramAndList2);
            theParams.setNearDistanceParam(quantityParam);
            theParams.remove("near-distance");
        } else if (theParams.containsKey("location") && (referenceParam = Dstu3DistanceHelper.getChainedLocationNearDistanceParam(paramAndList = theParams.get("location"))) != null) {
            QuantityParam quantityParam = new QuantityParam(referenceParam.getValue());
            theParams.setNearDistanceParam(quantityParam);
        }
    }

    private static ReferenceParam getChainedLocationNearDistanceParam(List<List<IQueryParameterType>> theParamAndList) {
        ReferenceParam retval = null;
        List<IQueryParameterType> andParamToRemove = null;
        for (List<IQueryParameterType> paramOrList : theParamAndList) {
            IQueryParameterType orParamToRemove = null;
            for (IQueryParameterType param : paramOrList) {
                ReferenceParam referenceParam;
                if (!(param instanceof ReferenceParam) || !"near-distance".equals((referenceParam = (ReferenceParam)param).getChain())) continue;
                if (retval != null) {
                    throw new IllegalArgumentException(Msg.code((int)494) + "Only one near-distance parameter may be present");
                }
                retval = referenceParam;
                orParamToRemove = param;
            }
            if (orParamToRemove == null) continue;
            paramOrList.remove(orParamToRemove);
            if (!paramOrList.isEmpty()) continue;
            andParamToRemove = paramOrList;
        }
        if (andParamToRemove != null) {
            theParamAndList.remove(andParamToRemove);
        }
        return retval;
    }

    private static QuantityParam getNearDistanceParam(List<List<IQueryParameterType>> theParamAndList) {
        long sum = theParamAndList.stream().mapToLong(Collection::size).sum();
        if (sum == 0L) {
            return null;
        }
        if (sum == 1L) {
            return (QuantityParam)theParamAndList.get(0).get(0);
        }
        throw new IllegalArgumentException(Msg.code((int)495) + "Only one near-distance parameter may be present");
    }
}

