/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.util;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import jakarta.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class RuntimeSearchParamHelper {
    public static boolean isResourceLevel(RuntimeSearchParam theSearchParam) {
        return StringUtils.startsWith((CharSequence)theSearchParam.getPath(), (CharSequence)"Resource.");
    }

    public static boolean isSpeciallyHandledSearchParameter(@Nonnull RuntimeSearchParam theSearchParameter, StorageSettings theStorageSettings) {
        return switch (StringUtils.defaultString((String)theSearchParameter.getName())) {
            case "_content" -> true;
            case "_has" -> true;
            case "_id" -> true;
            case "_in" -> true;
            case "_lastUpdated" -> true;
            case "_language" -> false;
            case "_source" -> true;
            case "_text" -> true;
            case "_profile", "_tag", "_security" -> {
                if (theStorageSettings.getTagStorageMode() != StorageSettings.TagStorageModeEnum.INLINE) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

