/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.channel.subscription;

import ca.uhn.fhir.jpa.subscription.channel.api.ChannelConsumerSettings;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelFactory;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelProducer;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelReceiver;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryJsonMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedJsonMessage;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.support.AbstractSubscribableChannel;
import org.springframework.messaging.support.ChannelInterceptor;

public class SubscriptionChannelFactory {
    private final IChannelFactory myQueueChannelFactory;

    public SubscriptionChannelFactory(IChannelFactory theQueueChannelFactory) {
        Validate.notNull((Object)theQueueChannelFactory);
        this.myQueueChannelFactory = theQueueChannelFactory;
    }

    public IChannelProducer newDeliverySendingChannel(String theChannelName, ChannelConsumerSettings theOptions) {
        ChannelConsumerSettings config = this.newConfigForDeliveryChannel(theOptions);
        return this.myQueueChannelFactory.getOrCreateProducer(theChannelName, ResourceDeliveryJsonMessage.class, config);
    }

    public IChannelReceiver newDeliveryReceivingChannel(String theChannelName, ChannelConsumerSettings theOptions) {
        ChannelConsumerSettings config = this.newConfigForDeliveryChannel(theOptions);
        IChannelReceiver channel = this.myQueueChannelFactory.getOrCreateReceiver(theChannelName, ResourceDeliveryJsonMessage.class, config);
        return new BroadcastingSubscribableChannelWrapper(channel);
    }

    public IChannelProducer newMatchingSendingChannel(String theChannelName, ChannelConsumerSettings theOptions) {
        ChannelConsumerSettings config = this.newConfigForMatchingChannel(theOptions);
        return this.myQueueChannelFactory.getOrCreateProducer(theChannelName, ResourceModifiedJsonMessage.class, config);
    }

    public IChannelReceiver newMatchingReceivingChannel(String theChannelName, ChannelConsumerSettings theOptions) {
        ChannelConsumerSettings config = this.newConfigForMatchingChannel(theOptions);
        IChannelReceiver channel = this.myQueueChannelFactory.getOrCreateReceiver(theChannelName, ResourceModifiedJsonMessage.class, config);
        return new BroadcastingSubscribableChannelWrapper(channel);
    }

    protected ChannelConsumerSettings newConfigForDeliveryChannel(ChannelConsumerSettings theOptions) {
        ChannelConsumerSettings config = new ChannelConsumerSettings();
        config.setConcurrentConsumers(this.getDeliveryChannelConcurrentConsumers());
        return config;
    }

    protected ChannelConsumerSettings newConfigForMatchingChannel(ChannelConsumerSettings theOptions) {
        ChannelConsumerSettings config = new ChannelConsumerSettings();
        config.setConcurrentConsumers(this.getMatchingChannelConcurrentConsumers());
        return config;
    }

    public int getDeliveryChannelConcurrentConsumers() {
        return 5;
    }

    public int getMatchingChannelConcurrentConsumers() {
        return 5;
    }

    public static class BroadcastingSubscribableChannelWrapper
    extends AbstractSubscribableChannel
    implements IChannelReceiver,
    DisposableBean {
        private final IChannelReceiver myWrappedChannel;

        public BroadcastingSubscribableChannelWrapper(IChannelReceiver theChannel) {
            theChannel.subscribe(message -> this.send(message));
            this.myWrappedChannel = theChannel;
        }

        public SubscribableChannel getWrappedChannel() {
            return this.myWrappedChannel;
        }

        protected boolean sendInternal(Message<?> theMessage, long timeout) {
            for (MessageHandler next : this.getSubscribers()) {
                next.handleMessage(theMessage);
            }
            return true;
        }

        public void destroy() throws Exception {
            if (this.myWrappedChannel instanceof DisposableBean) {
                ((DisposableBean)this.myWrappedChannel).destroy();
            }
        }

        public void addInterceptor(ChannelInterceptor interceptor) {
            super.addInterceptor(interceptor);
            this.myWrappedChannel.addInterceptor(interceptor);
        }
    }
}

