/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.channel.subscription;

import ca.uhn.fhir.jpa.subscription.channel.api.IChannelProducer;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelReceiver;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionChannelCache;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionChannelFactory;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionChannelWithHandlers;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionDeliveryHandlerFactory;
import ca.uhn.fhir.jpa.subscription.match.registry.ActiveSubscription;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionRegistry;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;

public class SubscriptionChannelRegistry {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionRegistry.class);
    private final SubscriptionChannelCache myDeliveryReceiverChannels = new SubscriptionChannelCache();
    private final Multimap<String, String> myActiveSubscriptionByChannelName = MultimapBuilder.hashKeys().arrayListValues().build();
    private final Map<String, IChannelProducer> myChannelNameToSender = new ConcurrentHashMap<String, IChannelProducer>();
    @Autowired
    private SubscriptionDeliveryHandlerFactory mySubscriptionDeliveryHandlerFactory;
    @Autowired
    private SubscriptionChannelFactory mySubscriptionDeliveryChannelFactory;

    public synchronized void add(ActiveSubscription theActiveSubscription) {
        String channelName = theActiveSubscription.getChannelName();
        ourLog.info("Adding subscription {} to channel {}", (Object)theActiveSubscription.getId(), (Object)channelName);
        this.myActiveSubscriptionByChannelName.put((Object)channelName, (Object)theActiveSubscription.getId());
        if (this.myDeliveryReceiverChannels.containsKey(channelName)) {
            ourLog.info("Channel {} already exists.  Not creating.", (Object)channelName);
            return;
        }
        IChannelReceiver channelReceiver = this.newReceivingChannel(channelName);
        Optional<MessageHandler> deliveryHandler = this.mySubscriptionDeliveryHandlerFactory.createDeliveryHandler(theActiveSubscription.getChannelType());
        SubscriptionChannelWithHandlers subscriptionChannelWithHandlers = new SubscriptionChannelWithHandlers(channelName, channelReceiver);
        deliveryHandler.ifPresent(subscriptionChannelWithHandlers::addHandler);
        this.myDeliveryReceiverChannels.put(channelName, subscriptionChannelWithHandlers);
        IChannelProducer sendingChannel = this.newSendingChannel(channelName);
        this.myChannelNameToSender.put(channelName, sendingChannel);
    }

    protected IChannelReceiver newReceivingChannel(String theChannelName) {
        return this.mySubscriptionDeliveryChannelFactory.newDeliveryReceivingChannel(theChannelName, null);
    }

    protected IChannelProducer newSendingChannel(String theChannelName) {
        return this.mySubscriptionDeliveryChannelFactory.newDeliverySendingChannel(theChannelName, null);
    }

    public synchronized void remove(ActiveSubscription theActiveSubscription) {
        String channelName = theActiveSubscription.getChannelName();
        ourLog.info("Removing subscription {} from channel {}", (Object)theActiveSubscription.getId(), (Object)channelName);
        boolean removed = this.myActiveSubscriptionByChannelName.remove((Object)channelName, (Object)theActiveSubscription.getId());
        if (!removed) {
            ourLog.warn("Failed to remove subscription {} from channel {}", (Object)theActiveSubscription.getId(), (Object)channelName);
        }
        if (!this.myActiveSubscriptionByChannelName.containsKey((Object)channelName)) {
            SubscriptionChannelWithHandlers channel = this.myDeliveryReceiverChannels.get(channelName);
            if (channel != null) {
                channel.close();
            }
            this.myDeliveryReceiverChannels.closeAndRemove(channelName);
            this.myChannelNameToSender.remove(channelName);
        }
    }

    public synchronized SubscriptionChannelWithHandlers getDeliveryReceiverChannel(String theChannelName) {
        return this.myDeliveryReceiverChannels.get(theChannelName);
    }

    public synchronized MessageChannel getDeliverySenderChannel(String theChannelName) {
        return this.myChannelNameToSender.get(theChannelName);
    }

    public synchronized int size() {
        return this.myDeliveryReceiverChannels.size();
    }
}

