/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.channel.subscription;

import ca.uhn.fhir.jpa.subscription.match.registry.ActiveSubscription;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;

public class SubscriptionChannelWithHandlers
implements Closeable {
    private static final Logger ourLog = LoggerFactory.getLogger(ActiveSubscription.class);
    private final String myChannelName;
    private final SubscribableChannel mySubscribableChannel;
    private final Collection<MessageHandler> myDeliveryHandlerSet = new HashSet<MessageHandler>();

    public SubscriptionChannelWithHandlers(String theChannelName, SubscribableChannel theSubscribableChannel) {
        this.myChannelName = theChannelName;
        this.mySubscribableChannel = theSubscribableChannel;
    }

    public void addHandler(MessageHandler theHandler) {
        this.mySubscribableChannel.subscribe(theHandler);
        this.myDeliveryHandlerSet.add(theHandler);
    }

    public void removeHandler(MessageHandler theMessageHandler) {
        if (this.mySubscribableChannel != null) {
            this.mySubscribableChannel.unsubscribe(theMessageHandler);
        }
    }

    @VisibleForTesting
    public MessageHandler getDeliveryHandlerForUnitTest() {
        return this.myDeliveryHandlerSet.iterator().next();
    }

    @Override
    public void close() {
        for (MessageHandler messageHandler : this.myDeliveryHandlerSet) {
            this.removeHandler(messageHandler);
        }
        if (this.mySubscribableChannel instanceof DisposableBean) {
            this.tryDestroyChannel((DisposableBean)this.mySubscribableChannel);
        }
    }

    private void tryDestroyChannel(DisposableBean theSubscribableChannel) {
        try {
            ourLog.info("Destroying channel {}", (Object)this.myChannelName);
            theSubscribableChannel.destroy();
        }
        catch (Exception e) {
            ourLog.error("Failed to destroy channel bean", (Throwable)e);
        }
    }

    public MessageChannel getChannel() {
        return this.mySubscribableChannel;
    }
}

