/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.config;

import ca.uhn.fhir.jpa.model.entity.ModelConfig;
import ca.uhn.fhir.jpa.subscription.match.deliver.websocket.SubscriptionWebsocketHandler;
import ca.uhn.fhir.jpa.subscription.match.deliver.websocket.WebsocketConnectionValidator;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Controller;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.handler.PerConnectionWebSocketHandler;

@Configuration
@EnableWebSocket
@Controller
public class WebsocketDispatcherConfig
implements WebSocketConfigurer {
    @Autowired
    ModelConfig myModelConfig;

    @Bean
    public WebsocketConnectionValidator websocketConnectionValidator() {
        return new WebsocketConnectionValidator();
    }

    public void registerWebSocketHandlers(WebSocketHandlerRegistry theRegistry) {
        theRegistry.addHandler(this.subscriptionWebSocketHandler(), new String[]{this.myModelConfig.getWebsocketContextPath()}).setAllowedOrigins(new String[]{"*"});
    }

    @Bean(autowire=Autowire.BY_TYPE)
    public WebSocketHandler subscriptionWebSocketHandler() {
        PerConnectionWebSocketHandler retVal = new PerConnectionWebSocketHandler(SubscriptionWebsocketHandler.class);
        return retVal;
    }
}

