/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.deliver;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.subscription.match.registry.ActiveSubscription;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionRegistry;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage;
import com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;

public abstract class BaseSubscriptionDeliverySubscriber
implements MessageHandler {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseSubscriptionDeliverySubscriber.class);
    @Autowired
    protected FhirContext myFhirContext;
    @Autowired
    protected SubscriptionRegistry mySubscriptionRegistry;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;

    public void handleMessage(Message theMessage) throws MessagingException {
        if (!(theMessage.getPayload() instanceof ResourceDeliveryMessage)) {
            ourLog.warn("Unexpected payload type: {}", theMessage.getPayload());
            return;
        }
        ResourceDeliveryMessage msg = (ResourceDeliveryMessage)theMessage.getPayload();
        String subscriptionId = msg.getSubscriptionId(this.myFhirContext);
        if (subscriptionId == null) {
            ourLog.warn("Subscription has no ID, ignoring");
            return;
        }
        ActiveSubscription updatedSubscription = this.mySubscriptionRegistry.get(msg.getSubscription().getIdElement(this.myFhirContext).getIdPart());
        if (updatedSubscription != null) {
            msg.setSubscription(updatedSubscription.getSubscription());
        }
        try {
            HookParams params = new HookParams().add(ResourceDeliveryMessage.class, (Object)msg).add(CanonicalSubscription.class, (Object)msg.getSubscription());
            if (!this.myInterceptorBroadcaster.callHooks(Pointcut.SUBSCRIPTION_BEFORE_DELIVERY, params)) {
                return;
            }
            this.handleMessage(msg);
            this.myInterceptorBroadcaster.callHooks(Pointcut.SUBSCRIPTION_AFTER_DELIVERY, params);
        }
        catch (Exception e) {
            String errorMsg = "Failure handling subscription payload for subscription: " + subscriptionId;
            ourLog.error(errorMsg, (Throwable)e);
            HookParams hookParams = new HookParams().add(ResourceDeliveryMessage.class, (Object)msg).add(Exception.class, (Object)e);
            if (!this.myInterceptorBroadcaster.callHooks(Pointcut.SUBSCRIPTION_AFTER_DELIVERY_FAILED, hookParams)) {
                return;
            }
            throw new MessagingException(theMessage, errorMsg, (Throwable)e);
        }
    }

    public abstract void handleMessage(ResourceDeliveryMessage var1) throws Exception;

    @VisibleForTesting
    public void setFhirContextForUnitTest(FhirContext theCtx) {
        this.myFhirContext = theCtx;
    }

    @VisibleForTesting
    public void setInterceptorBroadcasterForUnitTest(IInterceptorBroadcaster theInterceptorBroadcaster) {
        this.myInterceptorBroadcaster = theInterceptorBroadcaster;
    }

    @VisibleForTesting
    public void setSubscriptionRegistryForUnitTest(SubscriptionRegistry theSubscriptionRegistry) {
        this.mySubscriptionRegistry = theSubscriptionRegistry;
    }

    public IInterceptorBroadcaster getInterceptorBroadcaster() {
        return this.myInterceptorBroadcaster;
    }
}

