/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.deliver.email;

import ca.uhn.fhir.jpa.subscription.match.deliver.email.EmailDetails;
import ca.uhn.fhir.jpa.subscription.match.deliver.email.IEmailSender;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.StopWatch;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.spring5.dialect.SpringStandardDialect;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.StringTemplateResolver;

public class JavaMailEmailSender
implements IEmailSender {
    private static final Logger ourLog = LoggerFactory.getLogger(JavaMailEmailSender.class);
    private String mySmtpServerHostname;
    private int mySmtpServerPort = 25;
    private JavaMailSenderImpl mySender;
    private String mySmtpServerUsername;
    private String mySmtpServerPassword;

    public String getSmtpServerHostname() {
        return this.mySmtpServerHostname;
    }

    public void setSmtpServerHostname(String theSmtpServerHostname) {
        this.mySmtpServerHostname = theSmtpServerHostname;
    }

    public String getSmtpServerPassword() {
        return this.mySmtpServerPassword;
    }

    public void setSmtpServerPassword(String theSmtpServerPassword) {
        this.mySmtpServerPassword = theSmtpServerPassword;
    }

    public int getSmtpServerPort() {
        return this.mySmtpServerPort;
    }

    public void setSmtpServerPort(int theSmtpServerPort) {
        this.mySmtpServerPort = theSmtpServerPort;
    }

    public String getSmtpServerUsername() {
        return this.mySmtpServerUsername;
    }

    public void setSmtpServerUsername(String theSmtpServerUsername) {
        this.mySmtpServerUsername = theSmtpServerUsername;
    }

    @Override
    public void send(EmailDetails theDetails) {
        String subscriptionId = theDetails.getSubscription().toUnqualifiedVersionless().getValue();
        StopWatch sw = new StopWatch();
        StringTemplateResolver templateResolver = new StringTemplateResolver();
        templateResolver.setTemplateMode(TemplateMode.TEXT);
        SpringStandardDialect dialect = new SpringStandardDialect();
        dialect.setEnableSpringELCompiler(true);
        SpringTemplateEngine engine = new SpringTemplateEngine();
        engine.setDialect((IDialect)dialect);
        engine.setEnableSpringELCompiler(true);
        engine.setTemplateResolver((ITemplateResolver)templateResolver);
        Context context = new Context();
        String body = engine.process(theDetails.getBodyTemplate(), (IContext)context);
        String subject = engine.process(theDetails.getSubjectTemplate(), (IContext)context);
        MimeMessage email = this.mySender.createMimeMessage();
        String from = StringUtils.trim((String)theDetails.getFrom());
        ourLog.info("Sending email for subscription {} from [{}] to recipients: [{}]", new Object[]{subscriptionId, from, theDetails.getTo()});
        try {
            email.setFrom(from);
            email.setRecipients(Message.RecipientType.TO, JavaMailEmailSender.toTrimmedCommaSeparatedString(theDetails.getTo()));
            email.setSubject(subject);
            email.setText(body);
            email.setSentDate(new Date());
            email.addHeader("X-FHIR-Subscription", subscriptionId);
        }
        catch (MessagingException e) {
            throw new InternalErrorException("Failed to create email message", (Throwable)e);
        }
        this.mySender.send(email);
        ourLog.info("Done sending email (took {}ms)", (Object)sw.getMillis());
    }

    @PostConstruct
    public void start() {
        Validate.notBlank((CharSequence)this.mySmtpServerHostname, (String)"No SMTP host defined", (Object[])new Object[0]);
        this.mySender = new JavaMailSenderImpl();
        this.mySender.setHost(this.getSmtpServerHostname());
        this.mySender.setPort(this.getSmtpServerPort());
        this.mySender.setUsername(this.getSmtpServerUsername());
        this.mySender.setPassword(this.getSmtpServerPassword());
        this.mySender.setDefaultEncoding(Constants.CHARSET_UTF8.name());
    }

    private static String toTrimmedCommaSeparatedString(List<String> theTo) {
        ArrayList<String> to = new ArrayList<String>();
        for (String next : theTo) {
            if (!StringUtils.isNotBlank((CharSequence)next)) continue;
            to.add(next);
        }
        return StringUtils.join(to, (String)",");
    }
}

