/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.deliver.resthook;

import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.subscription.match.deliver.BaseSubscriptionDeliverySubscriber;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.api.Header;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.api.IHttpClient;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.api.IHttpResponse;
import ca.uhn.fhir.rest.client.api.ServerValidationModeEnum;
import ca.uhn.fhir.rest.client.interceptor.SimpleRequestHeaderInterceptor;
import ca.uhn.fhir.rest.gclient.IDeleteTyped;
import ca.uhn.fhir.rest.server.exceptions.ResourceGoneException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.messaging.MessagingException;

@Scope(value="prototype")
public class SubscriptionDeliveringRestHookSubscriber
extends BaseSubscriptionDeliverySubscriber {
    @Autowired
    private DaoRegistry myDaoRegistry;
    private Logger ourLog = LoggerFactory.getLogger(SubscriptionDeliveringRestHookSubscriber.class);

    protected void deliverPayload(ResourceDeliveryMessage theMsg, CanonicalSubscription theSubscription, EncodingEnum thePayloadType, IGenericClient theClient) {
        IBaseResource payloadResource = this.getAndMassagePayload(theMsg, theSubscription);
        this.doDelivery(theMsg, theSubscription, thePayloadType, theClient, payloadResource);
    }

    protected void doDelivery(ResourceDeliveryMessage theMsg, CanonicalSubscription theSubscription, EncodingEnum thePayloadType, IGenericClient theClient, IBaseResource thePayloadResource) {
        IDeleteTyped operation;
        switch (theMsg.getOperationType()) {
            case CREATE: 
            case UPDATE: {
                if (thePayloadResource == null || thePayloadResource.isEmpty()) {
                    if (thePayloadType != null) {
                        operation = theClient.create().resource(thePayloadResource);
                        break;
                    }
                    this.sendNotification(theMsg);
                    return;
                }
                if (thePayloadType != null) {
                    operation = theClient.update().resource(thePayloadResource);
                    break;
                }
                this.sendNotification(theMsg);
                return;
            }
            case DELETE: {
                operation = theClient.delete().resourceById(theMsg.getPayloadId(this.myFhirContext));
                break;
            }
            default: {
                this.ourLog.warn("Ignoring delivery message of type: {}", (Object)theMsg.getOperationType());
                return;
            }
        }
        if (thePayloadType != null) {
            operation.encoded(thePayloadType);
        }
        String payloadId = null;
        if (thePayloadResource != null) {
            payloadId = thePayloadResource.getIdElement().toUnqualified().getValue();
        }
        this.ourLog.info("Delivering {} rest-hook payload {} for {}", new Object[]{theMsg.getOperationType(), payloadId, theSubscription.getIdElement(this.myFhirContext).toUnqualifiedVersionless().getValue()});
        try {
            operation.execute();
        }
        catch (ResourceNotFoundException e) {
            this.ourLog.error("Cannot reach {} ", (Object)theMsg.getSubscription().getEndpointUrl());
            this.ourLog.error("Exception: ", (Throwable)e);
            throw e;
        }
    }

    public IBaseResource getResource(IIdType payloadId) throws ResourceGoneException {
        RuntimeResourceDefinition resourceDef = this.myFhirContext.getResourceDefinition(payloadId.getResourceType());
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceDef.getImplementingClass());
        return dao.read(payloadId.toVersionless());
    }

    protected IBaseResource getAndMassagePayload(ResourceDeliveryMessage theMsg, CanonicalSubscription theSubscription) {
        IBaseResource payloadResource = theMsg.getPayload(this.myFhirContext);
        if (payloadResource == null || theSubscription.getRestHookDetails().isDeliverLatestVersion()) {
            IIdType payloadId = theMsg.getPayloadId(this.myFhirContext);
            try {
                if (payloadId == null) {
                    return null;
                }
                payloadResource = this.getResource(payloadId.toVersionless());
            }
            catch (ResourceGoneException e) {
                this.ourLog.warn("Resource {} is deleted, not going to deliver for subscription {}", (Object)payloadId.toVersionless(), (Object)theSubscription.getIdElement(this.myFhirContext));
                return null;
            }
        }
        IIdType resourceId = payloadResource.getIdElement();
        if (theSubscription.getRestHookDetails().isStripVersionId()) {
            resourceId = resourceId.toVersionless();
            payloadResource.setId(resourceId);
        }
        return payloadResource;
    }

    @Override
    public void handleMessage(ResourceDeliveryMessage theMessage) throws MessagingException {
        CanonicalSubscription subscription = theMessage.getSubscription();
        HookParams params = new HookParams().add(CanonicalSubscription.class, (Object)subscription).add(ResourceDeliveryMessage.class, (Object)theMessage);
        if (!this.getInterceptorBroadcaster().callHooks(Pointcut.SUBSCRIPTION_BEFORE_REST_HOOK_DELIVERY, params)) {
            return;
        }
        String endpointUrl = subscription.getEndpointUrl();
        String payloadString = subscription.getPayloadString();
        EncodingEnum payloadType = null;
        if (payloadString != null) {
            payloadType = EncodingEnum.forContentType((String)payloadString);
        }
        this.myFhirContext.getRestfulClientFactory().setServerValidationMode(ServerValidationModeEnum.NEVER);
        IGenericClient client = null;
        if (StringUtils.isNotBlank((CharSequence)endpointUrl)) {
            client = this.myFhirContext.newRestfulGenericClient(endpointUrl);
            List<String> headers = subscription.getHeaders();
            for (String next : headers) {
                if (!StringUtils.isNotBlank((CharSequence)next)) continue;
                client.registerInterceptor((Object)new SimpleRequestHeaderInterceptor(next));
            }
        }
        this.deliverPayload(theMessage, subscription, payloadType, client);
        params = new HookParams().add(CanonicalSubscription.class, (Object)subscription).add(ResourceDeliveryMessage.class, (Object)theMessage);
        if (!this.getInterceptorBroadcaster().callHooks(Pointcut.SUBSCRIPTION_AFTER_REST_HOOK_DELIVERY, params)) {
            return;
        }
    }

    protected void sendNotification(ResourceDeliveryMessage theMsg) {
        HashMap params = new HashMap();
        ArrayList headers = new ArrayList();
        if (theMsg.getSubscription().getHeaders() != null) {
            theMsg.getSubscription().getHeaders().stream().filter(Objects::nonNull).forEach(h -> {
                int sep = h.indexOf(58);
                if (sep > 0) {
                    String name = h.substring(0, sep);
                    String value = h.substring(sep + 1);
                    if (StringUtils.isNotBlank((CharSequence)name)) {
                        headers.add(new Header(name.trim(), value.trim()));
                    }
                }
            });
        }
        StringBuilder url = new StringBuilder(theMsg.getSubscription().getEndpointUrl());
        IHttpClient client = this.myFhirContext.getRestfulClientFactory().getHttpClient(url, params, "", RequestTypeEnum.POST, headers);
        IHttpRequest request = client.createParamRequest(this.myFhirContext, params, null);
        try {
            IHttpResponse response = request.execute();
            response.close();
        }
        catch (IOException e) {
            this.ourLog.error("Error trying to reach " + theMsg.getSubscription().getEndpointUrl());
            e.printStackTrace();
            throw new ResourceNotFoundException(e.getMessage());
        }
    }
}

