/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.deliver.websocket;

import ca.uhn.fhir.jpa.subscription.match.deliver.websocket.WebsocketValidationResponse;
import ca.uhn.fhir.jpa.subscription.match.registry.ActiveSubscription;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionRegistry;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscriptionChannelType;
import com.sun.istack.NotNull;
import org.hl7.fhir.r4.model.IdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class WebsocketConnectionValidator {
    private static Logger ourLog = LoggerFactory.getLogger(WebsocketConnectionValidator.class);
    @Autowired
    SubscriptionRegistry mySubscriptionRegistry;

    public WebsocketValidationResponse validate(@NotNull IdType id) {
        ActiveSubscription activeSubscription;
        if (!id.hasIdPart() || !id.isIdPartValid()) {
            return WebsocketValidationResponse.INVALID_RESPONSE("Invalid bind request - No ID included: " + id.getValue());
        }
        if (!id.hasResourceType()) {
            id = id.withResourceType("Subscription");
        }
        if ((activeSubscription = this.mySubscriptionRegistry.get(id.getIdPart())) == null) {
            return WebsocketValidationResponse.INVALID_RESPONSE("Invalid bind request - Unknown subscription: " + id.getValue());
        }
        if (activeSubscription.getSubscription().getChannelType() != CanonicalSubscriptionChannelType.WEBSOCKET) {
            return WebsocketValidationResponse.INVALID_RESPONSE("Subscription " + id.getValue() + " is not a " + (Object)((Object)CanonicalSubscriptionChannelType.WEBSOCKET) + " subscription");
        }
        return WebsocketValidationResponse.VALID_RESPONSE(activeSubscription);
    }
}

