/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.matcher.matching;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.ISubscriptionMatcher;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DaoSubscriptionMatcher
implements ISubscriptionMatcher {
    @Autowired
    DaoRegistry myDaoRegistry;
    @Autowired
    MatchUrlService myMatchUrlService;
    private Logger ourLog = LoggerFactory.getLogger(DaoSubscriptionMatcher.class);
    @Autowired
    private FhirContext myCtx;

    @Override
    public InMemoryMatchResult match(CanonicalSubscription theSubscription, ResourceModifiedMessage theMsg) {
        IIdType id = theMsg.getId(this.myCtx);
        String resourceType = id.getResourceType();
        String resourceId = id.getIdPart();
        String criteria = theSubscription.getCriteriaString();
        criteria = criteria + "&_id=" + resourceType + "/" + resourceId;
        IBundleProvider results = this.performSearch(criteria);
        this.ourLog.debug("Subscription check found {} results for query: {}", (Object)results.size(), (Object)criteria);
        return InMemoryMatchResult.fromBoolean((results.size() > 0 ? 1 : 0) != 0);
    }

    private IBundleProvider performSearch(String theCriteria) {
        IFhirResourceDao subscriptionDao = this.myDaoRegistry.getSubscriptionDao();
        RuntimeResourceDefinition responseResourceDef = subscriptionDao.validateCriteriaAndReturnResourceDefinition(theCriteria);
        SearchParameterMap responseCriteriaUrl = this.myMatchUrlService.translateMatchUrl(theCriteria, responseResourceDef);
        IFhirResourceDao responseDao = this.myDaoRegistry.getResourceDao(responseResourceDef.getImplementingClass());
        responseCriteriaUrl.setLoadSynchronousUpTo(Integer.valueOf(1));
        return responseDao.search(responseCriteriaUrl);
    }
}

