/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.matcher.subscriber;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.model.dstu2.valueset.ResourceTypeEnum;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.MessageHandler;

public abstract class BaseSubscriberForSubscriptionResources
implements MessageHandler {
    @Autowired
    protected FhirContext myFhirContext;

    protected boolean isSubscription(ResourceModifiedMessage theNewResource) {
        IBaseResource payload;
        String payloadIdType = null;
        IIdType payloadId = theNewResource.getId(this.myFhirContext);
        if (payloadId != null) {
            payloadIdType = payloadId.getResourceType();
        }
        if (StringUtils.isBlank(payloadIdType) && (payload = theNewResource.getNewPayload(this.myFhirContext)) != null) {
            payloadIdType = this.myFhirContext.getResourceDefinition(payload).getName();
        }
        return ResourceTypeEnum.SUBSCRIPTION.getCode().equals(payloadIdType);
    }
}

