/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.matcher.subscriber;

import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionChannelFactory;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionActivatingSubscriber;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionMatchingSubscriber;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionRegisteringSubscriber;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;

public class MatchingQueueSubscriberLoader {
    private Logger ourLog = LoggerFactory.getLogger(MatchingQueueSubscriberLoader.class);
    @Autowired
    private SubscriptionMatchingSubscriber mySubscriptionMatchingSubscriber;
    @Autowired
    private SubscriptionChannelFactory mySubscriptionChannelFactory;
    @Autowired
    private SubscriptionRegisteringSubscriber mySubscriptionRegisteringSubscriber;
    @Autowired
    private SubscriptionActivatingSubscriber mySubscriptionActivatingSubscriber;
    protected SubscribableChannel myMatchingChannel;

    @EventListener(classes={ContextRefreshedEvent.class})
    public void handleContextRefreshEvent() {
        if (this.myMatchingChannel == null) {
            this.myMatchingChannel = this.mySubscriptionChannelFactory.newMatchingReceivingChannel("subscription-matching", null);
        }
        if (this.myMatchingChannel != null) {
            this.myMatchingChannel.subscribe((MessageHandler)this.mySubscriptionMatchingSubscriber);
            this.myMatchingChannel.subscribe((MessageHandler)this.mySubscriptionActivatingSubscriber);
            this.myMatchingChannel.subscribe((MessageHandler)this.mySubscriptionRegisteringSubscriber);
            this.ourLog.info("Subscription Matching Subscriber subscribed to Matching Channel {} with name {}", (Object)this.myMatchingChannel.getClass().getName(), (Object)"subscription-matching");
        }
    }

    @PreDestroy
    public void stop() {
        if (this.myMatchingChannel != null) {
            this.myMatchingChannel.unsubscribe((MessageHandler)this.mySubscriptionMatchingSubscriber);
            this.myMatchingChannel.unsubscribe((MessageHandler)this.mySubscriptionActivatingSubscriber);
            this.myMatchingChannel.unsubscribe((MessageHandler)this.mySubscriptionRegisteringSubscriber);
        }
    }
}

